<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_flipclock_func( $atts ) {

	extract( shortcode_atts( array(
    	"end_date" => "",
        "background" => "light",
        "seconds" => "show",
        "align" => "",
    	"css" => "",
   	), $atts ) );

	ob_start();

    wp_enqueue_script( 'flipclock' );
    wp_enqueue_script( 'datejs' );

    $class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;

    if(!empty($end_date)) {
        $futureDate = $end_date;
    } else {
        $futureDate = date("Y/m/d");
    }

    $uniqueID = uniqid();

   	?>

   	<div class="autoroyal-flipclock autoroyal-flipclock-background-<?php echo esc_attr($background); ?> autoroyal-flipclock-align-<?php echo esc_attr($align); ?> <?php echo esc_attr($class_to_filter); ?>">
        
        <div class="clock clock-id-<?php echo esc_attr($uniqueID); ?>"></div>
        
        <script type="text/javascript">

            var clock;
            jQuery(document).ready(function() {

                // Grab the current date
                var currentDate = new Date();

                // Show secconds
                var showSeconds = true;

                <?php if($seconds == "hide") { ?>
                    showSeconds = false;
                <?php } ?>

                var futureDate = Date.parse("<?php echo esc_attr($futureDate); ?>");

                // Calculate the difference in seconds between the future and current date
                var diff = futureDate.getTime() / 1000 - currentDate.getTime() / 1000;

                // Instantiate a coutdown FlipClock
                clock =  jQuery('.clock-id-<?php echo esc_attr($uniqueID); ?>').FlipClock(diff, {
                    clockFace: 'DailyCounter',
                    countdown: true,
                    showSeconds: showSeconds
                });
            });

        </script>

    </div>

    <?php

    return ob_get_clean();

}
add_shortcode( 'autoroyal_flipclock', 'autoroyal_flipclock_func' );

vc_map( array(
  	'name' => esc_html__( 'FlipClock Countdown', 'autoroyal' ),
	'base' => 'autoroyal_flipclock',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal social links', 'autoroyal' ),
	'params' => array(
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("End date in this format: YYYY/MM/DD HH:MM:SS", "autoroyal"),
            "param_name" => "end_date",
            "admin_label" => true,
            "value" => "2017/12/24 12:25:10",
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Background Type', 'autoroyal' ),
            'param_name' => 'background',
            'description' => esc_html__( 'Select Background type.', 'autoroyal' ),
            'value' => array(
                __( 'Light', 'autoroyal' ) => 'light',
                __( 'Dark', 'autoroyal' ) => 'dark',
            ),
            'std' => 'light',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Align', 'autoroyal' ),
            'param_name' => 'align',
            'description' => esc_html__( 'Select counter position.', 'autoroyal' ),
            'value' => array(
                __( 'Center', 'autoroyal' ) => 'center',
                __( 'Left', 'autoroyal' ) => 'left',
                __( 'Right', 'autoroyal' ) => 'right',
            ),
            'std' => 'center',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Seconds', 'autoroyal' ),
            'param_name' => 'seconds',
            'description' => esc_html__( 'Show/Hide seconds.', 'autoroyal' ),
            'value' => array(
                __( 'Show', 'autoroyal' ) => 'show',
                __( 'Hide', 'autoroyal' ) => 'hide',
            ),
            'std' => 'show',
        ),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

?>