<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_social_shortcode_func( $atts ) {

	extract( shortcode_atts( array(
    	"twitter_link" => "",
        "facebook_link" => "",
        "dribbble_link" => "",
        "youtube_link" => "",
        "pinterest_link" => "",
        "instagram_link" => "",
        "linkedin_link" => "",
        "bg_type" => "dark",
        "align" => "left",
    	"css" => "",
   	), $atts ) );

	ob_start();

    $class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;

   	?>

   	<div class="footer-social social-background-<?php echo esc_attr($bg_type); ?> <?php echo esc_attr($class_to_filter); ?> social-links-align-<?php echo esc_attr($align); ?>">
        
        <?php if(!empty($twitter_link)) { ?>
        <a class="link-twitter" href="<?php echo esc_url($twitter_link); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" xml:space="preserve" width="38" height="38">
                <circle cx="50" cy="50" r="50"></circle>
                <path d="M71.3,39.4c-1.6,0.7-3.3,1.2-5,1.4c1.8-1.1,3.2-2.8,3.8-4.8c-1.7,1-3.6,1.7-5.6,2.1c-1.6-1.7-3.9-2.8-6.4-2.8 c-4.8,0-8.8,3.9-8.8,8.8c0,0.7,0.1,1.4,0.2,2c-7.3-0.4-13.7-3.9-18-9.1c-0.8,1.3-1.2,2.8-1.2,4.4c0,3,1.5,5.7,3.9,7.3 c-1.4,0-2.8-0.4-4-1.1c0,0,0,0.1,0,0.1c0,4.2,3,7.8,7,8.6c-0.7,0.2-1.5,0.3-2.3,0.3c-0.6,0-1.1-0.1-1.6-0.2c1.1,3.5,4.3,6,8.2,6.1 c-3,2.3-6.8,3.7-10.9,3.7c-0.7,0-1.4,0-2.1-0.1c3.9,2.5,8.5,3.9,13.4,3.9C58.2,70,67,56.7,67,45.1c0-0.4,0-0.8,0-1.1 C68.7,42.7,70.2,41.2,71.3,39.4L71.3,39.4z"></path>
            </svg>
        </a>
        <?php } ?>

        <?php if(!empty($facebook_link)) { ?>
        <a class="link-facebook" href="<?php echo esc_url($facebook_link); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" xml:space="preserve" width="38" height="38">
                <circle cx="50" cy="50" r="50"></circle>
                <path d="M53.3,71.3V51.9h6.5l1-7.6h-7.5v-4.8c0-2.2,0.6-3.7,3.8-3.7l4,0V29c-0.7-0.1-3.1-0.3-5.9-0.3 c-5.8,0-9.8,3.5-9.8,10v5.6h-6.5v7.6h6.5v19.5H53.3z"></path>
            </svg>
        </a>
        <?php } ?>
        <?php if(!empty($dribbble_link)) { ?>
        <a class="link-dribbble" href="<?php echo esc_url($dribbble_link); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" xml:space="preserve" width="38" height="38">
                <circle cx="50" cy="50" r="50"></circle>
                <path d="M49,71.566c-11.355,0-20.566-9.213-20.566-20.566c0-11.355,9.211-20.566,20.566-20.566
c11.354,0,20.566,9.211,20.566,20.566C69.566,62.354,60.354,71.566,49,71.566z M49.481,47.947
c-9.052,2.704-17.728,2.49-18.022,2.49c-0.027,0.188-0.027,0.375-0.027,0.562c0,4.498,1.715,8.623,4.5,11.729
c4.793-8.543,14.273-11.596,14.273-11.596c0.24-0.08,0.481-0.133,0.695-0.214C50.473,49.928,49.99,48.938,49.481,47.947z
 M41.502,35.119c-4.901,2.303-8.543,6.829-9.695,12.266c0.456,0,7.793,0.08,16.229-2.143
C44.982,39.832,41.742,35.441,41.502,35.119z M52.105,53.838c-0.026,0-0.08,0.027-0.107,0.027c0,0-10.416,3.642-13.791,10.979
c-0.16-0.133-0.401-0.294-0.401-0.294c3.054,2.49,6.937,4.017,11.194,4.017c2.437,0,4.739-0.509,6.855-1.393
C55.588,65.621,54.57,60.266,52.105,53.838z M44.742,33.968c0,0,0.026-0.026,0.053-0.026
C44.769,33.941,44.769,33.941,44.742,33.968z M49,33.432c-1.42,0-2.812,0.188-4.151,0.51c0.269,0.348,3.589,4.713,6.588,10.229
c6.614-2.464,9.104-6.267,9.158-6.347C57.516,35.093,53.445,33.432,49,33.432z M62.576,39.832
c-0.053,0.055-2.865,4.125-9.801,6.963c0.402,0.83,0.803,1.688,1.178,2.545c0.135,0.294,0.242,0.615,0.375,0.91
c6.053-0.777,12.024,0.535,12.238,0.562C66.514,46.661,65.04,42.832,62.576,39.832z M55.4,53.008
c2.303,6.347,3.24,11.516,3.428,12.56c3.936-2.651,6.721-6.882,7.524-11.782C65.978,53.678,61.077,52.124,55.4,53.008z"/>
            </svg>
        </a>
        <?php } ?>
        <?php if(!empty($youtube_link)) { ?>
        <a class="link-youtube" href="<?php echo esc_url($youtube_link); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" xml:space="preserve" width="38" height="38">
                <circle cx="50" cy="50" r="50"></circle>
                <path d="M65.701,59.694c-0.422,1.969-1.989,3.416-3.878,3.637c-4.461,0.503-8.983,0.503-13.484,0.503s-9.023,0-13.484-0.503
    c-1.889-0.222-3.456-1.668-3.898-3.637c-0.623-2.793-0.623-5.848-0.623-8.722s0-5.928,0.644-8.722
    c0.441-1.969,1.989-3.416,3.878-3.637c4.461-0.502,8.983-0.502,13.484-0.502s9.023,0,13.484,0.502
    c1.889,0.221,3.456,1.668,3.898,3.637c0.623,2.793,0.623,5.848,0.623,8.722S66.345,56.9,65.701,59.694z M55.453,49.887
    l-10.289-6.431c-0.402-0.261-0.904-0.261-1.307-0.041c-0.401,0.221-0.663,0.663-0.663,1.125v12.861
    c0,0.462,0.262,0.904,0.663,1.125c0.201,0.101,0.402,0.161,0.623,0.161c0.241,0,0.482-0.06,0.684-0.201l10.289-6.431
    c0.382-0.221,0.603-0.643,0.603-1.085S55.835,50.108,55.453,49.887z"/>
            </svg>
        </a>
        <?php } ?>
        <?php if(!empty($pinterest_link)) { ?>
        <a class="link-pinterest" href="<?php echo esc_url($pinterest_link); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" xml:space="preserve" width="38" height="38">
                <circle cx="50" cy="50" r="50"></circle>
                <path d="M49,71.429c-2.035,0-3.963-0.294-5.838-0.856c0.776-1.232,1.66-2.812,2.089-4.393c0,0,0.241-0.91,1.446-5.65
    c0.696,1.366,2.785,2.571,5.008,2.571c6.614,0,11.114-6.025,11.114-14.113c0-6.079-5.169-11.783-13.042-11.783
    c-9.747,0-14.675,7.016-14.675,12.854c0,3.535,1.339,6.695,4.204,7.873c0.455,0.188,0.884,0,1.018-0.536
    c0.107-0.348,0.321-1.259,0.429-1.634c0.134-0.535,0.08-0.696-0.295-1.151c-0.83-0.991-1.365-2.25-1.365-4.043
    c0-5.195,3.883-9.855,10.122-9.855c5.517,0,8.569,3.375,8.569,7.9c0,5.918-2.624,10.926-6.534,10.926
    c-2.142,0-3.749-1.767-3.24-3.963c0.616-2.597,1.821-5.409,1.821-7.284c0-1.687-0.91-3.106-2.785-3.106
    c-2.195,0-3.963,2.276-3.963,5.329c0,0,0,1.955,0.669,3.267c-2.249,9.533-2.65,11.193-2.65,11.193
    c-0.375,1.554-0.402,3.294-0.349,4.74c-7.257-3.187-12.318-10.417-12.318-18.853c0-11.354,9.212-20.566,20.566-20.566
    s20.567,9.212,20.567,20.566S60.354,71.429,49,71.429z"/>
            </svg>
        </a>
        <?php } ?>
        <?php if(!empty($instagram_link)) { ?>
        <a class="link-instagram" href="<?php echo esc_url($instagram_link); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" xml:space="preserve" width="38" height="38">
                <circle cx="50" cy="50" r="50"></circle>
                <path d="M69.566,65.986c0,2.892-2.385,5.275-5.275,5.275H33.708c-2.892,0-5.275-2.384-5.275-5.275V35.404
    c0-2.892,2.384-5.275,5.275-5.275h30.583c2.891,0,5.275,2.383,5.275,5.275V65.986z M64.906,47.535h-3.615
    c0.348,1.098,0.535,2.303,0.535,3.508c0,6.855-5.73,12.398-12.8,12.398c-7.043,0-12.773-5.543-12.773-12.398
    c0-1.205,0.188-2.41,0.536-3.508h-3.776v17.353c0,0.911,0.724,1.634,1.634,1.634h28.627c0.91,0,1.633-0.723,1.633-1.634V47.535z
    M49.026,42.607c-4.552,0-8.248,3.588-8.248,8.007c0,4.419,3.696,8.007,8.248,8.007c4.58,0,8.275-3.588,8.275-8.007
    C57.301,46.196,53.606,42.607,49.026,42.607z M64.906,36.555c0-1.018-0.83-1.848-1.848-1.848h-4.66
    c-1.018,0-1.848,0.83-1.848,1.848v4.419c0,1.018,0.83,1.848,1.848,1.848h4.66c1.018,0,1.848-0.83,1.848-1.848V36.555z"/>
            </svg>
        </a>
        <?php } ?>
        <?php if(!empty($linkedin_link)) { ?>
        <a class="link-linkedin" href="<?php echo esc_url($linkedin_link); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" xml:space="preserve" width="38" height="38">
                <circle cx="50" cy="50" r="50"></circle>
                <path d="M39.1,69.1V43.3h-8.6v25.8H39.1z M34.8,39.8c3,0,4.9-2,4.9-4.5c-0.1-2.5-1.9-4.5-4.8-4.5 c-2.9,0-4.9,1.9-4.9,4.5C30,37.8,31.9,39.8,34.8,39.8L34.8,39.8L34.8,39.8z M43.8,69.1h8.6V54.7c0-0.8,0.1-1.5,0.3-2.1 c0.6-1.5,2-3.1,4.4-3.1c3.1,0,4.3,2.4,4.3,5.8v13.8H70V54.3c0-7.9-4.2-11.6-9.9-11.6c-4.6,0-6.7,2.6-7.8,4.3h0.1v-3.7h-8.6 C43.9,45.7,43.8,69.1,43.8,69.1L43.8,69.1z"></path>
            </svg>
        </a>
        <?php } ?>

    </div>

    <?php

    return ob_get_clean();

}
add_shortcode( 'autoroyal_social_shortcode', 'autoroyal_social_shortcode_func' );

vc_map( array(
  	'name' => esc_html__( 'Social', 'autoroyal' ),
	'base' => 'autoroyal_social_shortcode',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal social links', 'autoroyal' ),
	'params' => array(
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Facebook Link", "autoroyal"),
            "param_name" => "facebook_link",
            "admin_label" => false,
            "value" => "",
            "group" => "Social Links"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Twitter Link", "autoroyal"),
            "param_name" => "twitter_link",
            "admin_label" => false,
            "value" => "",
            "group" => "Social Links"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Dribbble Link", "autoroyal"),
            "param_name" => "dribbble_link",
            "admin_label" => false,
            "value" => "",
            "group" => "Social Links"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Youtube Link", "autoroyal"),
            "param_name" => "youtube_link",
            "admin_label" => false,
            "value" => "",
            "group" => "Social Links"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Pinterest Link", "autoroyal"),
            "param_name" => "pinterest_link",
            "admin_label" => false,
            "value" => "",
            "group" => "Social Links"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Instagram Link", "autoroyal"),
            "param_name" => "instagram_link",
            "admin_label" => false,
            "value" => "",
            "group" => "Social Links"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("LinkedIn Link", "autoroyal"),
            "param_name" => "linkedin_link",
            "admin_label" => false,
            "value" => "",
            "group" => "Social Links"
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Background Type", "autoroyal"),
            "param_name" => "bg_type",
            "admin_label" => false,
            "value" => array( esc_html__("Dark", "autoroyal") => "dark", esc_html__("Light", "autoroyal") => "light"),
            "group" => "Styling",
            "std" => "dark"
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Align", "autoroyal"),
            "param_name" => "align",
            "admin_label" => false,
            "value" => array( esc_html__("Left", "autoroyal") => "left", esc_html__("Right", "autoroyal") => "right", esc_html__("Center", "autoroyal") => "center"),
            "group" => "Styling",
            "std" => "left"
        ),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

?>