<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$cars_in_compare = array();
	if ( ! empty( $_COOKIE['autoroyal_compare_ids'] ) ) {
		$cars_in_compare = $_COOKIE['autoroyal_compare_ids'];
	}

	$car_already_added_to_compare = '';
	$car_compare_status           = esc_html__( 'Add to compare', 'autoroyal' );

	$show_filter = 1;

	if( !empty($cars_type) AND $cars_type == "featured") {
		$show_filter = 0;
	}

	if( !empty($cars_type) AND $cars_type == "recent") {
		$show_filter = 0;
	}

	if( !empty($cars_type) AND $cars_type == "popular") {
		$show_filter = 0;
	}

	$posts_per_page_set = get_option("autoroyal_posts_per_page");
	if( isset($posts_per_page_set) AND !empty($posts_per_page_set) AND $posts_per_page_set != 0 ) {
		
		$posts_per_page = $posts_per_page_set;

	} else {

		$posts_per_page = "9";

	}

	if( !empty($show) ) {
		$posts_per_page = $show;
	}

    $post_status = array( 'publish' );

    if ( is_home() || is_front_page() ) {
   		$paged = get_query_var( 'page' ) ? get_query_var( 'page' ) : 1;
   	} else {
   		$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
   	}
    
    $search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
        'post_type'           => 'vehicle',
        'post_status'         => 'publish',
        'offset'              => ( max( 1, $paged ) - 1 ) * $posts_per_page,
        'orderby'             => 'date', 
        'order'               => 'DESC',
        'ignore_sticky_posts' => 1,
        'meta_key'            => 'vehicle_for_rent',
        'meta_query' => array(
            'relation' => 'AND',
            array(
                'key'     => '_sold',
                'value'   => 0
            )
        )
    ));

	$search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
	$cars_query  = new WP_Query;
	$cars        = $cars_query->query( $search_args );
	$total       = $cars_query->found_posts;

	$max_num_pages = $cars_query->max_num_pages;

?>

<div id="autoroyal-inventory">

    <div class="row">

    	<?php 

    		if ( ! $cars ) : 

    	?>
    		<div class="col-md-12">
    			<h4><?php esc_html_e( 'No listings were found matching your search criteria.', 'autoroyal' ); ?></h4>
    		</div>
    	<?php else : ?>
    		<?php foreach ( $cars as $car ) : ?>

    			<?php 

    				$car_ID = $car->ID; 

    				$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
    				$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
    				$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
    				$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
    				$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
    				$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
    				$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

    				$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
    				if(!empty($vehicle_exterior_color)) {
    					$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
    					$color_id   = $vehicle_exterior_color[0]->term_id;
    					$color_name = $vehicle_exterior_color[0]->name;
    				} else {
    					$color_name = "";
    				}

    				$vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

    				$vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
    				$vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
    				$vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
    				$price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

    				$vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
    				$vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
    				$vehicle_image_url = "";

    				if(!empty($vehicle_image_gallery[0]['url'])) {

    					$vehicle_image_url = $vehicle_image_gallery[0]['url'];

    				} elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

    					$vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

    				}

    				$vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
    				if(!empty($vehicle_cover_image)) {
    					$vehicle_image_url = $vehicle_cover_image;
    				}

    				$vehicle_subtitle = "";
                    if(!empty($vehicle_engine_volume_l)) {
                        $vehicle_subtitle .= $vehicle_engine_volume_l . ", ";
                    }
                    if(!empty($vehicle_power_hp)) {
                        $vehicle_subtitle .= $vehicle_power_hp . ", ";
                    }
                    if(!empty($terms_vehicle_drive)) {
                        $vehicle_subtitle .= $terms_vehicle_drive;
                    }

    				$vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
    				$vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

    				$vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
    				$terms_vehicle_drive = $vehicle_drive[0]->name;

    				$vehicle_rent_price_min = get_post_meta($car_ID, 'vehicle_rent_price_min',true);

    				$minimum_age = get_post_meta($car_ID, 'minimum_age',true);

    			?>

    			<div class="col-lg-4 col-md-4 col-sm-6"> 

    				<div class="rent-blk-rows bg-white shadow">

                        <div class="blk-content favorite">

                            <div class="text-center carView">
                                <img src="<?php if(!empty($vehicle_image_url)) { echo esc_url($vehicle_image_url); } ?>" alt="<?php echo esc_attr($vehicle_name_final); ?>" class="img-responsive">
                                <h4><?php echo esc_attr($vehicle_name_final); ?> <span><?php echo esc_attr($vehicle_year); ?></span></h4>
                                <span class="rent-price"><?php esc_html_e('Starting at', 'autoroyal'); ?> <b><?php $currency = autoroyal_get_currency(); $currency_symbol = autoroyal_get_currency_symbol( $currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } ?><?php echo esc_attr($vehicle_rent_price_min); ?></b>/<?php esc_html_e('day', 'autoroyal'); ?></span>
                            </div>

                            <span class="text-center cd-car-spec">
                                <?php echo esc_attr($vehicle_subtitle); ?>
                            </span>

                            <div class="clearfix">
                                <?php if(!empty($minimum_age)) { ?>
                                <div class="request pull-left">
                                    <span><?php esc_html_e('Age', 'autoroyal'); ?>:</span>
                                    <p><?php echo esc_attr($minimum_age); ?>+ years</p>
                                </div>
                                <?php } ?>
                            </div>

                            <a href="#" class="btn btn-default" data-toggle="modal" data-target="#reservation-modal" data-car-id="<?php echo esc_attr($car_ID); ?>"><?php esc_html_e('Continue to car reservation', 'autoroyal'); ?> <i class="fa fa-angle-right"></i></a>
                            </div>

                            <div id="car-price-sets-<?php echo esc_attr($car_ID); ?>">

                                <?php

                                    $vehicle_rent_price_set = get_post_meta($car_ID, 'vehicle_rent_price_set',true);
                    
                                    $i = 0;

                                    if(!empty($vehicle_rent_price_set)) {

                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                            
                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                                $i++;

                                                ?>

                                                <input type="hidden" id="price-set-period-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>">
                                                <input type="hidden" id="price-set-price-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>">

                                                <?php

                                            }

                                        }

                                    }

                                ?>

                                <input type="hidden" class="total-sets" value="<?php echo esc_attr($i); ?>">

                            </div>

                            <ul id="rent-price-table-<?php echo esc_attr($car_ID); ?>" class="hidden">

                                <?php
                    
                                    $i = 0;

                                    if(!empty($vehicle_rent_price_set)) {

                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                            
                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                                $i++;

                                                ?>

                                                <li class="clearfix">
                                                    <span class="pull-left"><?php if($vehicle_rent_price_set_item['period'] == 1) { echo "24"; echo " "; echo esc_html_e('hours', 'autoroyal'); } else { echo esc_attr($vehicle_rent_price_set_item['period']); echo "+ "; echo esc_html_e('days', 'autoroyal'); } ?></span>
                                                    <span class="pull-right">
                                                        <b id="startR"><?php echo autoroyal_clean_price($vehicle_rent_price_set_item['price']); ?></b>
                                                    </span>
                                                </li>

                                                <?php

                                            }

                                        }

                                    }

                                ?>

                            </ul>

                    </div>

    			</div>

    		<?php endforeach; ?>
    	<?php endif; ?>

    	<div class="col-md-12"> 

    		<?php get_autoroyal_template( 'pagination.php', array( 'max_num_pages' => $max_num_pages ) ); ?>

    	</div>

    </div>

</div>
