<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$action_name = "";
	if ( isset( $_GET['action'] ) ) {
        $action_name = $_GET['action'];
    }

	$deal_ID = "";
	if ( isset( $_GET['deal_ID'] ) ) {
        $deal_ID = $_GET['deal_ID'];
    }

?>

<div id="autoroyal-inventory">

	<div class="table-toolbar">

		<div class="row">

			<div class="col-sm-12">
				
				<?php if ( autoroyal_get_permalink( 'submit_deal_form' ) ) { ?>
				
					<a id="autoroyal_add_vehicle" href="<?php echo esc_url(autoroyal_get_permalink( 'submit_deal_form' )); ?>" class="btn btn-default"><i class="material-icons">monetization_on</i> <?php esc_html_e( 'Add Deal', 'autoroyal' ) ?></a>

				<?php } ?>

			</div>

		</div>

		<div class="row autoroyal-inventory-stats">

			<div class="col-lg-3 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Total Deals', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_total_deals(); ?></span>

				</div>

			</div>

			<div class="col-lg-3 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Closed Deals', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_closed_deals(); ?></span>

				</div>

			</div>

			<div class="col-lg-3 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Total Profit', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_clean_price(autoroyal_get_deals_total_profit()); ?></span>

				</div>

			</div>

			<div class="col-lg-3 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Average Profit', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_clean_price(autoroyal_get_deals_avg_profit()); ?></span>

				</div>

			</div>

		</div>

	</div>

	<div class="table-toolbar">

		<?php 

			$deals_url = "#";

			if ( autoroyal_get_permalink( 'deals' ) ) { 

				$deals_url = autoroyal_get_permalink( 'deals' );

			} 

		?>

		<form class="autoroyal-deals-filter" action="<?php echo esc_url($deals_url); ?>" method="get">

			<div class="row">

				<?php

					$filter = "off";

					$keyword = "";
	        		if ( isset( $_GET['keyword'] ) AND !empty(isset( $_GET['keyword'] ) ) ) {
			            $keyword = $_GET['keyword'];
			        }

					$posts_per_page = "10";
	        		if ( isset( $_GET['posts_per_page'] ) AND !empty($_GET['posts_per_page']) ) {
			            $posts_per_page = $_GET['posts_per_page'];
			        } 

			        $start_date = "";
	        		if ( isset( $_GET['start_date'] ) AND !empty($_GET['start_date']) ) {
			            $start_date = $_GET['start_date'];
			        }

			        $end_date = "";
	        		if ( isset( $_GET['end_date'] ) AND !empty($_GET['end_date']) ) {
			            $end_date = $_GET['end_date'];
			        }

			        $orderby = "default";
	        		if ( isset( $_GET['orderby'] ) AND !empty($_GET['orderby']) ) {
			            $orderby = $_GET['orderby'];
			        }

			        //
			        if( !empty($posts_per_page) AND $posts_per_page != 10) {
			        	$filter = "on";
			        }

			        if( !empty($start_date) AND $start_date != "30daysago") {
			        	$filter = "on";
			        }

			        if( !empty($end_date) AND $end_date != "today") {
			        	$filter = "on";
			        }

			        if( !empty($orderby) AND $orderby != "default") {
			        	$filter = "on";
			        }

			        if( $start_date == "today" ) {
			        	$start_date_query = date('Y-m-d');
			        } elseif( $start_date == "yesterday" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-1 days'));
			        } elseif( $start_date == "7daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-7 days'));
			        } elseif( $start_date == "15daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-15 days'));
			        } elseif( $start_date == "30daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-30 days'));
			        } elseif( $start_date == "60daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-60 days'));
			        } elseif( $start_date == "90daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-90 days'));
			        } elseif( $start_date == "120daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-120 days'));
			        } elseif( $start_date == "1yearago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-1 year'));
			        }

			        if( $end_date == "today" ) {
			        	$end_date_query = date('Y-m-d');
			        } elseif( $end_date == "yesterday" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-1 days'));
			        } elseif( $end_date == "7daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-7 days'));
			        } elseif( $end_date == "15daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-15 days'));
			        } elseif( $end_date == "30daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-30 days'));
			        } elseif( $end_date == "60daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-60 days'));
			        } elseif( $end_date == "90daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-90 days'));
			        } elseif( $end_date == "120daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-120 days'));
			        } elseif( $end_date == "1yearago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-1 year'));
			        }

			        if( !empty($start_date_query) AND !empty($end_date_query) ) {

						$search_args = apply_filters( 'autoroyal_get_deals_args', array(
							'post_type'           => 'deal',
							'post_status'         => 'publish',
							'posts_per_page'      => $posts_per_page,
							'offset'              => ( max( 1, get_query_var('paged') ) - 1 ) * $posts_per_page,
							'orderby'             => 'date',
							'order'               => 'desc',
							'author'              => get_current_user_id(),
							'date_query' => array(
								array(
									'after'     => $start_date_query,
									'before'    => $end_date_query,
									'inclusive' => true,
								),
							),
						) );

					} else {

						$search_args = apply_filters( 'autoroyal_get_deals_args', array(
							'post_type'           => 'deal',
							'post_status'         => 'publish',
							'posts_per_page'      => $posts_per_page,
							'offset'              => ( max( 1, get_query_var('paged') ) - 1 ) * $posts_per_page,
							'orderby'             => 'date',
							'order'               => 'desc',
							'author'              => get_current_user_id(),
						) );

					}

					$search_args = apply_filters( 'autoroyal_deals_search_parameters', $search_args );
					$deals_query = new WP_Query;
					$deals = $deals_query->query( $search_args );

					$max_num_pages = $deals_query->max_num_pages;

				?>

				<div class="col-sm-3">

					<div class="dataTables_length" id="posts_per_page">

						<?php

							$paged    = max( 1, get_query_var('paged') );
							$per_page = $posts_per_page;
							$total    = $deals_query->found_posts;
							$first    = ( $per_page * $paged ) - $per_page + 1;
							$last     = min( $total, $posts_per_page * $paged );

							if ( $total <= $per_page || -1 == $per_page ) {
								/* translators: %d: total results */
								printf( _n( 'Showing the single deal', 'Showing all %d deals', $total, 'autoroyal' ), $total );
							} else {
								/* translators: 1: first result 2: last result 3: total results */
								printf( _nx( 'Showing the single deal', 'Showing %1$d to %2$d of %3$d', $total, 'with first and last deal', 'autoroyal' ), $first, $last, $total );
							}

						?>

					</div>

				</div>

				<div class="col-sm-9">

					<div id="sample_1_filter" class="dataTables_filter">

						<input type="hidden" id="orderby" name="orderby" value="<?php echo esc_attr($orderby); ?>" />

						<?php if( !empty($start_date_query) AND !empty($end_date_query) ) { ?>

						<label><?php esc_html_e('Start', 'autoroyal' ); ?> 

							<select name="start_date" aria-controls="sample_2" class="input-sm input-xsmall input-inline autoroyal-deals-select-start-date">
								<option value="today" <?php if( $start_date == 'today' ) { echo "selected"; } ?>><?php esc_html_e('Today', 'autoroyal' ); ?></option>
								<option value="yesterday" <?php if( $start_date == 'yesterday' ) { echo "selected"; } ?>><?php esc_html_e('Yesterday', 'autoroyal' ); ?></option>
								<option value="7daysago" <?php if( $start_date == '7daysago' ) { echo "selected"; } ?>><?php esc_html_e('7 Days Ago', 'autoroyal' ); ?></option>
								<option value="15daysago" <?php if( $start_date == '15daysago' ) { echo "selected"; } ?>><?php esc_html_e('15 Days Ago', 'autoroyal' ); ?></option>
								<option value="30daysago" <?php if( $start_date == '30daysago' ) { echo "selected"; } ?>><?php esc_html_e('30 Days Ago', 'autoroyal' ); ?></option>
								<option value="60daysago" <?php if( $start_date == '60daysago' ) { echo "selected"; } ?>><?php esc_html_e('60 Days Ago', 'autoroyal' ); ?></option>
								<option value="90daysago" <?php if( $start_date == '90daysago' ) { echo "selected"; } ?>><?php esc_html_e('90 Days Ago', 'autoroyal' ); ?></option>
								<option value="120daysago" <?php if( $start_date == '120daysago' ) { echo "selected"; } ?>><?php esc_html_e('120 Days Ago', 'autoroyal' ); ?></option>
								<option value="1yearago" <?php if( $start_date == '1yearago' ) { echo "selected"; } ?>><?php esc_html_e('1 Year Ago', 'autoroyal' ); ?></option>
							</select>

						</label>

						<label><?php esc_html_e('End', 'autoroyal' ); ?> 

							<select name="end_date" aria-controls="sample_2" class="input-sm input-xsmall input-inline autoroyal-deals-select-end-date">
								<option value="today" <?php if( $end_date == 'today' ) { echo "selected"; } ?>><?php esc_html_e('Today', 'autoroyal' ); ?></option>
								<option value="yesterday" <?php if( $end_date == 'yesterday' ) { echo "selected"; } ?>><?php esc_html_e('Yesterday', 'autoroyal' ); ?></option>
								<option value="7daysago" <?php if( $end_date == '7daysago' ) { echo "selected"; } ?>><?php esc_html_e('7 Days Ago', 'autoroyal' ); ?></option>
								<option value="15daysago" <?php if( $end_date == '15daysago' ) { echo "selected"; } ?>><?php esc_html_e('15 Days Ago', 'autoroyal' ); ?></option>
								<option value="30daysago" <?php if( $end_date == '30daysago' ) { echo "selected"; } ?>><?php esc_html_e('30 Days Ago', 'autoroyal' ); ?></option>
								<option value="60daysago" <?php if( $end_date == '60daysago' ) { echo "selected"; } ?>><?php esc_html_e('60 Days Ago', 'autoroyal' ); ?></option>
								<option value="90daysago" <?php if( $end_date == '90daysago' ) { echo "selected"; } ?>><?php esc_html_e('90 Days Ago', 'autoroyal' ); ?></option>
								<option value="120daysago" <?php if( $end_date == '120daysago' ) { echo "selected"; } ?>><?php esc_html_e('120 Days Ago', 'autoroyal' ); ?></option>
								<option value="1yearago" <?php if( $end_date == '1yearago' ) { echo "selected"; } ?>><?php esc_html_e('1 Year Ago', 'autoroyal' ); ?></option>
							</select>

						</label>

						<?php } ?>

						<label><?php esc_html_e('Show', 'autoroyal' ); ?> 

							<select name="posts_per_page" aria-controls="sample_1" class="input-sm input-xsmall input-inline autoroyal-deals-select-ppp">
								<option value="10" <?php if( $posts_per_page == '10' ) { echo "selected"; } ?>>10</option>
								<option value="25" <?php if( $posts_per_page == '25' ) { echo "selected"; } ?>>25</option>
								<option value="50" <?php if( $posts_per_page == '50' ) { echo "selected"; } ?>>50</option>
								<option value="-1" <?php if( $posts_per_page == '-1' ) { echo "selected"; } ?>>All</option>
							</select>

						</label>
						
						<?php if($filter == "on") { ?>
							<?php if ( autoroyal_get_permalink( 'deals' ) ) { ?>
							<a href="<?php echo esc_url(autoroyal_get_permalink( 'deals' )); ?>" id="clear-deals-filter"><i class="fa fa-times" aria-hidden="true"></i></a>
							<?php } ?>
						<?php } ?>

						<div id="refresh-deals-filter">
							<i class="fa fa-refresh" aria-hidden="true"></i> <?php esc_html_e('Refresh', 'autoroyal' ); ?>
						</div>

					</div>

				</div>

			</div>

		</form>

	</div>

	<table id="autoroyal_deals_table" class="car-manager-cars table-hover" data-edit-url="<?php if ( ! autoroyal_get_permalink( 'submit_deal_form' ) ) { echo "no-page"; } else { echo esc_url(autoroyal_get_permalink( 'submit_deal_form' )); } ?>">
		<thead>
			<tr>
				<th class="d-none d-lg-table-cell deal-sorting-date <?php if($orderby == "date_asc"){ echo "sorting_asc"; } elseif($orderby == "date_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Date', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell deal-sorting-name <?php if($orderby == "name_asc"){ echo "sorting_asc"; } elseif($orderby == "name_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Name', 'autoroyal' ); ?></th>
				<th class="d-md-table-cell d-lg-none deal-sorting-name <?php if($orderby == "name_asc"){ echo "sorting_asc"; } elseif($orderby == "name_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Deal', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell text-center deal-sorting-sku <?php if($orderby == "sku_asc"){ echo "sorting_asc"; } elseif($orderby == "sku_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Sku', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell deal-sorting-vehicle-name <?php if($orderby == "vehicle_name_asc"){ echo "sorting_asc"; } elseif($orderby == "vehicle_name_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Vehicle', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell text-center deal-sorting-price <?php if($orderby == "price_asc"){ echo "sorting_asc"; } elseif($orderby == "price_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Price', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell text-center deal-sorting-profit <?php if($orderby == "profit_asc"){ echo "sorting_asc"; } elseif($orderby == "profit_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Profit', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell text-center deal-sorting-age <?php if($orderby == "age_asc"){ echo "sorting_asc"; } elseif($orderby == "age_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Days to Sell', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell text-center deal-sorting-next-payment <?php if($orderby == "next_payment_asc"){ echo "sorting_asc"; } elseif($orderby == "next_payment_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Next Payment', 'autoroyal' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php 

				if ( ! $deals ) : 

			?>
				<tr>
					<td colspan="8"><?php esc_html_e( 'You do not have any deals.', 'autoroyal' ); ?></td>
				</tr>
			<?php else : ?>
				<?php foreach ( $deals as $deal ) : ?>

					<?php 

						$deal_ID = $deal->ID; 

						$deal_sold_date = esc_attr(get_post_meta($deal_ID, 'deal_sold_date',true));
						$deal_loan_next_payments_date = esc_attr(get_post_meta($deal_ID, 'deal_loan_next_payments_date',true));
						$deal_first_name = esc_attr(get_post_meta($deal_ID, 'deal_first_name',true));
						$deal_last_name = esc_attr(get_post_meta($deal_ID, 'deal_last_name',true));

						$deal_vehicle_id = esc_attr(get_post_meta($deal_ID, 'deal_vehicle_id',true));
						$deal_vehicle_sku = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_stock',true));
						$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
						$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
						$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
						$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));
						$vehicle_exterior_color = get_the_terms($deal_vehicle_id, 'vehicle_exterior_color' );
						if(!empty($vehicle_exterior_color)) {
							$color              = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
							$color_id           = $vehicle_exterior_color[0]->term_id;
							$deal_vehicle_color = $vehicle_exterior_color[0]->name;
						}

						$price = esc_attr(get_post_meta($deal_ID, 'deal_vehicle_price',true));
						$cost = esc_attr(get_post_meta($deal_ID, 'deal_vehicle_cost',true));
						$profit = esc_attr(get_post_meta($deal_ID, 'deal_vehicle_profit',true));

						$age = esc_attr(get_post_meta($deal_ID, 'deal_vehicle_age',true));

						$today = strtotime("now");
						$payment_date_raw = strtotime($deal_loan_next_payments_date);

						if( !empty($payment_date_raw) && $payment_date_raw <= $today ) {
							$class = "autoroyal_loan_payment_paid_faild";
						} else {
							$class = "";
						}

						if( $deal_loan_next_payments_date == "done" ) {
							$class = "autoroyal_loan_payment_paid_done";
						}

						$deal_loan_payments_num = get_post_meta($deal_ID, 'deal_loan_payments_num',true);

					?>

					<tr class="listing-item" data-id="<?php echo esc_attr($deal_ID); ?>">

						<td class="d-none d-lg-table-cell">
							<?php echo date( get_option('date_format'), strtotime($deal_sold_date) ); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($deal_first_name); ?> <?php echo esc_attr($deal_last_name); ?>
						</td>

						<td class="d-md-table-cell d-lg-none">
							<strong><?php echo esc_attr($deal_first_name); ?> <?php echo esc_attr($deal_last_name); ?></strong>
							<br><?php esc_html_e( 'Stock #', 'autoroyal' ); ?>: <?php echo esc_attr($deal_vehicle_sku); ?>

							<br><?php esc_html_e( 'Vehicle', 'autoroyal' ); ?>: <?php echo esc_attr($deal_vehicle_year); echo " "; echo esc_attr($deal_vehicle_make); echo " "; echo esc_attr($deal_vehicle_model); echo " "; echo esc_attr($deal_vehicle_trim);  echo " "; echo esc_attr($deal_vehicle_color);?>
							<br><?php esc_html_e( 'Sales Amount', 'autoroyal' ); ?>: 
							<br><?php esc_html_e( 'Profit', 'autoroyal' ); ?>: 
							<br><?php esc_html_e( 'Days to Sell', 'autoroyal' ); ?>: 
							<br><?php esc_html_e( 'Next Payment', 'autoroyal' ); ?>: <?php echo esc_attr($deal_loan_next_payments_date); ?>
						</td>

						<td class="d-none d-lg-table-cell text-center">
							<?php echo esc_attr($deal_vehicle_sku); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($deal_vehicle_year); echo " "; echo esc_attr($deal_vehicle_make); echo " <br>"; echo esc_attr($deal_vehicle_model); echo " "; echo esc_attr($deal_vehicle_trim); echo " "; echo esc_attr($deal_vehicle_color); ?>
						</td>

						<td class="d-none d-lg-table-cell text-center">
							<?php echo autoroyal_clean_price($price); ?>
						</td>

						<td class="d-none d-lg-table-cell text-center">
							<?php echo autoroyal_clean_price($profit); ?>
						</td>

						<td class="d-none d-lg-table-cell text-center">
							<?php echo round($age); ?>
						</td>

						<td class="d-none d-lg-table-cell text-center <?php echo esc_attr($class); ?>">
							<?php if( $deal_loan_next_payments_date == "done" ) { echo esc_html_e( 'Closed', 'autoroyal' ); } else { echo esc_attr($deal_loan_next_payments_date); } ?>
						</td>

					</tr>

				<?php endforeach; ?>
			<?php endif; ?>
		</tbody>
	</table>
	<?php get_autoroyal_template( 'pagination.php', array( 'max_num_pages' => $max_num_pages ) ); ?>
</div>
