<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	$search_args = apply_filters( 'autoroyal_get_deals_args', array(
		'post_type'           => 'deal',
		'post_status'         => 'publish',
		'posts_per_page'      => -1,
		'orderby'             => 'date',
		'order'               => 'desc',
		'author'              => get_current_user_id()
	) );

	$deals_query = new WP_Query;
	$deals = $deals_query->query( $search_args );

?>

<div id="autoroyal-inventory">

	<div class="row">

		<div class="col-md-12">

			<table id="autoroyal_deals_table" class="car-manager-cars table-hover" data-edit-url="<?php if ( ! autoroyal_get_permalink( 'submit_deal_form' ) ) { echo "no-page"; } else { echo esc_url(autoroyal_get_permalink( 'submit_deal_form' )); } ?>">
				<thead>
					<tr>
						<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Payment Date', 'autoroyal' ); ?></th>
						<th class="d-none d-lg-table-cell text-center"><?php esc_html_e( 'Amount', 'autoroyal' ); ?></th>
						<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Name', 'autoroyal' ); ?></th>
						<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Phone', 'autoroyal' ); ?></th>
						<th class="d-none d-lg-table-cell text-center"><?php esc_html_e( 'Sku', 'autoroyal' ); ?></th>
						<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Vehicle', 'autoroyal' ); ?></th>
						<th class="d-md-table-cell d-lg-none"><?php esc_html_e( 'Deal', 'autoroyal' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php 

						if ( ! $deals ) : 

					?>
						<tr>
							<td colspan="8"><?php esc_html_e( 'You do not have any upcoming payments.', 'autoroyal' ); ?></td>
						</tr>
					<?php else : ?>
						<?php foreach ( $deals as $deal ) : ?>

							<?php 

								$deal_ID = $deal->ID; 

								$deal_loan_next_payments_date = esc_attr(get_post_meta($deal_ID, 'deal_loan_next_payments_date',true));

								if( $deal_loan_next_payments_date != "done" ) {

									$deal_sold_date = esc_attr(get_post_meta($deal_ID, 'deal_sold_date',true));
									$deal_first_name = esc_attr(get_post_meta($deal_ID, 'deal_first_name',true));
									$deal_last_name = esc_attr(get_post_meta($deal_ID, 'deal_last_name',true));

									$deal_mobile_phone = esc_attr(get_post_meta($deal_ID, 'deal_mobile_phone',true));

									$deal_loan_payments_num = 0;
									$deal_loan_payments_num = get_post_meta($deal_ID, 'deal_loan_payments_num',true);

									$deal_loan_payments_amount = 0;

									$deal_loan_payments = get_post_meta($deal_ID, 'deal_loan_payments',true);
									$deal_loan_payment_amount_x = get_post_meta($deal_ID, 'deal_loan_payment_amount_x',true);
									for( $i = 0; $i < $deal_loan_payments_num; ++$i ){ 

										if( !empty($deal_loan_payments[$i - 1]['paid']) AND $deal_loan_payments[$i - 1]['paid'] == "on") { 

											$deal_loan_payments_amount = $deal_loan_payments[$i]['rate_value'];

										}

										if( empty($deal_loan_payments_amount) ) {

											$deal_loan_payments_amount = $deal_loan_payment_amount_x;

										}

									}

									$deal_vehicle_id = esc_attr(get_post_meta($deal_ID, 'deal_vehicle_id',true));
									$deal_vehicle_sku = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_stock',true));
									$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
									$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
									$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
									$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));
									$vehicle_exterior_color = get_the_terms($deal_vehicle_id, 'vehicle_exterior_color' );
									if(!empty($vehicle_exterior_color)) {
										$color              = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
										$color_id           = $vehicle_exterior_color[0]->term_id;
										$deal_vehicle_color = $vehicle_exterior_color[0]->name;
									}

									$today = strtotime("now");
									$payment_date_raw = strtotime($deal_loan_next_payments_date);

									if( !empty($payment_date_raw) && $payment_date_raw <= $today ) {
										$class = "autoroyal_loan_payment_paid_faild";
									} else {
										$class = "";
									}

									if( $deal_loan_next_payments_date == "done" ) {
										$class = "autoroyal_loan_payment_paid_done";
									}

							?>

							<tr class="listing-item <?php echo esc_attr($class); ?>" data-id="<?php echo esc_attr($deal_ID); ?>">

								<td class="d-none d-lg-table-cell">
									<?php if( $deal_loan_next_payments_date == "done" ) { echo esc_html_e( 'Closed', 'autoroyal' ); } else { echo esc_attr($deal_loan_next_payments_date); } ?>
								</td>

								<td class="d-none d-lg-table-cell text-center">
									<?php 

										$price_args = array(
											'ex_tax_label'       => false,
											'currency'           => '',
											'decimal_separator'  => autoroyal_get_price_decimal_separator(),
											'thousand_separator' => autoroyal_get_price_thousand_separator(),
											'decimals'           => '2',
											'price_format'       => get_autoroyal_price_format(),
										);

										echo autoroyal_clean_price( $deal_loan_payments_amount, $price_args ); 

									?>
								</td>

								<td class="d-none d-lg-table-cell">
									<?php echo esc_attr($deal_first_name); ?> <?php echo esc_attr($deal_last_name); ?>
								</td>

								<td class="d-none d-lg-table-cell">
									<?php echo esc_attr($deal_mobile_phone); ?>
								</td>

								<td class="d-none d-sm-table-cell text-center">
									<?php echo esc_attr($deal_vehicle_sku); ?>
								</td>

								<td class="d-none d-lg-table-cell">
									<?php echo esc_attr($deal_vehicle_year); echo " "; echo esc_attr($deal_vehicle_make); echo " <br>"; echo esc_attr($deal_vehicle_model); echo " "; echo esc_attr($deal_vehicle_trim); echo " "; echo esc_attr($deal_vehicle_color); ?>
								</td>

								<td class="d-md-table-cell d-lg-none">
									<strong><?php esc_html_e( 'Payment Date', 'autoroyal' ); ?>: <?php if( $deal_loan_next_payments_date == "done" ) { echo esc_html_e( 'Closed', 'autoroyal' ); } else { echo esc_attr($deal_loan_next_payments_date); } ?></strong>
									<br><?php esc_html_e( 'Amount', 'autoroyal' ); ?>: <?php echo esc_attr($deal_loan_payments_amount); ?>
									<br><?php esc_html_e( 'Name', 'autoroyal' ); ?>: <?php echo esc_attr($deal_first_name); ?> <?php echo esc_attr($deal_last_name); ?>
									<br><?php esc_html_e( 'Phone', 'autoroyal' ); ?>: <?php echo esc_attr($deal_mobile_phone); ?>
									<br><?php esc_html_e( 'Vehicle', 'autoroyal' ); ?>: <?php echo esc_attr($deal_vehicle_sku); echo " "; echo esc_attr($deal_vehicle_year); echo " "; echo esc_attr($deal_vehicle_make); echo " <br>"; echo esc_attr($deal_vehicle_model); echo " "; echo esc_attr($deal_vehicle_trim); echo " "; echo esc_attr($deal_vehicle_color); ?>
								</td>

							</tr>

							<?php } ?>

						<?php endforeach; ?>
					<?php endif; ?>
				</tbody>
			</table>

		</div>

	</div>

</div>
