<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package fantasy_themes
 */

$MODS = get_theme_mods();
foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

$logo_white = "";
if(strlen($MODS['logo_white'])>0) {
    $logo_white = "<img src='".esc_url($MODS['logo_white'])."' alt='".esc_html__( 'Logo', 'autoroyal' )."'>";
}

// Stats #1
$footer_stats_1_value = "";
if(strlen($MODS['footer_stats_1_value'])>0) {
    $footer_stats_1_value = $MODS['footer_stats_1_value'];
}
$footer_stats_1_label = "";
if(strlen($MODS['footer_stats_1_label'])>0) {
    $footer_stats_1_label = $MODS['footer_stats_1_label'];
}
$footer_stats_1_icon = "";
if(strlen($MODS['footer_stats_1_icon'])>0) {
    $footer_stats_1_icon = $MODS['footer_stats_1_icon'];
}

// Stats #2
$footer_stats_2_value = "";
if(strlen($MODS['footer_stats_2_value'])>0) {
    $footer_stats_2_value = $MODS['footer_stats_2_value'];
}
$footer_stats_2_label = "";
if(strlen($MODS['footer_stats_2_label'])>0) {
    $footer_stats_2_label = $MODS['footer_stats_2_label'];
}
$footer_stats_2_icon = "";
if(strlen($MODS['footer_stats_2_icon'])>0) {
    $footer_stats_2_icon = $MODS['footer_stats_2_icon'];
}

// Stats #3
$footer_stats_3_value = "";
if(strlen($MODS['footer_stats_3_value'])>0) {
    $footer_stats_3_value = $MODS['footer_stats_3_value'];
}
$footer_stats_3_label = "";
if(strlen($MODS['footer_stats_3_label'])>0) {
    $footer_stats_3_label = $MODS['footer_stats_3_label'];
}
$footer_stats_3_icon = "";
if(strlen($MODS['footer_stats_3_icon'])>0) {
    $footer_stats_3_icon = $MODS['footer_stats_3_icon'];
}

?>

			</div><!-- #content -->

			<footer id="colophon" class="site-footer">

				<?php if(!empty($logo_white) 
					OR !empty($footer_stats_1_icon) 
					OR !empty($footer_stats_1_value)
					OR !empty($footer_stats_1_label)
					OR !empty($footer_stats_2_icon) 
					OR !empty($footer_stats_2_value)
					OR !empty($footer_stats_2_label)
					OR !empty($footer_stats_3_icon) 
					OR !empty($footer_stats_3_value)
					OR !empty($footer_stats_3_label)
				) { ?>

				<div class="autoroyal-footer-header">

					<div class="container">

						<div class="row justify-content-between">

							<div class="col-md-6 col-12">

								<a class="logo-wrapper" href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<?php echo wp_kses(($logo_white), true); ?>
								</a>

							</div>

							<div class="col-md-6 col-12 text-right">

								<div class="autoroyal-footer-stats align-self-center">
									<div class="stat-wrapper ml-5 md-ml-0 md-mb-30 text-left">
										<?php if(!empty($footer_stats_1_icon)) { ?>
										<div class="icon">
											<?php echo wp_kses($footer_stats_1_icon, true); ?>
										</div>
										<?php } ?>
										<?php if(!empty($footer_stats_1_value)) { ?>
										<div class="number"><?php echo esc_attr($footer_stats_1_value); ?></div>
										<?php } ?>
										<?php if(!empty($footer_stats_1_label)) { ?>
										<div class="caption"><?php echo esc_attr($footer_stats_1_label); ?></div>
										<?php } ?>
									</div>
									<div class="stat-wrapper ml-5 md-ml-0 md-mb-30 text-left">
										<?php if(!empty($footer_stats_2_icon)) { ?>
										<div class="icon">
											<?php echo wp_kses($footer_stats_2_icon, true); ?>
										</div>
										<?php } ?>
										<?php if(!empty($footer_stats_2_value)) { ?>
										<div class="number"><?php echo esc_attr($footer_stats_2_value); ?></div>
										<?php } ?>
										<?php if(!empty($footer_stats_2_label)) { ?>
										<div class="caption"><?php echo esc_attr($footer_stats_2_label); ?></div>
										<?php } ?>
									</div>
									<div class="stat-wrapper ml-5 md-ml-0 md-mb-30 text-left">
										<?php if(!empty($footer_stats_3_icon)) { ?>
										<div class="icon">
											<?php echo wp_kses($footer_stats_3_icon, true); ?>
										</div>
										<?php } ?>
										<?php if(!empty($footer_stats_3_value)) { ?>
										<div class="number"><?php echo esc_attr($footer_stats_3_value); ?></div>
										<?php } ?>
										<?php if(!empty($footer_stats_3_label)) { ?>
										<div class="caption"><?php echo esc_attr($footer_stats_3_label); ?></div>
										<?php } ?>
									</div>
								</div>

							</div>

						</div>
						
					</div>

				</div>
				<?php } ?>
				
				<?php if ( is_active_sidebar( 'footer-1' ) 
					OR is_active_sidebar( 'footer-2' )
					OR is_active_sidebar( 'footer-3' )
					OR is_active_sidebar( 'footer-4' )
				) { ?>
				<section class="footer-widgets text-left">
					<div class="container">
						<div class="row justify-content-md-between">
							<?php if ( is_active_sidebar( 'footer-1' ) ) : ?>
								<div class="col-lg-2 col-md-6">
									<aside class="widget-area footer-1-area mb-2">
										<?php dynamic_sidebar( 'footer-1' ); ?>
									</aside>
								</div>
							<?php endif; ?>

							<?php if ( is_active_sidebar( 'footer-2' ) ) : ?>
								<div class="col-lg-2 col-md-6">
									<aside class="widget-area footer-2-area mb-2">
										<?php dynamic_sidebar( 'footer-2' ); ?>
									</aside>
								</div>
							<?php endif; ?>

							<?php if ( is_active_sidebar( 'footer-3' ) ) : ?>
								<div class="col-lg-2 col-md-6">
									<aside class="widget-area footer-3-area mb-2">
										<?php dynamic_sidebar( 'footer-3' ); ?>
									</aside>
								</div>
							<?php endif; ?>

							<?php if ( is_active_sidebar( 'footer-4' ) ) : ?>
								<div class="col-lg-5 col-md-6">
									<aside class="widget-area footer-4-area mb-2">
										<?php dynamic_sidebar( 'footer-4' ); ?>
									</aside>
								</div>
							<?php endif; ?>
						</div>
						<!-- /.row -->
					</div>
				</section>
				<?php } ?>
				
				<div class="site-info">
					<div class="container">
						<?php 

							// Get all the Customized Theme Mods
						    $MODS = get_theme_mods();
						    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

							$footer_copyright = "";
							if(strlen($MODS['footer_copyright_text']) > 0) {

								$footer_copyright = $MODS['footer_copyright_text'];

							}

							echo wp_kses(($footer_copyright), true);

						?>
						<ul class="autoroyal-footer-menu">

							<?php 

								if ( has_nav_menu( 'menu-2' ) ) {
																	
									wp_nav_menu( array( 
									
										'container' => '', 
										'items_wrap' => '%3$s',
										'theme_location' => 'menu-2'
																	
									) ); 

								}
								
							?>

						</ul>
					</div><!-- .site-info -->
				</div>
				<!-- /.container -->

			</footer><!-- #colophon -->

			<div id="autoroyal-side-menu" class="autoroyal-side-menu">

				<div class="autoroyal-side-top">

					<div class="close-side-menu-icon"></div>

				</div>

				<div class="autoroyal-side-inner">

					<ul class="autoroyal-side-inner-menu">
								
						
						
					</ul>

				</div>

				<form class="search-form" method="get" id="searchform-sidebar" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<div class="input-with-icon">
						<i class="fa fa-search" aria-hidden="true"></i>
						<input type="text" id="small-search-box" name="s" placeholder="<?php esc_attr_e( 'Type here', 'autoroyal' ) ?>">
					</div>
				</form>

			</div>

			<a href="#autoroyal-side-close" class="autoroyal-trigger autoroyal-side-close"></a>

		</div>

		<?php wp_footer(); ?>
	
	</body>
</html>
