<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package fantasy_themes
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'card mt-3r' ); ?>>

	<div class="card-body">

		<?php if ( is_sticky() ) : ?>
			<span class="fa fa-bookmark fantasy-themes-sticky" title="<?php echo esc_attr__( 'Sticky Post', 'autoroyal' ); ?>"></span>
		<?php endif; ?>
		<header class="entry-header">
			<span class="cat-links">
				<span class="ar-badge"><?php the_category( '</span> <span class="ar-badge">' ); ?></span>
			</span>
			<?php
			if ( is_singular() ) :
				the_title( '<h1 class="entry-title card-title h2">', '</h1>' );
			else :
				the_title( '<h2 class="entry-title card-title h3"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			endif;

			if ( 'post' === get_post_type() ) : ?>
			<div class="entry-meta text-muted">
				<?php autoroyal_posted_on(); ?>
			</div><!-- .entry-meta -->
			<?php
			endif; ?>
		</header><!-- .entry-header -->

		<?php autoroyal_post_thumbnail(); ?>

		<?php if( is_singular() || get_theme_mod( 'default_blog_display', 'excerpt' ) === 'full' ) : ?>
			<div class="entry-content">
				<?php
					the_content( sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'autoroyal' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						get_the_title()
					) );

					wp_link_pages( array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'autoroyal' ),
						'after'  => '</div>',
					) );
				?>
			</div><!-- .entry-content -->
		<?php else : ?>
			<div class="entry-summary">
				<?php the_excerpt(); ?>
				<div class="autoroyal-read-more">
					<a class="btn btn-icon-right" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Continue Reading', 'autoroyal' ); ?> <i class="material-icons">trending_flat</i></a>
				</div>
			</div><!-- .entry-summary -->
		<?php endif; ?>

	</div>

</article><!-- #post-<?php the_ID(); ?> -->
