(function($) {

    jQuery("document").ready(function(){
    	// loading default values of calculator
    	if ( jQuery("#paymentCalc").width() > 0)
    		cd_loanCalculator();
    });

    if ( jQuery("#vehiclePrice").width() > 0){
        document.getElementById("vehiclePrice").addEventListener("keyup", cd_loanCalculator);
    }
    if ( jQuery("#firstPayment").width() > 0){
        document.getElementById("firstPayment").addEventListener("keyup", cd_loanCalculator);
    }
    if ( jQuery("#firstPayment").width() > 0){
        document.getElementById("firstPayment").addEventListener("keyup", cd_loanCalculator);
    }
    if ( jQuery("#paymentPeriod").width() > 0){
        document.getElementById("paymentPeriod").addEventListener("keyup", cd_loanCalculator);
    }

    function cd_loanCalculator(){

    	var purchaseAmt = "";
        var purchaseAmtText = document.getElementById('vehiclePrice').value;
        if (purchaseAmtText.length > 0) {
            purchaseAmt = Number(purchaseAmtText);
        }
        else {
            document.getElementById('vehiclePrice').value = "";
        }

        var downPayment = "";
        var downPaymentText = document.getElementById('firstPayment').value;
        if (downPaymentText.length > 0) {
            downPayment = Number(downPaymentText);
        }
        else {
            document.getElementById('firstPayment').value = "";
        }

        var subTotal = purchaseAmt;
        var totalDue = subTotal - downPayment;

        var loanAmt = 0.00;
        var loanAmtText = document.getElementById('deal_loan_amount');

        loanAmt = totalDue;

        var annualInterestRate = "";
        var interestRateText = document.getElementById('intRate');
        if (interestRateText.value.length > 0) {
            annualInterestRate = Number(interestRateText.value) / 100;
        }
        else {
            interestRateText.value = "";
        }

        var monthRate = annualInterestRate / 12;
        var semiMonthlyRate = annualInterestRate / 24;
        var weeklyRate = annualInterestRate / 52;
        var biweeklyRate = annualInterestRate / 26;

        var numPayments = 0;
        var rate = 0;

        var termLengthText = document.getElementById('paymentPeriod');
        if (termLengthText.value.length == 0) {
            termLengthText.value = "";
        }

        var months = Number(termLengthText.value);
        var finalDatePeriod = "+" + months + " month";
        rate = monthRate;
        numPayments = months;

        var payment = 0;
        if (rate != 0) {
            payment = Math.floor( (loanAmt * rate) / (1 - Math.pow((1 + rate), (-1 * numPayments)) ) * 1000) / 1000;
        }
        else {
            payment = loanAmt / numPayments;
        }

        var totalAmount = payment * numPayments;
        var totalInteres = totalAmount - loanAmt;
        var currency_symbol = jQuery("#autoroyal-currency").val();

        if( isNaN( totalAmount ) ) {
        	document.getElementById("totalResult").innerHTML = currency_symbol + "***";
        } else {
        	document.getElementById("totalResult").innerHTML = currency_symbol + addCommas( totalAmount.toFixed(2) );
        }

        if( isNaN( payment ) || !isFinite( payment ) ) {
        	document.getElementById("monthPay").innerHTML = currency_symbol + "***";
        } else {
        	document.getElementById("monthPay").innerHTML = currency_symbol + addCommas( payment.toFixed(2) );
        }

        if( isNaN( totalInteres ) ) {
        	document.getElementById("interesPayment").innerHTML = currency_symbol + "***";
        } else {
        	document.getElementById("interesPayment").innerHTML = currency_symbol + addCommas( totalInteres.toFixed(2) );
        }
        
        jQuery("#periodPay span").text(numPayments);
    }

    function addCommas(nStr) {
        nStr += '';
        var x = nStr.split('.');
        var x1 = x[0];
        var x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ' ' + '$2');
        }
        return x1 + x2;
    }

    // car dimensions in item-submit.html
    function changeCarDimensions(){

    	var vehicleWidthTop = document.getElementById("carWidthTopInput").value;
    	var vehicleLenght   = document.getElementById("carLenghtInput").value;
    	var vehicleHeight   = document.getElementById("carHeightInput").value;
    	var vehicleWeelBase = document.getElementById("carWheelInput").value;
    	var vehicleWeight   = document.getElementById("carWeightInput").value;

    	document.getElementById("carWidthTop").innerHTML    = vehicleWidthTop + " mm";
    	document.getElementById("carHeightTop").innerHTML   = vehicleLenght   + " mm";
    	document.getElementById("carHeightSide").innerHTML  = vehicleHeight   + " mm";
    	document.getElementById("carWidthBottom").innerHTML = vehicleWeelBase + " mm";
    	document.getElementById("carWeight").innerHTML      = vehicleWeight   + " kg";

    }

    // !!! calculate price rent for user period in price blocks
    jQuery(function(){
    	 // Rent price calculators
        jQuery(".rent-select").change(function(){

           	var selected = jQuery(this).find('option:selected').val();
    	 	var extra    = jQuery(this).find('option:selected').data('months');
    	 	//  to numbers
    	 	var selectedNum = parseInt(selected);
    	 	var extraNum    = parseInt(extra);

    		//  output prices
    		var monthPr = jQuery(this).parent().parent().parent().find(".rent-text span").text(selectedNum);
    		var totalPr = jQuery(this).parent().parent().parent().find(".total-price span").text(extraNum*selectedNum);
    		// verify result ;-)
    	 	
    	 	//console.log(extraNum * selectedNum);

        });

    	// Basic price - one month free
    	jQuery(".oneFree").change( function(){

    		var selected = jQuery(this).find('option:selected').val();
    		var extra    = jQuery(this).find('option:selected').data('months');
    		//  to numbers
    		var selectedNum = parseInt(selected);
    		var extraNum    = parseInt(extra);

    		// output for one month free prices
    		var oneFreeNum = (( selectedNum*extraNum - selectedNum )/extraNum).toFixed(2);
    		var oneFree = jQuery(".oneFree").parent().parent().parent().find(".rent-text span").text(oneFreeNum);
    		var totalPr = jQuery(this).parent().parent().parent().find(".total-price span").text(extraNum*selectedNum - selectedNum);

    		if(isNaN(oneFreeNum)) {
    			jQuery(".oneFree").parent().parent().parent().find(".rent-text span").text(0)
    		}

    		//console.log(oneFreeNum);

    	});
    });

})(jQuery);
