<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme autoroyal for publication on WordPress.org
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/inc/tgmpa/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'autoroyal_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 */
function autoroyal_register_required_plugins() {
	$plugins = array(
		// This is an example of how to include a plugin bundled with a theme.
		array(
            'name'               => 'WPBakery Visual Composer', // The plugin name
            'slug'               => 'js_composer', // The plugin slug (typically the folder name)
            'source'             => get_template_directory_uri() . '/inc/plugins/js_composer.zip', // The plugin source
            'required'           => true, // If false, the plugin is only 'recommended' instead of required
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'       => '', // If set, overrides default API URL and points to an external URL
        ),
        array(
            'name'               => 'Category Icon',
            'slug'               => 'category-icon',
            'required'           => true
        ),
        array(
            'name'               => 'WooCommerce',
            'slug'               => 'woocommerce',
            'required'           => true
        ),
        array(
            'name'               => 'autoRoyal Plugin', // The plugin name
            'slug'               => 'autoroyal', // The plugin slug (typically the folder name)
            'source'             => get_template_directory_uri() . '/inc/plugins/autoroyal.zip', // The plugin source
            'required'           => true, // If false, the plugin is only 'recommended' instead of required
        ),
        array(
            'name'               => 'Safe SVG',
            'slug'               => 'safe-svg',
            'required'           => true
        ),
        array(
            'name'               => 'SVG Support',
            'slug'               => 'svg-support',
            'required'           => true
        ),
	);

	/*
	 * Array of configuration settings. Amend each line as needed.
	 */
	$config = array(
		'id'           => 'autoroyal',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => '',
	);

	tgmpa( $plugins, $config );
}
