<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$moveme_post_format = get_post_format();
$moveme_post_format = empty($moveme_post_format) ? 'standard' : str_replace('post-format-', '', $moveme_post_format);
$moveme_animation = moveme_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($moveme_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($moveme_post_format) ); ?>
	<?php echo (!moveme_is_off($moveme_animation) ? ' data-animation="'.esc_attr(moveme_get_animation_classes($moveme_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	moveme_show_post_featured(array(
		'thumb_size' => moveme_get_thumb_size($moveme_columns==1 ? 'big' : ($moveme_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($moveme_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			moveme_show_post_meta(apply_filters('moveme_filter_post_meta_args', array(), 'sticky', $moveme_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>