<?php
/* WPBakery Page Builder support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('moveme_vc_theme_setup9')) {
	add_action( 'after_setup_theme', 'moveme_vc_theme_setup9', 9 );
	function moveme_vc_theme_setup9() {
		if (moveme_exists_visual_composer()) {
			add_action( 'wp_enqueue_scripts', 								'moveme_vc_frontend_scripts', 1100 );
			add_filter( 'moveme_filter_merge_styles',						'moveme_vc_merge_styles' );
	
			// Add/Remove params in the standard VC shortcodes
			//-----------------------------------------------------
			add_filter( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG,					'moveme_vc_add_params_classes', 10, 3 );
			
			// Color scheme
			$scheme = array(
				"param_name" => "scheme",
				"heading" => esc_html__("Color scheme", 'moveme'),
				"description" => wp_kses_data( __("Select color scheme to decorate this block", 'moveme') ),
				"group" => esc_html__('Colors', 'moveme'),
				"admin_label" => true,
				"value" => array_flip(moveme_get_list_schemes(true)),
				"type" => "dropdown"
			);
			vc_add_param("vc_section", $scheme);
			vc_add_param("vc_row", $scheme);
			vc_add_param("vc_row_inner", $scheme);
			vc_add_param("vc_column", $scheme);
			vc_add_param("vc_column_inner", $scheme);
			vc_add_param("vc_column_text", $scheme);
			
			// Alter height and hide on mobile for Empty Space
			vc_add_param("vc_empty_space", array(
				"param_name" => "alter_height",
				"heading" => esc_html__("Alter height", 'moveme'),
				"description" => wp_kses_data( __("Select alternative height instead value from the field above", 'moveme') ),
				"admin_label" => true,
				"value" => array(
					esc_html__('Tiny', 'moveme') => 'tiny',
					esc_html__('Small', 'moveme') => 'small',
					esc_html__('Medium', 'moveme') => 'medium',
                    esc_html__('Big', 'moveme') => 'biggest',
					esc_html__('Large', 'moveme') => 'large',
					esc_html__('Huge', 'moveme') => 'huge',
					esc_html__('From the value above', 'moveme') => 'none'
				),
				"type" => "dropdown"
			));
			vc_add_param("vc_empty_space", array(
				"param_name" => "hide_on_mobile",
				"heading" => esc_html__("Hide on mobile", 'moveme'),
				"description" => wp_kses_data( __("Hide this block on the mobile devices, when the columns are arranged one under another", 'moveme') ),
				"admin_label" => true,
				"std" => 0,
				"value" => array(
					esc_html__("Hide on mobile", 'moveme') => "1",
					esc_html__("Hide on tablet", 'moveme') => "3",
					esc_html__("Hide on notebook", 'moveme') => "2" 
					),
				"type" => "checkbox"
			));
			
			// Add Narrow style to the Progress bars
			vc_add_param("vc_progress_bar", array(
				"param_name" => "narrow",
				"heading" => esc_html__("Narrow", 'moveme'),
				"description" => wp_kses_data( __("Use narrow style for the progress bar", 'moveme') ),
				"std" => 0,
				"value" => array(esc_html__("Narrow style", 'moveme') => "1" ),
				"type" => "checkbox"
			));


            vc_add_param("vc_tta_tabs", array(
                "param_name" => "vertical",
                "heading" => esc_html__("Vertical", 'moveme'),
                "description" => wp_kses_data( __("Use vertical style for the tabs", 'moveme') ),
                "std" => 0,
                "value" => array(esc_html__("Vertical style", 'moveme') => "1" ),
                "type" => "checkbox"
            ));
			
			// Add param 'Closeable' to the Message Box
			vc_add_param("vc_message", array(
				"param_name" => "closeable",
				"heading" => esc_html__("Closeable", 'moveme'),
				"description" => wp_kses_data( __("Add 'Close' button to the message box", 'moveme') ),
				"std" => 0,
				"value" => array(esc_html__("Closeable", 'moveme') => "1" ),
				"type" => "checkbox"
			));
		}
		if (is_admin()) {
			add_filter( 'moveme_filter_tgmpa_required_plugins',		'moveme_vc_tgmpa_required_plugins' );
			add_filter( 'vc_iconpicker-type-fontawesome',				'moveme_vc_iconpicker_type_fontawesome' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'moveme_vc_tgmpa_required_plugins' ) ) {
	
	function moveme_vc_tgmpa_required_plugins($list=array()) {
		if (in_array('js_composer', moveme_storage_get('required_plugins'))) {
			$path = moveme_get_file_dir('plugins/js_composer/js_composer.zip');
			$list[] = array(
					'name' 		=> esc_html__('WPBakery Page Builder', 'moveme'),
					'slug' 		=> 'js_composer',
                    'version'	=> '6.4.1',
					'source'	=> !empty($path) ? $path : 'upload://js_composer.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if WPBakery Page Builder installed and activated
if ( !function_exists( 'moveme_exists_visual_composer' ) ) {
	function moveme_exists_visual_composer() {
		return class_exists('Vc_Manager');
	}
}

// Check if WPBakery Page Builder in frontend editor mode
if ( !function_exists( 'moveme_vc_is_frontend' ) ) {
	function moveme_vc_is_frontend() {
		return (isset($_GET['vc_editable']) && $_GET['vc_editable']=='true')
			|| (isset($_GET['vc_action']) && $_GET['vc_action']=='vc_inline');

	}
}
	
// Enqueue VC custom styles
if ( !function_exists( 'moveme_vc_frontend_scripts' ) ) {
	
	function moveme_vc_frontend_scripts() {
		if (moveme_exists_visual_composer()) {
			if (moveme_is_on(moveme_get_theme_option('debug_mode')) && moveme_get_file_dir('plugins/js_composer/js_composer.css')!='')
				wp_enqueue_style( 'moveme-js-composer',  moveme_get_file_url('plugins/js_composer/js_composer.css'), array(), null );
		}
	}
}
	
// Merge custom styles
if ( !function_exists( 'moveme_vc_merge_styles' ) ) {
	
	function moveme_vc_merge_styles($list) {
		$list[] = 'plugins/js_composer/js_composer.css';
		return $list;
	}
}
	
// Add theme icons into VC iconpicker list
if ( !function_exists( 'moveme_vc_iconpicker_type_fontawesome' ) ) {
	
	function moveme_vc_iconpicker_type_fontawesome($icons) {
		$list = moveme_get_list_icons();
		if (!is_array($list) || count($list) == 0) return $icons;
		$rez = array();
		foreach ($list as $icon)
			$rez[] = array($icon => str_replace('icon-', '', $icon));
		return array_merge( $icons, array(esc_html__('Theme Icons', 'moveme') => $rez) );
	}
}



// Shortcodes
//------------------------------------------------------------------------

// Add params to the standard VC shortcodes
if ( !function_exists( 'moveme_vc_add_params_classes' ) ) {
	
	function moveme_vc_add_params_classes($classes, $sc, $atts) {
		if (in_array($sc, array('vc_section', 'vc_row', 'vc_row_inner', 'vc_column', 'vc_column_inner', 'vc_column_text'))) {
			if (!empty($atts['scheme']) && !moveme_is_inherit($atts['scheme']))
				$classes .= ($classes ? ' ' : '') . 'scheme_' . $atts['scheme'];
		} else if (in_array($sc, array('vc_empty_space'))) {
			if (!empty($atts['alter_height']) && !moveme_is_off($atts['alter_height']))
				$classes .= ($classes ? ' ' : '') . 'height_' . $atts['alter_height'];
			if (!empty($atts['hide_on_mobile'])) {
				if (strpos($atts['hide_on_mobile'], '1')!==false)	$classes .= ($classes ? ' ' : '') . 'hide_on_mobile';
				if (strpos($atts['hide_on_mobile'], '2')!==false)	$classes .= ($classes ? ' ' : '') . 'hide_on_notebook';
				if (strpos($atts['hide_on_mobile'], '3')!==false)	$classes .= ($classes ? ' ' : '') . 'hide_on_tablet';
			}
		} else if (in_array($sc, array('vc_progress_bar'))) {
			if (!empty($atts['narrow']) && (int) $atts['narrow']==1)
				$classes .= ($classes ? ' ' : '') . 'vc_progress_bar_narrow';
		} else if (in_array($sc, array('vc_tta_tabs'))) {
            if (!empty($atts['vertical']) && (int) $atts['vertical']==1)
                $classes .= ($classes ? ' ' : '') . 'vertical';
        }else if (in_array($sc, array('vc_message'))) {
			if (!empty($atts['closeable']) && (int) $atts['closeable']==1)
				$classes .= ($classes ? ' ' : '') . 'vc_message_box_closeable';
		}
		return $classes;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (moveme_exists_visual_composer()) { require_once MOVEME_THEME_DIR . 'plugins/js_composer/js_composer.styles.php'; }
?>