<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( !function_exists( 'moveme_vc_get_css' ) ) {
	add_filter( 'moveme_filter_get_css', 'moveme_vc_get_css', 10, 4 );
	function moveme_vc_get_css($css, $colors, $fonts, $scheme='') {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS
			.vc_progress_bar .vc_single_bar .vc_label,
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label .vc_label_units
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label,
.wpb-js-composer .vc_tta.vc_tta-style-classic .vc_tta-tab,
.vc_tta.vc_tta-accordion .vc_tta-panel-title .vc_tta-title-text {
	{$fonts['h1_font-family']}
}
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label .vc_label_units {
}

CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Row and columns */
.scheme_self.vc_section,
.scheme_self.wpb_row,
.scheme_self.wpb_column > .vc_column-inner > .wpb_wrapper,
.scheme_self.wpb_text_column {
	color: {$colors['text']};
}
.scheme_self.vc_section[data-vc-full-width="true"],
.scheme_self.wpb_row[data-vc-full-width="true"],
.scheme_self.wpb_column > .vc_column-inner > .wpb_wrapper,
.scheme_self.wpb_text_column {
	background-color: {$colors['bg_color']};
}
.scheme_self.vc_row.vc_parallax[class*="scheme_"] .vc_parallax-inner:before {
	background-color: {$colors['bg_color_08']};
}

/* Accordion */
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon:before,
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon:after {
	border-color: {$colors['inverse_link']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a {
	color: {$colors['text_dark']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover {
	color: {$colors['text_link']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a .vc_tta-controls-icon,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover .vc_tta-controls-icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a .vc_tta-controls-icon:before,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a .vc_tta-controls-icon:after {
	color: {$colors['inverse_link']};
}

.wpb-js-composer .vc_tta.vc_general .vc_tta-panel.vc_active {
    background-color: {$colors['text_link3']};
}
.vc_tta-panel:not(.vc_active) + .vc_tta-panel {
    border-color: {$colors['bd_color']};
}

/* Tabs */
body.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tabs-list .vc_tta-tab > a {
	color: {$colors['text_dark']};
	background-color: {$colors['text_link']};
}
body.wpb-js-composer  .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tabs-list .vc_tta-tab > a:hover,
body.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tabs-list .vc_tta-tab.vc_active > a {
	color: {$colors['text_dark']};
	background-color: {$colors['text_link3']};
}

/* Separator */
.vc_separator.vc_sep_color_grey .vc_sep_line {
	border-color: {$colors['bd_color']};
}

/* Progress bar */
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar {
	background-color: {$colors['text_link3']};
}
.vc_progress_bar.vc_progress_bar_narrow.vc_progress-bar-color-bar_red .vc_single_bar .vc_bar {
	background-color: {$colors['alter_link']};
}
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label {
	color: {$colors['text_dark']};
}
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label .vc_label_units {
	color: {$colors['text_dark']};
}
.vc_progress_bar .vc_single_bar {
	background-color: {$colors['text_dark_02']};
}

/*-----------
 Notices
-----------*/


.vc_message_box.vc_message_box_closeable:after {
    background-color: {$colors['bg_color_02']};
    color: {$colors['bg_color']};
}

/* General */
.vc_color-grey.vc_message_box {
    background-color: {$colors['text_link3']};
    color: {$colors['text_dark']};
}
.vc_color-grey.vc_message_box.vc_message_box_closeable:after {
    background-color: {$colors['text_dark_02']};
}
.vc_color-grey.vc_message_box .vc_message_box-icon {
    color: {$colors['text_dark']};
}
/* Warning */
.vc_color-warning.vc_message_box {
    background-color: {$colors['text_link']};
    color: {$colors['inverse_text']};
}
.vc_color-warning.vc_message_box .vc_message_box-icon {
    color: {$colors['bg_color_06']};
}

/* Info */
.vc_color-info.vc_message_box {
    background-color: {$colors['text_hover3']};
    color: {$colors['inverse_text']};
}
.vc_color-info.vc_message_box .vc_message_box-icon {
    color: {$colors['bg_color_06']};
}
/* Success */
.vc_color-success.vc_message_box {
    background-color: {$colors['text_hover2']};
    color: {$colors['inverse_text']};
}
.vc_color-success.vc_message_box .vc_message_box-icon {
    color: {$colors['bg_color_06']};
}

body.wpb-js-composer .vc_tta-color-grey.vertical .vc_tta-tabs-list .vc_tta-tab > a {
     background-color: {$colors['bg_color_0']};
}
body.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic.vertical .vc_tta-tabs-list .vc_tta-tab>a:before {
    background-color: {$colors['text_link']};
    color: {$colors['bg_color']};
}
body.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tabs-list .vc_tta-tab>a:hover,
body.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tabs-list .vc_tta-tab.vc_active>a  .vc_tta-icon {
    color: {$colors['text_link']};
}
CSS;
		}
		
		return $css;
	}
}
?>