<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_sidebar_position = moveme_get_theme_option('sidebar_position');
if (moveme_sidebar_present()) {
	ob_start();
	$moveme_sidebar_name = moveme_get_theme_option('sidebar_widgets');
	moveme_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($moveme_sidebar_name) ) {
		dynamic_sidebar($moveme_sidebar_name);
	}
	$moveme_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($moveme_out)) {
		?>
		<div class="sidebar <?php echo esc_attr($moveme_sidebar_position); ?> widget_area<?php if (!moveme_is_inherit(moveme_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(moveme_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'moveme_action_before_sidebar' );
				moveme_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $moveme_out));
				do_action( 'moveme_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>