<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0.10
 */

// Logo
if (moveme_is_on(moveme_get_theme_option('logo_in_footer'))) {
	$moveme_logo_image = '';
	if (moveme_get_retina_multiplier(2) > 1)
		$moveme_logo_image = moveme_get_theme_option( 'logo_footer_retina' );
	if (empty($moveme_logo_image)) 
		$moveme_logo_image = moveme_get_theme_option( 'logo_footer' );
	$moveme_logo_text   = get_bloginfo( 'name' );
	if (!empty($moveme_logo_image) || !empty($moveme_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($moveme_logo_image)) {
					$moveme_attr = moveme_getimagesize($moveme_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($moveme_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('Image', 'moveme').'"'.(!empty($moveme_attr[3]) ? sprintf(' %s', $moveme_attr[3]) : '').'></a>' ;
				} else if (!empty($moveme_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($moveme_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>