<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0.10
 */

// Footer sidebar
$moveme_footer_name = moveme_get_theme_option('footer_widgets');
$moveme_footer_present = !moveme_is_off($moveme_footer_name) && is_active_sidebar($moveme_footer_name);
if ($moveme_footer_present) { 
	moveme_storage_set('current_sidebar', 'footer');
	$moveme_footer_wide = moveme_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($moveme_footer_name) ) {
		dynamic_sidebar($moveme_footer_name);
	}
	$moveme_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($moveme_out)) {
		$moveme_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $moveme_out);
		$moveme_need_columns = true;
		if ($moveme_need_columns) {
			$moveme_columns = max(0, (int) moveme_get_theme_option('footer_columns'));
			if ($moveme_columns == 0) $moveme_columns = min(4, max(1, substr_count($moveme_out, '<aside ')));
			if ($moveme_columns > 1)
				$moveme_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($moveme_columns).' widget ', $moveme_out);
			else
				$moveme_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($moveme_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$moveme_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($moveme_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'moveme_action_before_sidebar' );
				moveme_show_layout($moveme_out);
				do_action( 'moveme_action_after_sidebar' );
				if ($moveme_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$moveme_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>