<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0.14
 */
$moveme_header_video = moveme_get_header_video();
$moveme_embed_video = '';
if (!empty($moveme_header_video) && !moveme_is_from_uploads($moveme_header_video)) {
	if (moveme_is_youtube_url($moveme_header_video) && preg_match('/[=\/]([^=\/]*)$/', $moveme_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$moveme_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($moveme_header_video) . '[/embed]' ));
			$moveme_embed_video = moveme_make_video_autoplay($moveme_embed_video);
		} else {
			$moveme_header_video = str_replace('/watch?v=', '/embed/', $moveme_header_video);
			$moveme_header_video = moveme_add_to_url($moveme_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => esc_url(home_url('/')),
				'widgetid' => 1
			));
			$moveme_embed_video = '<iframe src="' . esc_url($moveme_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php moveme_show_layout($moveme_embed_video); ?></div><?php
	}
}
?>