<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0.22
 */

// Theme init priorities:
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
if ( !function_exists('moveme_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'moveme_customizer_theme_setup1', 1 );
	function moveme_customizer_theme_setup1() {
		
		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		moveme_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Poppins',
				'family' => 'sans-serif',
				'styles' => '400,500,600,700'		// Parameter 'style' used only for the Google fonts
				),
			// Font-face packed with theme
			array(
				'name'   => 'Roboto Slab',
				'family' => 'serif',
                'styles' => '400,700'
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		moveme_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		moveme_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'moveme'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'moveme'),
				'font-family'		=> 'Roboto Slab, serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.86',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.8em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '6.071em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '0.94',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-2.6px',
				'margin-top'		=> '0.9583em',
				'margin-bottom'		=> '0.344em'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '4.286em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-1.8px',
				'margin-top'		=> '1.0444em',
				'margin-bottom'		=> '0.493em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '3.571em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-1.55px',
				'margin-top'		=> '1.27em',
				'margin-bottom'		=> '0.65em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '2.571em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.17',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-1.1px',
				'margin-top'		=> '1.63em',
				'margin-bottom'		=> '0.8em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '2em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.21',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.9px',
				'margin-top'		=> '2.155em',
				'margin-bottom'		=> '1.29em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1.571em',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.36',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.66px',
				'margin-top'		=> '3.099em',
				'margin-bottom'		=> '1.1em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'moveme'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'moveme'),
				'font-family'		=> 'Poppins,serif',
				'font-size' 		=> '2.143em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'moveme'),
				'font-family'		=> 'Poppins,serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'moveme'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'moveme'),
				'font-family'		=> 'Roboto, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'moveme'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'moveme'),
				'font-family'		=> 'Poppins,serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.4px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'moveme'),
				'description'		=> esc_html__('Font settings of the main menu items', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.1px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'moveme'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'moveme'),
				'font-family'		=> 'Poppins, sans-serif',
				'font-size' 		=> '1.143rem',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		moveme_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'moveme'),
							'description'	=> esc_html__('Colors of the main content area', 'moveme')
							),
			'alter'	=> array(
							'title'			=> esc_html__('Alter', 'moveme'),
							'description'	=> esc_html__('Colors of the alternative blocks (sidebars, etc.)', 'moveme')
							),
			'extra'	=> array(
							'title'			=> esc_html__('Extra', 'moveme'),
							'description'	=> esc_html__('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'moveme')
							),
			'inverse' => array(
							'title'			=> esc_html__('Inverse', 'moveme'),
							'description'	=> esc_html__('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'moveme')
							),
			'input'	=> array(
							'title'			=> esc_html__('Input', 'moveme'),
							'description'	=> esc_html__('Colors of the form fields (text field, textarea, select, etc.)', 'moveme')
							),
			)
		);
		moveme_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__('Background color', 'moveme'),
							'description'	=> esc_html__('Background color of this block in the normal state', 'moveme')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__('Background hover', 'moveme'),
							'description'	=> esc_html__('Background color of this block in the hovered state', 'moveme')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__('Border color', 'moveme'),
							'description'	=> esc_html__('Border color of this block in the normal state', 'moveme')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__('Border hover', 'moveme'),
							'description'	=> esc_html__('Border color of this block in the hovered state', 'moveme')
							),
			'text'		=> array(
							'title'			=> esc_html__('Text', 'moveme'),
							'description'	=> esc_html__('Color of the plain text inside this block', 'moveme')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__('Text dark', 'moveme'),
							'description'	=> esc_html__('Color of the dark text (bold, header, etc.) inside this block', 'moveme')
							),
			'text_light'=> array(
							'title'			=> esc_html__('Text light', 'moveme'),
							'description'	=> esc_html__('Color of the light text (post meta, etc.) inside this block', 'moveme')
							),
			'text_link'	=> array(
							'title'			=> esc_html__('Link', 'moveme'),
							'description'	=> esc_html__('Color of the links inside this block', 'moveme')
							),
			'text_hover'=> array(
							'title'			=> esc_html__('Link hover', 'moveme'),
							'description'	=> esc_html__('Color of the hovered state of links inside this block', 'moveme')
							),
			'text_link2'=> array(
							'title'			=> esc_html__('Link 2', 'moveme'),
							'description'	=> esc_html__('Color of the accented texts (areas) inside this block', 'moveme')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__('Link 2 hover', 'moveme'),
							'description'	=> esc_html__('Color of the hovered state of accented texts (areas) inside this block', 'moveme')
							),
			'text_link3'=> array(
							'title'			=> esc_html__('Link 3', 'moveme'),
							'description'	=> esc_html__('Color of the other accented texts (buttons) inside this block', 'moveme')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__('Link 3 hover', 'moveme'),
							'description'	=> esc_html__('Color of the hovered state of other accented texts (buttons) inside this block', 'moveme')
							)
			)
		);
		moveme_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'moveme'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff',
					'bd_color'			=> '#f3f2f2',       //
		
					// Text and links colors
					'text'				=> '#827a70',      //
					'text_light'		=> '#dac4a8',      //
					'text_dark'			=> '#5c524b',      //
					'text_link'			=> '#f9c649',      //
					'text_hover'		=> '#e9b847',      //
					'text_link2'		=> '#d7c0a2',      //
					'text_hover2'		=> '#ab9477',      //
					'text_link3'		=> '#f5f4f2',      //
					'text_hover3'		=> '#7aa8bd',       //
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#000000',
					'alter_bg_hover'	=> '#000000',
					'alter_bd_color'	=> '#d9d7d4',   //
					'alter_bd_hover'	=> '#dadada',
					'alter_text'		=> '#333333',
					'alter_light'		=> '#b7b7b7',
					'alter_dark'		=> '#272423',   //
					'alter_link'		=> '#fe7259',
					'alter_hover'		=> '#72cfd5',
					'alter_link2'		=> '#80d572',
					'alter_hover2'		=> '#8be77c',
					'alter_link3'		=> '#ddb837',
					'alter_hover3'		=> '#eec432',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#9e886d',       //
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#ededec',       //
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#bfbfbf',
					'extra_light'		=> '#afafaf',
					'extra_dark'		=> '#000000',
					'extra_link'		=> '#ac9579',   //
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#f5f5f3',      //
					'input_bg_hover'	=> '#f5f5f3',      //
					'input_bd_color'	=> '#e7eaed',
					'input_bd_hover'	=> '#e0e0e0',
					'input_text'		=> '#b7b7b7',
					'input_light'		=> '#d0d0d0',
					'input_dark'		=> '#1d1d1d',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#ffffff',       //
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'moveme'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#0e0d12',
					'bd_color'			=> '#1c1b1f',
		
					// Text and links colors
					'text'				=> '#ffffff',   //
					'text_light'		=> '#5f5f5f',
					'text_dark'			=> '#ffffff',
					'text_link'			=> '#f9c649',   //
					'text_hover'		=> '#ffaa5f',
					'text_link2'		=> '#ac9579',   //
					'text_hover2'		=> '#ab9477',   //
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#1e1d22',
					'alter_bg_hover'	=> '#28272e',
					'alter_bd_color'	=> '#313131',
					'alter_bd_hover'	=> '#3d3d3d',
					'alter_text'		=> '#827a70',
					'alter_light'		=> '#5f5f5f',
					'alter_dark'		=> '#ffffff',
					'alter_link'		=> '#ffaa5f',
					'alter_hover'		=> '#fe7259',
					'alter_link2'		=> '#80d572',
					'alter_hover2'		=> '#8be77c',
					'alter_link3'		=> '#ddb837',
					'alter_hover3'		=> '#eec432',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#1e1d22',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#313131',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#827a70',
					'extra_light'		=> '#5f5f5f',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#ac9579',   //
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#c5af92',   //
					'input_bg_hover'	=> '#c5af92',   //
					'input_bd_color'	=> '#2e2d32',
					'input_bd_hover'	=> '#353535',
					'input_text'		=> '#b7b7b7',
					'input_light'		=> '#5f5f5f',
					'input_dark'		=> '#ffffff',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#1d1d1d',
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
	}
}

			
// Additional (calculated) theme-specific colors
// Attention! Don't forget setup custom colors also in the theme.customizer.color-scheme.js
if (!function_exists('moveme_customizer_add_theme_colors')) {
	function moveme_customizer_add_theme_colors($colors) {
		if (substr($colors['text'], 0, 1) == '#') {
			$colors['bg_color_0']  = moveme_hex2rgba( $colors['bg_color'], 0 );
			$colors['bg_color_02']  = moveme_hex2rgba( $colors['bg_color'], 0.2 );
            $colors['bg_color_06']  = moveme_hex2rgba( $colors['bg_color'], 0.6 );
			$colors['bg_color_07']  = moveme_hex2rgba( $colors['bg_color'], 0.7 );
			$colors['bg_color_08']  = moveme_hex2rgba( $colors['bg_color'], 0.8 );
			$colors['bg_color_09']  = moveme_hex2rgba( $colors['bg_color'], 0.9 );
			$colors['alter_bg_color_07']  = moveme_hex2rgba( $colors['alter_bg_color'], 0.7 );
			$colors['alter_bg_color_04']  = moveme_hex2rgba( $colors['alter_bg_color'], 0.4 );
			$colors['alter_bg_color_02']  = moveme_hex2rgba( $colors['alter_bg_color'], 0.2 );
			$colors['alter_bd_color_02']  = moveme_hex2rgba( $colors['alter_bd_color'], 0.2 );
			$colors['extra_bg_color_07']  = moveme_hex2rgba( $colors['extra_bg_color'], 0.7 );
			$colors['text_dark_07']  = moveme_hex2rgba( $colors['text_dark'], 0.7 );
            $colors['text_dark_08']  = moveme_hex2rgba( $colors['text_dark'], 0.8 );
            $colors['text_dark_02']  = moveme_hex2rgba( $colors['text_dark'], 0.2 );
            $colors['text_dark_06']  = moveme_hex2rgba( $colors['text_dark'], 0.6 );
            $colors['extra_dark_05']  = moveme_hex2rgba( $colors['extra_dark'], 0.5 );
			$colors['text_link_02']  = moveme_hex2rgba( $colors['text_link'], 0.2 );
            $colors['inverse_text_03']  = moveme_hex2rgba( $colors['inverse_text'], 0.3);
            $colors['inverse_text_02']  = moveme_hex2rgba( $colors['inverse_text'], 0.2);
            $colors['text_link_07']  = moveme_hex2rgba( $colors['text_link'], 0.7 );
			$colors['text_link_blend'] = moveme_hsb2hex(moveme_hex2hsb( $colors['text_link'], 2, -5, 5 ));
			$colors['alter_link_blend'] = moveme_hsb2hex(moveme_hex2hsb( $colors['alter_link'], 2, -5, 5 ));
		} else {
			$colors['bg_color_0'] = '{{ data.bg_color_0 }}';
			$colors['bg_color_02'] = '{{ data.bg_color_02 }}';
			$colors['bg_color_07'] = '{{ data.bg_color_07 }}';
			$colors['bg_color_08'] = '{{ data.bg_color_08 }}';
			$colors['bg_color_09'] = '{{ data.bg_color_09 }}';
			$colors['alter_bg_color_07'] = '{{ data.alter_bg_color_07 }}';
			$colors['alter_bg_color_04'] = '{{ data.alter_bg_color_04 }}';
			$colors['alter_bg_color_02'] = '{{ data.alter_bg_color_02 }}';
			$colors['alter_bd_color_02'] = '{{ data.alter_bd_color_02 }}';
			$colors['extra_bg_color_07'] = '{{ data.extra_bg_color_07 }}';
			$colors['text_dark_07'] = '{{ data.text_dark_07 }}';
			$colors['text_link_02'] = '{{ data.text_link_02 }}';
			$colors['text_link_07'] = '{{ data.text_link_07 }}';
			$colors['text_link_blend'] = '{{ data.text_link_blend }}';
			$colors['alter_link_blend'] = '{{ data.alter_link_blend }}';
		}
		return $colors;
	}
}


			
// Additional theme-specific fonts rules
// Attention! Don't forget setup fonts rules also in the theme.customizer.color-scheme.js
if (!function_exists('moveme_customizer_add_theme_fonts')) {
	function moveme_customizer_add_theme_fonts($fonts) {
		$rez = array();	
		foreach ($fonts as $tag => $font) {

			if (substr($font['font-family'], 0, 2) != '{{') {
				$rez[$tag.'_font-family'] 		= !empty($font['font-family']) && !moveme_is_inherit($font['font-family'])
														? 'font-family:' . trim($font['font-family']) . ';' 
														: '';
				$rez[$tag.'_font-size'] 		= !empty($font['font-size']) && !moveme_is_inherit($font['font-size'])
														? 'font-size:' . moveme_prepare_css_value($font['font-size']) . ";"
														: '';
				$rez[$tag.'_line-height'] 		= !empty($font['line-height']) && !moveme_is_inherit($font['line-height'])
														? 'line-height:' . trim($font['line-height']) . ";"
														: '';
				$rez[$tag.'_font-weight'] 		= !empty($font['font-weight']) && !moveme_is_inherit($font['font-weight'])
														? 'font-weight:' . trim($font['font-weight']) . ";"
														: '';
				$rez[$tag.'_font-style'] 		= !empty($font['font-style']) && !moveme_is_inherit($font['font-style'])
														? 'font-style:' . trim($font['font-style']) . ";"
														: '';
				$rez[$tag.'_text-decoration'] 	= !empty($font['text-decoration']) && !moveme_is_inherit($font['text-decoration'])
														? 'text-decoration:' . trim($font['text-decoration']) . ";"
														: '';
				$rez[$tag.'_text-transform'] 	= !empty($font['text-transform']) && !moveme_is_inherit($font['text-transform'])
														? 'text-transform:' . trim($font['text-transform']) . ";"
														: '';
				$rez[$tag.'_letter-spacing'] 	= !empty($font['letter-spacing']) && !moveme_is_inherit($font['letter-spacing'])
														? 'letter-spacing:' . trim($font['letter-spacing']) . ";"
														: '';
				$rez[$tag.'_margin-top'] 		= !empty($font['margin-top']) && !moveme_is_inherit($font['margin-top'])
														? 'margin-top:' . moveme_prepare_css_value($font['margin-top']) . ";"
														: '';
				$rez[$tag.'_margin-bottom'] 	= !empty($font['margin-bottom']) && !moveme_is_inherit($font['margin-bottom'])
														? 'margin-bottom:' . moveme_prepare_css_value($font['margin-bottom']) . ";"
														: '';
			} else {
				$rez[$tag.'_font-family']		= '{{ data["'.$tag.'_font-family"] }}';
				$rez[$tag.'_font-size']			= '{{ data["'.$tag.'_font-size"] }}';
				$rez[$tag.'_line-height']		= '{{ data["'.$tag.'_line-height"] }}';
				$rez[$tag.'_font-weight']		= '{{ data["'.$tag.'_font-weight"] }}';
				$rez[$tag.'_font-style']		= '{{ data["'.$tag.'_font-style"] }}';
				$rez[$tag.'_text-decoration']	= '{{ data["'.$tag.'_text-decoration"] }}';
				$rez[$tag.'_text-transform']	= '{{ data["'.$tag.'_text-transform"] }}';
				$rez[$tag.'_letter-spacing']	= '{{ data["'.$tag.'_letter-spacing"] }}';
				$rez[$tag.'_margin-top']		= '{{ data["'.$tag.'_margin-top"] }}';
				$rez[$tag.'_margin-bottom']		= '{{ data["'.$tag.'_margin-bottom"] }}';
			}
		}
		return $rez;
	}
}


//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------

if ( !function_exists('moveme_customizer_theme_setup') ) {
	add_action( 'after_setup_theme', 'moveme_customizer_theme_setup' );
	function moveme_customizer_theme_setup() {

		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size(370, 0, false);
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('moveme_filter_add_thumb_sizes', array(
			'moveme-thumb-huge'		=> array(1170, 658, true),
			'moveme-thumb-big' 		=> array(1155, 615, true),
			'moveme-thumb-med' 		=> array( 740, 416, true),
                'moveme-thumb-serv' 		=> array( 1000, 1000, true),
                'moveme-thumb-team' 		=> array( 540, 730, true),
			'moveme-thumb-tiny' 		=> array(  180,  180, true),
			'moveme-thumb-masonry-big' => array( 760,   0, false),		// Only downscale, not crop
			'moveme-thumb-masonry'		=> array( 370,   0, false),		// Only downscale, not crop
			)
		);
		$mult = moveme_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'moveme_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}

	}
}

if ( !function_exists('moveme_customizer_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'moveme_customizer_image_sizes' );
	function moveme_customizer_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('moveme_filter_add_thumb_sizes', array(
			'moveme-thumb-huge'		=> esc_html__( 'Fullsize image', 'moveme' ),
			'moveme-thumb-big'			=> esc_html__( 'Large image', 'moveme' ),
			'moveme-thumb-med'			=> esc_html__( 'Medium image', 'moveme' ),
			'moveme-thumb-tiny'		=> esc_html__( 'Small square avatar', 'moveme' ),
			'moveme-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'moveme' ),
			'moveme-thumb-masonry'		=> esc_html__( 'Masonry (scaled)', 'moveme' ),
			)
		);
		$mult = moveme_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'moveme' );
		}
		return $sizes;
	}
}

// Remove some thumb-sizes from the ThemeREX Addons list
if ( !function_exists( 'moveme_customizer_trx_addons_add_thumb_sizes' ) ) {
	add_filter( 'trx_addons_filter_add_thumb_sizes', 'moveme_customizer_trx_addons_add_thumb_sizes');
	function moveme_customizer_trx_addons_add_thumb_sizes($list=array()) {
		if (is_array($list)) {
			foreach ($list as $k=>$v) {
				if (in_array($k, array(
								'trx_addons-thumb-huge',
								'trx_addons-thumb-big',
								'trx_addons-thumb-medium',
								'trx_addons-thumb-tiny',
								'trx_addons-thumb-masonry-big',
								'trx_addons-thumb-masonry',
								)
							)
						) unset($list[$k]);
			}
		}
		return $list;
	}
}

// and replace removed styles with theme-specific thumb size
if ( !function_exists( 'moveme_customizer_trx_addons_get_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_get_thumb_size', 'moveme_customizer_trx_addons_get_thumb_size');
	function moveme_customizer_trx_addons_get_thumb_size($thumb_size='') {
		return str_replace(array(
							'trx_addons-thumb-huge',
							'trx_addons-thumb-huge-@retina',
							'trx_addons-thumb-big',
							'trx_addons-thumb-big-@retina',
							'trx_addons-thumb-medium',
							'trx_addons-thumb-medium-@retina',
                'trx_addons-thumb-serv',
                'trx_addons-thumb-serv-@retina',
                'trx_addons-thumb-team',
                'trx_addons-thumb-team-@retina',
							'trx_addons-thumb-tiny',
							'trx_addons-thumb-tiny-@retina',
							'trx_addons-thumb-masonry-big',
							'trx_addons-thumb-masonry-big-@retina',
							'trx_addons-thumb-masonry',
							'trx_addons-thumb-masonry-@retina',
							),
							array(
							'moveme-thumb-huge',
							'moveme-thumb-huge-@retina',
							'moveme-thumb-big',
							'moveme-thumb-big-@retina',
							'moveme-thumb-med',
							'moveme-thumb-med-@retina',
                                'moveme-thumb-serv',
                                'moveme-thumb-serv-@retina',
                                'moveme-thumb-team',
                                'moveme-thumb-team-@retina',
							'moveme-thumb-tiny',
							'moveme-thumb-tiny-@retina',
							'moveme-thumb-masonry-big',
							'moveme-thumb-masonry-big-@retina',
							'moveme-thumb-masonry',
							'moveme-thumb-masonry-@retina',
							),
							$thumb_size);
	}
}
?>