<?php

/////////////////// Section ///////////////////
$wp_customize->add_section( 'autoroyal_author',
array(
    'title' => esc_html__( 'ThemeForest Link', 'autoroyal' ), //Visible title of section
    'priority' => 55, //Determines what order this appears in
    'capability' => 'edit_theme_options', //Capability needed to tweak
    'description' => esc_html__('Allows you to customize Buy Theme on ThemeForest button', 'autoroyal'), //Descriptive tooltip
    'panel'  => 'autoroyal_settings_options',
    )
);
////////////////////////////////////////////////

// <editor-fold defaultstate="collapsed" desc=" footer_copyright_text ">
$wp_customize->add_setting( 'buy_button_link',
array(
    'default' => "", //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_url',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('buy_button_link', array(
    'settings' => 'buy_button_link',
    'label'    => esc_html__('Buy Theme Now URL', 'autoroyal'),
    'section'  => 'autoroyal_author',
    'type'     => 'text',
));
// </editor-fold>