<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package fantasy_themes
 */

get_header(); ?>

<?php
	$default_sidebar_position = get_theme_mod( 'default_sidebar_position', 'right' );
?>

	<div class="autoroyal-front-dashboard">

        <div id="primary" class="content-area">

			<main id="main" class="site-main">

				<div class="autoroyal-page-title" <?php if(!empty($image)) { ?>style="background-image: url('<?php echo esc_url($image[0]); ?>')"<?php } ?>>

                    <div class="container">

                        <h2><?php
							/* translators: %s: search query. */
							printf( esc_html__( 'Search Results for: %s', 'autoroyal' ), '<span>' . get_search_query() . '</span>' );
						?></h2>
                        
                    </div>

                </div>

                <div class="container">

                    <div class="row">

                        <div class="autoroyal-full-width-page col-md-12">

                            <div class="row justify-content-center">

                            	<div class="col-md-8 fantasy-themes-content-width">

                        		<?php
								if ( have_posts() ) : ?>

									<?php
									/* Start the Loop */
									while ( have_posts() ) : the_post();

										/**
										 * Run the loop for the search to output the results.
										 * If you want to overload this in a child theme then include a file
										 * called content-search.php and that will be used instead.
										 */
										get_template_part( 'template-parts/content', 'search' );

									endwhile;

									the_posts_navigation( array(
										'next_text'         => esc_html__( 'Newer Posts', 'autoroyal' ),
										'prev_text'         => esc_html__( 'Older Posts', 'autoroyal' ),
									) );

								else :

									get_template_part( 'template-parts/content', 'none' );

								endif; ?>

							</div>

							<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
							<div class="col-md-4 fantasy-themes-sidebar-width">
								<?php get_sidebar(); ?>
							</div>
							<?php endif; ?>

						</div>

					</div>

				</div>

			</main><!-- #main -->

		</div><!-- #primary -->

	</div>
	<!-- /.container -->

<?php
get_footer();
