<?php
/**
 * Brokerage Single Template
 *
 * @package WP Pro Real Estate 7
 * @subpackage Template
 */
 
global $ct_options;

$ct_brokerage_url = get_post_meta($post->ID, "_ct_brokerage_url", true);
$ct_brokerage_email = get_post_meta($post->ID, "_ct_brokerage_email", true);
$ct_brokerage_phone = get_post_meta($post->ID, "_ct_brokerage_phone", true);
$ct_brokerage_fax = get_post_meta($post->ID, "_ct_brokerage_fax", true);
$ct_brokerage_street_address = get_post_meta($post->ID, "_ct_brokerage_street_address", true);
$ct_brokerage_address_two = get_post_meta($post->ID, "_ct_brokerage_address_two", true);
$ct_brokerage_city = get_post_meta($post->ID, "_ct_brokerage_city", true);
$ct_brokerage_state = get_post_meta($post->ID, "_ct_brokerage_state", true);
$ct_brokerage_zip = get_post_meta($post->ID, "_ct_brokerage_zip", true);
$ct_brokerage_country = get_post_meta($post->ID, "_ct_brokerage_country", true);

$ct_brokerage_twitter = get_post_meta($post->ID, "_ct_brokerage_twitter", true);
$ct_brokerage_facebook = get_post_meta($post->ID, "_ct_brokerage_facebook", true);
$ct_brokerage_linkedin = get_post_meta($post->ID, "_ct_brokerage_linkedin", true);
$ct_brokerage_gplus = get_post_meta($post->ID, "_ct_brokerage_gplus", true);

$ct_agent_layout = isset( $ct_options['ct_agent_layout'] ) ? $ct_options['ct_agent_layout'] : '';
$ct_brokerage_reviews = isset( $ct_options['ct_brokerage_reviews'] ) ? $ct_options['ct_brokerage_reviews'] : '';
$ct_agents_listings_per_page = isset( $ct_options['ct_agents_listings_per_page'] ) ? esc_attr( $ct_options['ct_agents_listings_per_page'] ) : '';

get_header();

do_action('before_brokerage_header');

echo '<!-- Page Header -->';
echo '<header id="title-header">';
	echo '<div class="container">';
		echo '<div class="left">';
			echo '<h5 class="marT0 marB0">';
				esc_html_e('Brokerage', 'contempo');
			echo '</h5>';
		echo '</div>';
		echo ct_breadcrumbs();
		echo '<div class="clear"></div>';
	echo '</div>';
echo '</header>';
echo '<!-- //Page Header -->';

?>

<?php do_action('before_brokerage_content'); ?>

	<div id="page-content" class="brokerage-single container marT30 padB60">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<?php $postID = get_the_ID(); if($ct_brokerage_email != '') { ?>

			<script>    
                jQuery(document).ready(function() {
                    jQuery("#listingscontact").validationEngine({
                        ajaxSubmit: true,
                        ajaxSubmitFile: "<?php echo get_template_directory_uri(); ?>/includes/ajax-submit-agent.php",
                        ajaxSubmitMessage: "<?php $contact_success = str_replace(array("\r\n", "\r", "\n"), " ", $ct_options['ct_contact_success']); echo esc_html($contact_success); ?>",
                        success :  false,
                        failure : function() {}
                    });
                });
            </script>

			<!-- Brokerage Contact Modal -->
	        <div id="overlay" class="contact-modal">
			    <div id="modal">
			    	<div id="modal-inner">
				        <span class="close"><?php ct_close_svg(); ?></span>
			            <form id="listingscontact" class="formular" method="post">
	    					<fieldset class="col span_12">
	    						<select id="ctsubject" name="ctsubject">
	    							<option><?php esc_html_e('Tell me more about a property', 'contempo'); ?></option>
	    							<option><?php esc_html_e('Request a showing', 'contempo'); ?></option>
	    							<option><?php esc_html_e('General Questions', 'contempo'); ?></option>
	    						</select>
	    							<div class="clear"></div>
	    						<input type="text" name="name" id="name" class="validate[required] text-input" placeholder="<?php esc_html_e('Name', 'contempo'); ?>" />

	    						<input type="text" name="email" id="email" class="validate[required,custom[email]] text-input" placeholder="<?php esc_html_e('Email', 'contempo'); ?>" />

	    						<input type="text" name="ctphone" id="ctphone" class="text-input" placeholder="<?php esc_html_e('Phone', 'contempo'); ?>" />

	    						<textarea class="validate[required,length[2,1000]] text-input" name="message" id="message" rows="6" cols="10"></textarea>

	    						<input type="hidden" id="ctyouremail" name="ctyouremail" value="<?php echo esc_attr($brokerage_email) ?>" />
	    						<input type="hidden" id="ctproperty" name="ctproperty" value="<?php the_title(); ?>, <?php city(); ?>, <?php state(); ?> <?php zipcode(); ?>" />
	    						<input type="hidden" id="ctpermalink" name="ctpermalink" value="<?php the_permalink(); ?>" />

	    						<input type="submit" name="Submit" value="<?php esc_html_e('Submit', 'contempo'); ?>" id="submit" class="btn" />  
	    					</fieldset>
	    						<div class="clear"></div>
	    				</form>
			        </div>
			    </div>
			</div>
	        <!-- //Brokerage Contact Modal -->
	    <?php } ?>

		<div class="col span_12 first">

			<!-- Brokerage -->
			<div <?php if(empty($ct_brokerage_street_address)) { echo 'id="brokerage-hide-header"'; } ?> class="brokerage brokerage-wrap marT20 marB40">

				<?php if(has_post_thumbnail()) {
					$feat_image = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );

					echo '<figure class="col span_3 first">';
						echo '<div class="brokerage-logo-wrapper">';
					        echo '<img class="brokerage-img" src="' . $feat_image . '" />';
					    echo '</div>';
				    echo '</figure>';
				} ?>

	            <div class="brokerage-info <?php if(has_post_thumbnail()) { echo 'col span_9'; } ?>">
 
	                <?php if(!empty($ct_brokerage_street_address)) { ?>
		                <h3><?php the_title(); ?></h3>
		                <h5 class="muted brokerage-address"><?php ct_brokerage_address($post->ID); ?></h5>
	                <?php } else { ?>
	                	<h3 class="marB30"><?php the_title(); ?></h3>
	                <?php } ?>

	                <?php if(get_the_content()) { ?>
		                <div class="brokerage-bio col span_10 first marB30">
		                	<div class="brokerage-content"><?php the_content(); ?></div>
		                </div>
	               	<?php } ?>

	               	<?php if(!empty($ct_brokerage_phone) || !empty($ct_brokerage_fax)) { ?>
		                <ul class="brokerage-details col span_4 first">
			                <?php if($ct_brokerage_phone) { ?><li class="row"><span class="muted left"><?php ct_phone_svg(); ?></span> <span class="right"><a href="tel:<?php echo esc_html($ct_brokerage_phone); ?>"><?php echo esc_html($ct_brokerage_phone); ?></a></span></li><?php } ?>
			                <?php if($ct_brokerage_fax) { ?><li class="row"><span class="muted left"><?php ct_printer_svg(); ?></span> <span class="right"><a href="tel:<?php echo esc_html($ct_brokerage_fax); ?>"><?php echo esc_html($ct_brokerage_fax); ?></a></span></li><?php } ?>
			            </ul>
			        <?php } ?> 
			        <?php if(!empty($ct_brokerage_email) || !empty($ct_brokerage_url)) { ?>
			            <ul class="brokerage-details col span_4">
			                <?php if($ct_brokerage_email) { ?><li class="row"><span class="muted left"><?php ct_envelope_svg(); ?></span> <span class="right"><a class="brokerage-contact" href="#"><?php esc_html_e('Email', 'contempo'); ?></a></span></li><?php } ?>
			                <?php if($ct_brokerage_url) {
	                            $ct_brokerage_url = trim($ct_brokerage_url, '/');
	                            // If scheme not included, prepend it
	                            if(!preg_match('#^http(s)?://#', $ct_brokerage_url)) {
	                                $ct_brokerage_url = 'http://' . $ct_brokerage_url;
	                            }
	                            $ct_urlParts = parse_url($ct_brokerage_url);
	                            // remove www
	                            $ct_domain = preg_replace('/^www\./', '', $ct_urlParts['host']);
	                        ?>
	                        	<li class="row"><span class="muted left"><?php ct_globe_svg(); ?></span> <span class="right"><a href="<?php echo esc_html($ct_brokerage_url); ?>"><?php echo esc_html($ct_domain); ?></a></span></li>
	                    	<?php } ?>
		            	</ul>
		            <?php } ?>

		            <?php if(!empty($ct_brokerage_twitter) || !empty($ct_brokerage_facebook) || !empty($ct_brokerage_linkedin) || !empty($ct_brokerage_gplus)) { ?>
			            <ul class="social marT20 marL0 col span_12 first">
		                    <?php if($ct_brokerage_twitter) { ?><li class="twitter"><a href="<?php echo esc_url($ct_brokerage_twitter); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li><?php } ?>
		                    <?php if($ct_brokerage_facebook) { ?><li class="facebook"><a href="<?php echo esc_url($ct_brokerage_facebook); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li><?php } ?>
		                    <?php if($ct_brokerage_linkedin) { ?><li class="facebook"><a href="<?php echo esc_url($ct_brokerage_linkedin); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li><?php } ?>
		                    <?php if($ct_brokerage_gplus) { ?><li class="google"><a href="<?php echo esc_url($ct_brokerage_gplus); ?>" target="_blank"><i class="fa fa-google-plus"></i></a></li><?php } ?>
		                </ul>
	                <?php } ?>
	            </div>
	        </div>
	        <!-- //Brokerage -->

	        <?php endwhile; endif; wp_reset_postdata(); ?>
            
		        <div class="clear"></div>

	        <?php do_action('before_brokerage_listings'); ?>

	        <?php if(class_exists('ctIdxPro')) { ?>

	        	<div class="col span_12 first marB60">
		        	<?php
						$ct_agents = array();
		                $ct_agents = get_post_meta($post->ID, "_ct_agents", true);
		                $ct_brokage_ID = $post->ID;

		                $args = array(
		                	'post_type'	=> 'listings',
							'posts_per_page' => -1,
		                	'meta_query' => array(
							    array(
							        'key' => 'source',
							        'value' => 'idx-api',
							    	'type' => 'char',
									'compare' => '='
							    ),
								array(
									'key' => '_ct_brokerage',
									'value' => $ct_brokage_ID,
									'type' => 'NUMERIC',
									'compare' => 'LIKE'
								),
							),
						);
		                
						$wp_query = new wp_query($args);

						get_template_part( 'layouts/grid');

		            ?>
	        	</div>

	        <?php } else { ?>

	        	<ul class="tabs">
	                <li class="brokerage-listings"><a href="#tab-listings"><?php _e('Listings', 'contempo'); ?></a></li>
	                <?php if(!class_exists('ctIdxPro')) { ?>
		                <li class="brokerage-agents"><a href="#tab-agents"><?php _e('Agents', 'contempo'); ?></a></li>
		                <li class="brokerage-map"><a href="#tab-map"><?php _e('Map', 'contempo'); ?></a></li>
		                <?php if($ct_brokerage_reviews == 'yes') { ?>
			                <li class="brokerage-reviews"><a href="#tab-reviews"><?php _e('Reviews', 'contempo'); ?></a></li>
		                <?php } ?>
	                <?php } ?>
	            </ul>
	            
	              <div class="clear"></div>

	            <div class="inside">

					<!-- Listings -->
					<div id="tab-listings">
						<?php
							$ct_agents = array();
			                $ct_agents = get_post_meta($post->ID, "_ct_agents", true);
			                $ct_brokage_ID = $post->ID;

			                $current_page = get_query_var('paged') ? (int) get_query_var('paged') : 1;

			                if(!empty($ct_agents)) {
				                sort($ct_agents);
				                $args = array(
				                    'post_type'	=> 'listings',
									'posts_per_page' => $ct_agents_listings_per_page,
									'paged' => $current_page,
				                    'author__in' => $ct_agents,
				                    'meta_query' => array(
										array(
											'key' => '_ct_brokerage',
											'value' => $ct_brokage_ID,
											'type' => 'NUMERIC',
											'compare' => 'LIKE'
										),
									),
				                );
				            } else {
				            	$args = array(
				                    // No agents, no results
				                );
				            }
			                
							$wp_query = new wp_query($args);

							get_template_part( 'layouts/grid');

			            ?>
		            </div>
		            <!-- //Listings -->

		            <!-- Agents -->
		            <div id="tab-agents">
			            <?php

			            if($ct_options['ct_agents_ordering'] == 'yes') {
			                $args = array(
			                    'orderby'   => 'meta_value_num',
			                    'meta_key'  => 'agentorder',
			                    'order'     => 'ASC',
			                    'include'	=> $ct_agents
			                );
			            } else {
				            $args = array(
								'order'		=> 'DESC',
								'orderby'	=> 'display_name',
								'include'	=> $ct_agents
							);
				        }

					    $wp_user_query = new WP_User_Query($args);

					    $agents = $wp_user_query->get_results();

					    if($agents) { ?>

					    	<form id="agent-live-search" action="" method="post">
							    <fieldset>
							        <input type="text" class="text-input" id="agent-filter" value="" placeholder="<?php _e('Type an agents name or title here to filter the list.', 'contempo'); ?>" />
							    </fieldset>
							</form>

							<script>
								jQuery(document).ready(function($){
								    $("#agent-filter").keyup(function(){

								        var filter = $(this).val(), count = 0;

								        $(".agents-list li").each(function(){
								            if ($(this).text().search(new RegExp(filter, "i")) < 0) {
								                $(this).fadeOut();
								            } else {
								                $(this).show();
								                count++;
								            }
								        });
								        var numberItems = count;
								    });
								});
							</script>

					    	<?php 
					    	echo '<ul class="agents-list">';
						    foreach ($agents as $agent) {
						        
						        $curauth = get_userdata($agent->ID);
			                    $author_id = get_the_author_meta('ID');
			                    $user_link = get_author_posts_url($curauth->ID);
			                    $email = $curauth->user_email;

						        if($curauth->isagent == 'yes') {

							        if($curauth->user_email) { ?>

			                            <script>    
			                                jQuery(document).ready(function() {
			                                    jQuery(".contact-form-<?php echo esc_html($curauth->last_name); ?>").validationEngine({
			                                        ajaxSubmit: true,
			                                        ajaxSubmitFile: "<?php echo get_template_directory_uri(); ?>/includes/ajax-submit-agent.php",
			                                        ajaxSubmitMessage: "<?php $contact_success = str_replace(array("\r\n", "\r", "\n"), " ", $ct_options['ct_contact_success']); echo esc_html($contact_success); ?>",
			                                        success :  false,
			                                        failure : function() {}
			                                    });
			                                });
			                            </script>

			                            <!-- Agent Contact Modal -->
			                            <div id="overlay" class="contact-modal-<?php echo esc_html($curauth->ID); ?> agent-modal">
			                                <div id="modal">
			                                    <div id="modal-inner">
			                                        <a href="#" class="close"><i class="fa fa-close"></i></a>
			                                        <form id="listingscontact" class="contact-form-<?php echo esc_html($curauth->last_name); ?> formular" method="post">
			                                            <fieldset class="col span_12">
			                                                <select id="ctsubject" name="ctsubject">
			                                                    <option><?php esc_html_e('Tell me more about a property', 'contempo'); ?></option>
			                                                    <option><?php esc_html_e('Request a showing', 'contempo'); ?></option>
			                                                    <option><?php esc_html_e('General Questions', 'contempo'); ?></option>
			                                                </select>
			                                                    <div class="clear"></div>
			                                                <input type="text" name="name" id="name" class="validate[required] text-input" placeholder="<?php esc_html_e('Name', 'contempo'); ?>" />

			                                                <input type="text" name="email" id="email" class="validate[required,custom[email]] text-input" placeholder="<?php esc_html_e('Email', 'contempo'); ?>" />

			                                                <input type="text" name="ctphone" id="ctphone" class="text-input" placeholder="<?php esc_html_e('Phone', 'contempo'); ?>" />

			                                                <textarea class="validate[required,length[2,1000]] text-input" name="message" id="message" rows="6" cols="10"></textarea>

			                                                <input type="hidden" id="ctyouremail" name="ctyouremail" value="<?php echo esc_html($email); ?>" />
			                                                <input type="hidden" id="ctproperty" name="ctproperty" value="<?php the_title(); ?>, <?php city(); ?>, <?php state(); ?> <?php zipcode(); ?>" />
			                                                <input type="hidden" id="ctpermalink" name="ctpermalink" value="<?php the_permalink(); ?>" />

			                                                <input type="submit" name="Submit" value="<?php esc_html_e('Submit', 'contempo'); ?>" id="submit" class="btn" />  
			                                            </fieldset>
			                                                <div class="clear"></div>
			                                        </form>
			                                    </div>
			                                </div>
			                            </div>
			                            <!-- //Agent Contact Modal -->
			                        <?php } ?>

			                        <!-- Agent -->
			                        <li class="agent <?php echo esc_html($ct_agent_layout); ?> <?php if($ct_agent_layout == 'agent-grid') { echo 'col span_3'; } ?>">
			                                <figure class="col <?php if($ct_agent_layout == 'agent-grid') { echo 'span_12'; } else { echo 'span_3'; } ?> first">
			                                    <a href="<?php echo get_author_posts_url($curauth->ID); ?>" title="<?php echo esc_html($curauth->display_name); ?>">
				                                    <?php if($curauth->ct_profile_url) { ?>
				                                        <img class="author-img" src="<?php echo esc_html($curauth->ct_profile_url); ?>" />
				                                    <?php } else { ?>
				                                    	<img class="author-img" src="<?php echo get_template_directory_uri() . '/images/user-default.png'; ?>" />
			                                    	<?php } ?>
			                                    </a>
			                                </figure>
			                            <div class="agent-info col <?php if($ct_agent_layout == 'agent-grid') { echo 'span_12'; } else { echo 'span_9'; } ?>">
			                                <?php if($ct_agent_layout == 'agent-grid') { echo '<h4>'; } else { echo '<h3>'; } ?><a href="<?php echo esc_url(home_url()); ?>/?author=<?php echo esc_html($curauth->ID); ?>" title="<?php echo esc_html($curauth->display_name); ?>"><?php echo esc_html($curauth->display_name); ?></a><?php if($ct_agent_layout == 'agent-grid') { echo '</h4>'; } else { echo '</h3>'; } ?>
			                                <?php if ($curauth->title) { ?><h5 class="muted position"><?php echo esc_html($curauth->title); ?></h5><?php } ?>

			                                <?php if($ct_agent_layout != 'agent-grid') { ?>
			                                <div class="agent-bio col span_8 first">
			                                    <p><?php if($curauth->tagline) { ?><strong class="tagline"><?php echo esc_html($curauth->tagline); ?></strong> <?php } ?><?php $bio = $curauth->description; echo nl2br($bio); ?></p>
			                                    <ul class="social marT20 marL0">
			                                        <?php if ($curauth->twitterhandle) { ?><li class="twitter"><a href="https://twitter.com/#!/<?php echo esc_html($curauth->twitterhandle); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li><?php } ?>
			                                        <?php if ($curauth->facebookurl) { ?><li class="facebook"><a href="<?php echo esc_html($curauth->facebookurl); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li><?php } ?>
			                                        <?php if ($curauth->linkedinurl) { ?><li class="linkedin"><a href="<?php echo esc_html($curauth->linkedinurl); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li><?php } ?>
			                                    </ul>
			                                </div>
			                                <?php } ?>

			                                <script>
			                                jQuery(document).ready(function() {
			                                    jQuery(".agent-contact-<?php echo esc_html($curauth->ID); ?>").click(function() {
			                                        jQuery("#overlay.contact-modal-<?php echo esc_html($curauth->ID); ?>").addClass('open');
			                                    });

			                                    jQuery(".close").click(function() {
			                                        jQuery("#overlay.contact-modal-<?php echo esc_html($curauth->ID); ?>").removeClass('open');
			                                        jQuery(".formError").hide();
			                                    });
			                                });
			                                </script>

			                                <ul class="col <?php if($ct_agent_layout == 'agent-grid') { echo 'span_12'; } else { echo 'span_4'; } ?>">
			                                    <?php if($curauth->mobile) { ?><li class="row"><span class="muted left"><i class="fa fa-phone"></i></span> <span class="right"><?php echo esc_html($curauth->mobile); ?></span></span></li><?php } ?>
			                                    <?php if($curauth->office) { ?><li class="row"><span class="muted left"><i class="fa fa-building"></i></span> <span class="right"><?php echo esc_html($curauth->office); ?></span></li><?php } ?>
			                                    <?php if($curauth->fax) { ?><li class="row"><span class="muted left"><i class="fa fa-print"></i></span> <span class="right"><?php echo esc_html($curauth->fax); ?></span></li><?php } ?>
			                                   <?php if($curauth->user_email) { $email = $curauth->user_email; ?><li class="row"><span class="muted left"><i class="fa fa-envelope"></i></span> <span class="right"><a class="agent-contact-<?php echo esc_html($curauth->ID); ?>" href="#"><?php esc_html_e('Email', 'contempo'); ?></a></span></li><?php } ?>
			                                    <?php if($curauth->brokername) { ?><p class="marB3"><strong><?php echo esc_html($curauth->brokername); ?></strong></p><?php } ?>
			                                    <?php if($curauth->brokernum) { ?><p class="marB3"><?php echo esc_html($curauth->brokernum); ?></p><?php } ?>
			                                </ul>
			                                    <div class="clear"></div>

			                                <?php if($ct_agent_layout == 'agent-grid') { ?>
			                                <div class="agent-bio col span_12 first">
			                                    <ul class="social marT20 marL0">
			                                        <?php if ($curauth->twitterhandle) { ?><li class="twitter"><a href="https://twitter.com/#!/<?php echo esc_html($curauth->twitterhandle); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li><?php } ?>
			                                        <?php if ($curauth->facebookurl) { ?><li class="facebook"><a href="<?php echo esc_html($curauth->facebookurl); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li><?php } ?>
			                                        <?php if ($curauth->linkedinurl) { ?><li class="linkedin"><a href="<?php echo esc_html($curauth->linkedinurl); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li><?php } ?>
			                                    </ul>
			                                </div>
			                                <?php } ?>

			                                <?php if($ct_agent_layout != 'agent-grid') { ?>
			                                <div class="view-listings">
			                                    <a class="btn" href="<?php echo get_author_posts_url($curauth->ID); ?>"><?php esc_html_e('View Listings', 'contempo'); ?></a>
			                                </div>
			                                <?php } ?>
			                            </div>
			                                <div class="clear"></div>
			                        </li>
			                        <!-- //Agent -->
							    <?php }
						    }
						    echo '</ul>';
						} else { ?>
							<p class="nomatches"><strong><?php esc_html_e( 'This brokerage currently has no active agents.', 'contempo' ); ?></strong>.<br /><?php esc_html_e( 'Check back soon.', 'contempo' ); ?></p>
						<?php } ?>
		            </div>
		            <!-- //Agents -->

		            <!-- Map -->
		            <div id="tab-map">
		            	<?php 
		            	$ct_brokerage_address = $ct_brokerage_street_address . ', ' . $ct_brokerage_address_two . ', ' . $ct_brokerage_city . ', ' . $ct_brokerage_state . ', ' . $ct_brokerage_zip;
		            	if($ct_brokerage_country != '') {
		            		$ct_brokerage_address .= ', ' . esc_html($ct_brokerage_country);
		            	} ?>

			            <?php ct_brokerage_single_map($ct_brokerage_address); ?>
		            </div>

		            <?php if($ct_brokerage_reviews == 'yes') { ?>
		            <!-- Reviews -->
					<div id="tab-reviews">
						<?php
			                echo '<div id="listing-reviews">';
	                        echo '<h4 class="border-bottom marB18">';
	                            comments_number( __('No Reviews', 'contempo'), __('1 Review', 'contempo'), __( '% Reviews', 'contempo') );
	                        echo '</h4>';

	                        get_template_part('comments');
	                    echo '</div>';
			            ?>
		            </div>
		            <!-- //Reviews -->
	            <?php } ?>

	        <?php } ?>

	        </div>
	        	
	        	<div class="clear"></div>

            <?php do_action('after_brokerage_listings'); ?>

		</div>
            
            <div class="clear"></div>
        
</div>

<?php get_footer(); ?>