
jQuery(document).ready(function($) {

         
    jQuery("#overview-download-yesterday-next").on( "click" , function( e ){

        e.preventDefault();

        if (e.target.disabled) { // or this.disabled
            return;
        }

        getData ( download_yesterday_ajax_object.ajax_url, download_yesterday_ajax_object.userId, download_yesterday_ajax_object.userRole, download_yesterday_ajax_object.startDate, download_yesterday_ajax_object.endDate, download_yesterday_ajax_object.linkStartDate, download_yesterday_ajax_object.linkEndDate, ++download_yesterday_ajax_object.paged, download_yesterday_ajax_object.totalCount, download_yesterday_ajax_object.totalRowCount );
    });

    jQuery("#overview-download-yesterday-previous:enabled").on( "click" , function( e ){

        e.preventDefault();

        if (e.target.disabled || download_today_ajax_object.paged == 1 ) { // or this.disabled
            return;
        }

        getData ( download_yesterday_ajax_object.ajax_url, download_yesterday_ajax_object.userId, download_yesterday_ajax_object.userRole, download_yesterday_ajax_object.startDate, download_yesterday_ajax_object.endDate, download_yesterday_ajax_object.linkStartDate, download_yesterday_ajax_object.linkEndDate, --download_yesterday_ajax_object.paged, download_yesterday_ajax_object.totalCount, download_yesterday_ajax_object.totalRowCount );
    });

    function getData( ajax_url, userId, userRole, startDate, endDate, linkStartDate, linkEndDate, paged, totalCount, totalRowCount )
    {

        jQuery('body').css('cursor', 'wait');
        jQuery(this).css('cursor', 'wait');
    
        perPage = 10;

        var data = {
            'action':       'ct_getDownloadAjax',
            'userId':       userId,
            'userRole':     userRole,             
            'startDate':    startDate,
            'endDate':      endDate,
            'paged':        paged,
            'totalCount':   totalCount,
            'totalRowCount':totalRowCount
        };

        jQuery.get( ajax_url, data, function(response) {

            if( response != "" ) {
                
                output = "";

                var arr = JSON.parse( response );

                for( x = 0; x < arr["item"].length; x++) {
                    output = output + "<tr><td><a href=\"?listing-id=" +  arr["item"][x]["listingId"] + "&download-name=" +  arr["item"][x]["downloadName"] + "&startDate=" + linkStartDate + "&endDate=" + linkEndDate + "\">" + arr["item"][x]["downloadName"] + " [" + arr["item"][x]["title"] + "]</a></td><td>" + arr["item"][x]["count"] + "</td></tr>";
                }     

                if ( paged > 1 ) {
                    jQuery("#overview-download-yesterday-previous").removeClass( "disabled" );
                    jQuery("#overview-download-yesterday-previous").prop("disabled", false);
                } else {
                    jQuery("#overview-download-yesterday-previous").addClass( "disabled" );
                    jQuery("#overview-download-yesterday-previous").prop("disabled", true);
                }

                if ( ( paged * 10 ) >= totalRowCount ) {
                    jQuery("#overview-download-yesterday-next").addClass( "disabled" );
                    jQuery("#overview-download-yesterday-next").prop("disabled", true);
                } else {
                    jQuery("#overview-download-yesterday-next").removeClass( "disabled" );
                    jQuery("#overview-download-yesterday-next").prop("disabled", false);
                }



                jQuery("#overview-download-yesterday-table").html( output ); 
                
                jQuery('body').css('cursor', 'default');
                jQuery(this).css('cursor', 'default');
            }
    
        });
    }

});