<?php
/*
* Template Name: Blog 3Col
*/

$postID = get_the_ID();
$page_title_block = get_post_meta( $postID , 'page_title' , true );

if (has_post_thumbnail( $postID ) ) {
    $image = wp_get_attachment_image_src( get_post_thumbnail_id( $postID ), 'full' );
} else {
    $image = "";
}

get_header(); ?>

    <div class="autoroyal-front-dashboard">

        <div id="primary" class="content-area">

            <main id="main" class="site-main">

                <?php 

                    if($page_title_block != 2) { 

                ?>

                <div class="autoroyal-page-title" <?php if(!empty($image)) { ?>style="background-image: url('<?php echo esc_url($image[0]); ?>')"<?php } ?>>

                    <div class="container">

                        <h2><?php the_title(); ?></h2>
                        
                    </div>

                </div>

                <?php } ?>

                <div class="container">

                    <div class="row">

                        <div class="autoroyal-blog-isotope-container col-md-12 fantasy-themes-content-width animated-car-blocks">

                            <div id="isotope-container" class="row">

                                <?php

                                    $args = wp_parse_args($wp->matched_query);
                                    if ( !empty ( $args['paged'] ) && 0 == $paged ) {
                                        $wp_query->set('paged', $args['paged']);
                                        $paged = $args['paged'];
                                    }

                                    $temp = $wp_query;
                                    $wp_query = null;
                                    $wp_query = new WP_Query();
                                    $wp_query->query('post_type=post&posts_per_page=9&paged='.$paged);
                                    $current_post = 0;

                                ?>

                                <?php
                                if ( have_posts() ) :

                                    /* Start the Loop */
                                    while ( have_posts() ) : the_post();

                                        ?>

                                        <!-- post -->
                                        <div id="post-<?php the_ID(); ?>" <?php post_class('col-lg-4 col-md-6 autoroyal-animated-blk autoroyal-vehicle-grid-block autoroyal-blog-item'); ?>>

                                            <div class="autoroyal-vehicle-block autoroyal-block-style-1 autoroyal-blog-post">

                                                <?php 

                                                    if(has_post_thumbnail()) {

                                                        $image_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), false, '' ); 
                                                        $td_title_bg_img = esc_url($image_src[0]);
                                                        $foto_large = autoroyal_get_resized_image( $td_title_bg_img, 'autoroyal-blog-post-image' );

                                                    ?>

                                                    <div class="autoroyal-vehicle-block-image-wrapper">

                                                        <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($foto_large); ?>" alt="<?php the_title_attribute(); ?>"></a>

                                                    </div>

                                                    <?php

                                                    } 

                                                ?>

                                                <div class="autoroyal-vehicle-block-meta">

                                                    <div class="entry-title cat-links">
                                                        <span class="ar-badge"><?php the_category( '</span> <span class="ar-badge">' ); ?></span>
                                                    </div>

                                                    <a class="heading" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

                                                    <div class="autoroyal-rent-subtitle">

                                                        <span><?php esc_html_e( 'by', 'autoroyal' ); ?> <strong><?php the_author(); ?></strong></span> <span><?php esc_html_e( 'on', 'autoroyal' ); ?> <strong><a href="<?php the_permalink(); ?>"><?php the_time(get_option('date_format')); ?></a></strong></span>                                
                                                            
                                                    </div>

                                                </div>

                                            </div>

                                        </div>
                                        <!-- /post -->

                                    <?php

                                    endwhile;

                                else :

                                    get_template_part( 'template-parts/content', 'none' );

                                endif; ?>

                            </div>

                            <div class="row"><div class="col-md-12"><?php autoroyal_pagination( $wp_query->max_num_pages); ?></div></div>

                        </div>

                    </div>

                </div>

            </main><!-- #main -->

        </div><!-- #primary -->

    </div>

<?php
get_footer();
