<?php 

/*******
*
* 404 Error Page
*
*******/

get_header(); ?>

			<div class="autoroyal-page-wrapper">

				<div class="autoroyal-page-content-fullwidth error-404-page height-100">

					<div class="content autoroyal-vertical-center">

						<h2><?php esc_html_e('Error','autoroyal'); ?> <span class="highlight"><?php esc_html_e( '404', 'autoroyal' ) ?></span></h2>
						<h2><?php esc_html_e('Page Not Found','autoroyal'); ?></h2>
						
						<div class="post-content">
						
							<p><?php esc_html_e("It seems like you have tried to open a page that doesn't exist. It could have been deleted, moved, or it never existed at all.", 'autoroyal'); ?></p>

							<form class="search-form search-form-404" method="get" id="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
								<div class="input-with-icon">
									<i class="fa fa-search" aria-hidden="true"></i>
									<input type="text" id="big-search-box" class="search-404" name="s" placeholder="<?php esc_attr_e( 'Type here', 'autoroyal' ) ?>">
								</div>
							</form>

							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="autoroyal-button button-icon-right autoroyal-button-align-center" target="_blank"><?php esc_html_e('Back Home', 'autoroyal' ); ?> <i class="fa fa-home"></i></a>
						
						</div>

					</div>

				</div>

			</div>

<?php get_footer(); ?>