<?php

class WP_Customize_Range_Control extends WP_Customize_Control {
    public $type = 'custom_range';
    public function enqueue()
    {
        wp_enqueue_script(
            'cs-range-control',
            get_template_directory_uri().'/js/range-control.js',
            array('jquery'),
            false,
            true
        );
    }
    public function render_content()
    {
        ?>
        <label>
            <?php if ( ! empty( $this->label )) : ?>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
            <?php endif; ?>
            <div class="cs-range-value"><?php echo esc_attr($this->value()); ?></div>
            <input data-input-type="range" type="range" <?php $this->input_attrs(); ?> value="<?php echo esc_attr($this->value()); ?>" <?php $this->link(); ?> />
            <?php if ( ! empty( $this->description )) : ?>
                <span class="description customize-control-description"><?php echo wp_kses($this->description, true); ?></span>
            <?php endif; ?>
        </label>
        <?php
    }
}

/////////////////// Section ///////////////////
$wp_customize->add_section( 'autoroyal_menu_options',
array(
    'title' => esc_html__( 'Menu', 'autoroyal' ), //Visible title of section
    'priority' => 35, //Determines what order this appears in
    'capability' => 'edit_theme_options', //Capability needed to tweak
    'description' => esc_html__('Allows you to customize autoRoyal Theme menu.', 'autoroyal'), //Descriptive tooltip
    'panel'  => 'autoroyal_header_options',
    )
);
////////////////////////////////////////////////

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'menu_position_option',
array(
    'default' => $autoroyal_defaults['menu_position_option'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'menu_position_option', 
    array(
        'label'    => esc_html__( 'Menu Style', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Fixed' => 'Fixed',
            'Floating'  => 'Floating',
            'left-menu'  => 'Left Side Menu',
            'fullscreen'  => 'Fullscreen',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'menu_search_button',
array(
    'default' => $autoroyal_defaults['menu_search_button'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'menu_search_button', 
    array(
        'label'    => esc_html__( 'Search Button in Menu', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Show' => 'Show',
            'Hide'  => 'Hide',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'menu_width_option',
array(
    'default' => $autoroyal_defaults['menu_width_option'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'menu_width_option', 
    array(
        'label'    => esc_html__( 'Menu Container', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Boxed' => 'Boxed',
            'Full-Width'  => 'Full-Width',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'top_menu_option',
array(
    'default' => $autoroyal_defaults['top_menu_option'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'top_menu_option', 
    array(
        'label'    => esc_html__( 'Top Menu', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Show'  => 'Show',
            'Hide' => 'Hide',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'top_social_option',
array(
    'default' => $autoroyal_defaults['top_social_option'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'top_social_option', 
    array(
        'label'    => esc_html__( 'Top Social Align Options', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Left'  => 'Left',
            'Right' => 'Right',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'logo_option',
array(
    'default' => $autoroyal_defaults['logo_option'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'logo_option', 
    array(
        'label'    => esc_html__( 'Logo Align Options', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Left'  => 'Left',
            'Right' => 'Right',
            'Center' => 'Center',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'menu_background_type',
array(
    'default' => $autoroyal_defaults['menu_background_type'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'menu_background_type', 
    array(
        'label'    => esc_html__( 'Menu Background Type', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Dark'  => 'Dark',
            'Light' => 'Light',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" hover_color ">\
$wp_customize->add_setting( 'menu_bg_color',
array(
    'default' => $autoroyal_defaults['menu_bg_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'menu_bg_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Menu Background Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_menu_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'menu_bg_color', //Which setting to load and manipulate (serialized is okay)
        'priority' => 10, //Determines the order this control appears in for the specified section
        'description' => esc_html__('Pick menu background color (default: #2e2e2e).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>menu_bg_color

// <editor-fold defaultstate="collapsed" desc=" footer_copyright_text ">
$wp_customize->add_setting( 'menu_bg_opacity',
array(
    'default' => $autoroyal_defaults['menu_bg_opacity'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    new WP_Customize_Range_Control(
        $wp_customize,
        'menu_bg_opacity',
        array(
            'settings' => 'menu_bg_opacity',
            'label'    => esc_html__('Menu Background Opacity', 'autoroyal'),
            'section'  => 'autoroyal_menu_options',
            'type'     => 'range',
            'input_attrs' => array(
                'min'   => 0,
                'max'   => 100,
                'step'  => 1,
                'class' => 'test-class test',
                'style' => 'color: #0a0',
            ),
            'description' => esc_html__('Menu background opacity', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'sticky_menu_background_type',
array(
    'default' => $autoroyal_defaults['sticky_menu_background_type'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    'sticky_menu_background_type', 
    array(
        'label'    => esc_html__( 'Sticky Menu Background Type', 'autoroyal' ),
        'section'  => 'autoroyal_menu_options',
        'type'     => 'select',
        'choices'  => array(
            'Dark'  => 'Dark',
            'Light' => 'Light',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" hover_color ">\
$wp_customize->add_setting( 'sticky_menu_bg_color',
array(
    'default' => $autoroyal_defaults['sticky_menu_bg_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'sticky_menu_bg_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Sticky Menu Background Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_menu_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'sticky_menu_bg_color', //Which setting to load and manipulate (serialized is okay)
        'priority' => 10, //Determines the order this control appears in for the specified section
        'description' => esc_html__('Pick menu background color (default: #2e2e2e).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>sticky_menu_bg_color

// <editor-fold defaultstate="collapsed" desc=" footer_copyright_text ">
$wp_customize->add_setting( 'sticky_menu_bg_opacity',
array(
    'default' => $autoroyal_defaults['sticky_menu_bg_opacity'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(
    new WP_Customize_Range_Control(
        $wp_customize,
        'sticky_menu_bg_opacity',
        array(
            'settings' => 'sticky_menu_bg_opacity',
            'label'    => esc_html__('Sticky Menu Background Opacity', 'autoroyal'),
            'section'  => 'autoroyal_menu_options',
            'type'     => 'range',
            'input_attrs' => array(
                'min'   => 0,
                'max'   => 100,
                'step'  => 1,
                'class' => 'test-class test',
                'style' => 'color: #0a0',
            ),
            'description' => esc_html__('Menu background opacity', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>