<?php
/*
* Template Name: Front-End Dashboard
*/

$postID = get_the_ID();

if (has_post_thumbnail( $postID ) ) {
    $image = wp_get_attachment_image_src( get_post_thumbnail_id( $postID ), 'full' );
} else {
    $image = "";
}

get_header(); ?>

    <div class="autoroyal-front-dashboard">

        <div id="primary" class="content-area">

            <main id="main" class="site-main dashboard-wrapper">

                <?php if ( ! is_user_logged_in() ) { ?>

                <div class="autoroyal-front-dashboard-content">

                    <h4><?php esc_html_e( 'You must', 'autoroyal' ) ?> <a class="open-login-popup" href="#"><?php esc_html_e( 'login', 'autoroyal' ) ?></a> <?php esc_html_e( 'to see this page', 'autoroyal' ) ?>.</h4>

                    <div class="autoroyal-login-page-icon">

                        <i class="fa fa-ban" aria-hidden="true"></i>

                    </div>

                </div>

                <?php } else { ?>

                <div id="autoroyal-front-dashboard-sidebar" class="sidebar autoroyal-front-dashboard-sidebar">

                    <!-- Sidebar -->
                    <section class="widget advance-search">

                        <h4 class="title search-heading"><?php esc_html_e( 'Dashboard', 'autoroyal' ) ?></h4>

                        <ul class="autoroyal-dashboard-menu">
                            <?php get_template_part( 'template-parts/my-account-menu' ); ?>
                        </ul>

                    </section>  

                </div>

                <div class="autoroyal-front-dashboard-content">

                    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                        <?php if ( get_the_content() ) : ?>

                            <?php the_content(); ?>

                        <?php endif; ?>

                    <?php endwhile; endif; ?>

                </div>

                <?php } ?>

            </main><!-- #main -->

        </div><!-- #primary -->

    </div>

<?php
get_footer();
