<?php
/*
* Template Name: Full width
*/

$postID = get_the_ID();
$page_title_block = get_post_meta( $postID , 'page_title' , true );

if (has_post_thumbnail( $postID ) ) {
    $image = wp_get_attachment_image_src( get_post_thumbnail_id( $postID ), 'full' );
} else {
    $image = "";
}

get_header(); ?>

    <div class="autoroyal-full-page">

        <div id="primary" class="content-area">

            <main id="main" class="site-main">

                <?php 

                    if($page_title_block != 2) { 

                ?>

                <div class="autoroyal-page-title" <?php if(!empty($image)) { ?>style="background-image: url('<?php echo esc_url($image[0]); ?>')"<?php } ?>>

                    <div class="container">

                        <h2><?php the_title(); ?></h2>
                        
                    </div>

                </div>

                <?php } ?>

                <div class="container">

                    <?php if ( $post && preg_match( '/vc_row/', $post->post_content ) ) { ?>

                        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                            <?php if ( get_the_content() ) : ?>
                
                                <?php the_content(); ?>

                            <?php endif; ?>

                        <?php endwhile; endif; ?>

                    <?php } else { ?>

                    <div class="row">

                        <div class="autoroyal-full-width-page col-md-12">

                            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                                <?php if ( get_the_content() ) : ?>

                                    <?php the_content(); ?>

                                <?php endif; ?>

                            <?php endwhile; endif; ?>

                        </div>

                    </div>

                    <?php } ?>

                </div>

            </main><!-- #main -->

        </div><!-- #primary -->

    </div>

<?php
get_footer();
