<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://fantasythemes.net
 * @since             1.0.2
 * @package           autoroyal
 *
 * @wordpress-plugin
 * Plugin Name:       autoroyal
 * Plugin URI:        http://fantasythemes.net
 * Description:       Vehicles shop or automotive marketplace plugin
 * Version:           1.0.2
 * Author:            FantasyThemes
 * Author URI:        http://fantasythemes.net
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       autoroyal
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-autoroyal-activator.php
 */
function activate_autoroyal() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-autoroyal-activator.php';
	autoroyal_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-autoroyal-deactivator.php
 */
function deactivate_autoroyal() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-autoroyal-deactivator.php';
	autoroyal_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_autoroyal' );
register_deactivation_hook( __FILE__, 'deactivate_autoroyal' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-autoroyal.php';

// Define constants
if (!defined('autoroyal_PLUGIN_DIR')) define( 'autoroyal_PLUGIN_DIR', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
if (!defined('autoroyal_IMPORT_PLUGIN_DIR')) define('autoroyal_IMPORT_PLUGIN_DIR', plugin_dir_path(__FILE__));
if (!defined('autoroyal_PLUGIN_URL')) define( 'autoroyal_PLUGIN_URL', untrailingslashit( plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) ) );
if (!defined('ROYALTICKETS_PLUGIN_BASENAME')) define('ROYALTICKETS_PLUGIN_BASENAME', dirname(plugin_basename(__FILE__)));

include_once( dirname( __FILE__ ) . '/importer/importer-setup.php' );
include_once( dirname( __FILE__ ) . '/importer/importer.php' );

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.2
 */
function run_autoroyal() {

	$plugin = new autoroyal();
	$plugin->run();

}
run_autoroyal();

/**
 * Remove "Design options", "Custom CSS" tabs and prompt message to activate Visual Composer.
 */
add_action( 'vc_before_init', 'vc_before_init_actions' );
 
function vc_before_init_actions() {
     
    // Setup VC to be part of a theme
    if( function_exists('vc_set_as_theme') ){ 
        vc_set_as_theme( true );    
    }

    $file = dirname(__FILE__) . '/autoroyal.php';
	$plugin_path = plugin_dir_path($file);

	// Link your VC elements's folder
    if( function_exists('vc_set_shortcodes_templates_dir') ){ 
     
        vc_set_shortcodes_templates_dir( $plugin_path . '/vc-elements' );
         
    }

    /*
	|--------------------------------------------------------------------------
	| autoroyal: Section Devider Yes/No
	|--------------------------------------------------------------------------
	*/
	$section_devider = array(
		// Example
        array(
			"param_name" => "section_devider",
			"heading" => esc_html__("Devider", 'autoroyal'),
			"description" => wp_kses_data( __("Select to hide/show autoroyal section devider.", 'autoroyal') ),
			"group" => esc_html__('aR: Devider', 'autoroyal'),
			"admin_label" => false,
			"value" => array( 
				esc_html__("No", "autoroyal") => "no",
				esc_html__("Yes", "autoroyal") => "yes",
			),
			"type" => "dropdown",
		), 
	);
	vc_add_params( 'vc_section', $section_devider );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Section Devider Position
	|--------------------------------------------------------------------------
	*/
	$section_devider_position = array(
		// Example
        array(
			"param_name" => "section_devider_position",
			"heading" => esc_html__("Devider Position", 'autoroyal'),
			"description" => wp_kses_data( __("Select devider position.", 'autoroyal') ),
			"group" => esc_html__('aR: Devider', 'autoroyal'),
			"admin_label" => false,
			"value" => array( 
				esc_html__("Top", "autoroyal") => "top",
				esc_html__("Bottom", "autoroyal") => "bottom",
			),
			'dependency' => array(
				'element' => 'section_devider',
				'value' => 'yes',
			),
			'std' => 'left',
			"type" => "dropdown",
		), 
	);
	vc_add_params( 'vc_section', $section_devider_position );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Color
	|--------------------------------------------------------------------------
	*/
    $section_devider_color = array(
         
        // Example
        array(
            'type' => 'colorpicker',
            'heading' => __( 'Devider color', 'autoroyal' ),
            'param_name' => 'section_devider_color',
            'value' => '',
            'description' => __( 'Select section devider color', 'autoroyal' ),
            'admin_label' => false,
            'dependency' => array(
				'element' => 'section_devider',
				'value' => 'yes',
			),
            'weight' => 0,
            'std' => '#F0F7FF',
            "group" => esc_html__('aR: Devider', 'autoroyal'),
        ),      
     
    );
    vc_add_params( 'vc_section', $section_devider_color );

    /*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Yes/No
	|--------------------------------------------------------------------------
	*/
	$section_bg = array(
		// Example
        array(
			"param_name" => "section_bg",
			"heading" => esc_html__("Section Background", 'autoroyal'),
			"description" => wp_kses_data( __("Select to hide/show autoroyal background alternative.", 'autoroyal') ),
			"group" => esc_html__('aR: Settings', 'autoroyal'),
			"admin_label" => false,
			"value" => array( 
				esc_html__("None", "autoroyal") => "none",
				esc_html__("Pattern", "autoroyal") => "pattern",
				esc_html__("Care makes animated pattern", "autoroyal") => "car_makes",
			),
			"type" => "dropdown",
		), 
	);
	vc_add_params( 'vc_section', $section_bg );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Orientation
	|--------------------------------------------------------------------------
	*/
	$section_bg_orientation = array(
		// Example
        array(
			"param_name" => "section_bg_orientation",
			"heading" => esc_html__("Alternative Background Orientation", 'autoroyal'),
			"description" => wp_kses_data( __("Select alternative background orientation.", 'autoroyal') ),
			"group" => esc_html__('aR: Settings', 'autoroyal'),
			"admin_label" => false,
			"value" => array( 
				esc_html__("Left", "autoroyal") => "left",
				esc_html__("Right", "autoroyal") => "right",
			),
			'dependency' => array(
				'element' => 'section_bg',
				'value' => 'pattern',
			),
			'std' => 'left',
			"type" => "dropdown",
		), 
	);
	vc_add_params( 'vc_section', $section_bg_orientation );


	/*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Orientation
	|--------------------------------------------------------------------------
	*/
	$section_pattern_offset = array(
		// Example
        array(
			"param_name" => "section_pattern_offset",
			"heading" => esc_html__("Alternative Background Pattern Offset", 'autoroyal'),
			"description" => wp_kses_data( __("Select alternative background pattern offset.", 'autoroyal') ),
			"group" => esc_html__('aR: Settings', 'autoroyal'),
			"admin_label" => false,
			"value" => array( 
				esc_html__("Top", "autoroyal") => "top",
				esc_html__("Bottom", "autoroyal") => "bottom",
			),
			'dependency' => array(
				'element' => 'section_bg',
				'value' => 'pattern',
			),
			'std' => 'bottom',
			"type" => "dropdown",
		), 
	);
	vc_add_params( 'vc_section', $section_pattern_offset );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Offset X
	|--------------------------------------------------------------------------
	*/
    $vc_section_bg_offset_x = array(
         
        // Example
        array(
            'type' => 'textfield',
            'heading' => __( 'Alternative background offset X', 'autoroyal' ),
            'param_name' => 'section_bg_offset_x',
            'value' => '',
            'description' => __( 'Add section alternative background offset x', 'autoroyal' ),
            'admin_label' => false,
            'dependency' => array(
				'element' => 'section_bg',
				'value' => 'pattern',
			),
            'weight' => 0,
            "group" => esc_html__('aR: Settings', 'autoroyal'),
        ),      
     
    );
    vc_add_params( 'vc_section', $vc_section_bg_offset_x );

    /*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Offset Y
	|--------------------------------------------------------------------------
	*/
    $vc_section_bg_offset_y = array(
         
        // Example
        array(
            'type' => 'textfield',
            'heading' => __( 'Alternative background offset Y', 'autoroyal' ),
            'param_name' => 'section_bg_offset_y',
            'value' => '',
            'description' => __( 'Add section alternative background offset y', 'autoroyal' ),
            'admin_label' => false,
            'dependency' => array(
				'element' => 'section_bg',
				'value' => 'pattern',
			),
            'weight' => 0,
            "group" => esc_html__('aR: Settings', 'autoroyal'),
        ),      
     
    );
    vc_add_params( 'vc_section', $vc_section_bg_offset_y );

    /*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Color
	|--------------------------------------------------------------------------
	*/
    $vc_section_bg_color = array(
         
        // Example
        array(
            'type' => 'colorpicker',
            'heading' => __( 'Alternative background color', 'autoroyal' ),
            'param_name' => 'section_bg_color',
            'value' => '',
            'description' => __( 'Select section alternative background color', 'autoroyal' ),
            'admin_label' => false,
            'dependency' => array(
				'element' => 'section_bg',
				'value' => 'pattern',
			),
            'weight' => 0,
            'std' => '#F0F7FF',
            "group" => esc_html__('aR: Settings', 'autoroyal'),
        ),      
     
    );
    vc_add_params( 'vc_section', $vc_section_bg_color );

    /*
	|--------------------------------------------------------------------------
	| autoroyal: Section Background Color
	|--------------------------------------------------------------------------
	*/
    $vc_section_bg_patterb_color = array(
         
        // Example
        array(
            'type' => 'colorpicker',
            'heading' => __( 'Alternative background pattern color', 'autoroyal' ),
            'param_name' => 'section_bg_pattern_color',
            'value' => '',
            'description' => __( 'Select section alternative background pattern color', 'autoroyal' ),
            'admin_label' => true,
            'dependency' => array(
				'element' => 'section_bg',
				'value' => 'pattern',
			),
            'weight' => 0,
            'std' => '#F0F7FF',
            "group" => esc_html__('aR: Settings', 'autoroyal'),
        ),      
     
    );
    vc_add_params( 'vc_section', $vc_section_bg_patterb_color );

	// Shortcodes
	/*
	|--------------------------------------------------------------------------
	| autoroyal: Reservation Form
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-reservation-form.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Homepage Search Block
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-homepage-search.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Homepage Search Rent Block
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-homepage-search-rent.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: CTA
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-cta.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Vehicles Map
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-vehicles-map.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Car Types
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-search-by-body-style.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Car Types - List
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-search-by-body-style-list.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Latest Vehicles
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-latest-vehicles.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Latest Vehicles Style 2
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-latest-vehicles-style-2.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Latest Vehicles Style 2
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-latest-vehicles-grid.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Latest Vehicles For Rent
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-latest-vehicles-rent.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Dealers
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-dealers.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Price Box
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-price-box.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: FAQ Container
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-faq-container.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: FAQ Item
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-faq-item.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Minimal Search
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-minimal-search.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Testimonials Container
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-testimonials-container.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Testimonials Item
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-testimonials-item.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Rent Slider Container
	|--------------------------------------------------------------------------
	*/
	//include_once( $plugin_path . '/shortcodes/td-shortcode-rent-slider-container.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Rent Slider Item
	|--------------------------------------------------------------------------
	*/
	//include_once( $plugin_path . '/shortcodes/td-shortcode-rent-slider-item.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Content Block
	|--------------------------------------------------------------------------
	*/
	//include_once( $plugin_path . '/shortcodes/td-shortcode-content-block.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Entry Title
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-entry-title.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Icon Box
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-icon-box.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Google Maps
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-gmap.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Search By Make
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-search-by-make.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Search by Price - List Container
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-by-price-container.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Search by Price - List Item
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-by-price-item.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Button
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-button.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Location
	|--------------------------------------------------------------------------
	*/
	//include_once( $plugin_path . '/shortcodes/td-shortcode-locations.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Location Carousel
	|--------------------------------------------------------------------------
	*/
	//include_once( $plugin_path . '/shortcodes/td-shortcode-locations-carousel.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Location Big
	|--------------------------------------------------------------------------
	*/
	//include_once( $plugin_path . '/shortcodes/td-shortcode-locations-big.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: FlipClock
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-flipclock.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Blog Posts
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-blog-posts.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Team
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-team.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Social
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-social.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Tabs Holder
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-tab-holder.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Tab
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-tab.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Tabs Style 2 Holder
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-tab-style-2-holder.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Tab Style 2
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-tab-style-2.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Image Slideshow
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-image-slideshow.php' );

	/*
	|--------------------------------------------------------------------------
	| autoroyal: Image Slideshow
	|--------------------------------------------------------------------------
	*/
	include_once( $plugin_path . '/shortcodes/td-shortcode-vehicle-banner.php' );

	/**
	 * Meta Boxes
	 */
	require_once( $plugin_path . '/meta-box/ft-meta-box.php' );
	

	// Disable Instructional/Help Pointers
    if( function_exists('vc_pointer_load') ){ 
        remove_action( 'admin_enqueue_scripts', 'vc_pointer_load' );        
    }
     
}

if( is_admin() ) {
 
    add_filter( 'script_loader_tag', 'tp_theme_filter_overrides' , 10, 4 );
 
}
 
function tp_theme_filter_overrides( $tag, $handle ) {
 
    return str_replace( 'defer', '', $tag );
 
}

add_action( 'show_user_profile', 'ft_show_extra_profile_fields' );
add_action( 'edit_user_profile', 'ft_show_extra_profile_fields' );

function ft_show_extra_profile_fields( $user ) {
	$dealer_address = get_the_author_meta( 'dealer_address', $user->ID );
	$dealer_address_latitude = get_the_author_meta( 'dealer_address_latitude', $user->ID );
	$dealer_address_longitude = get_the_author_meta( 'dealer_address_longitude', $user->ID );
	?>
	<h3><?php esc_html_e( 'Address', 'autoroyal' ); ?></h3>

	<table class="form-table">
		<tr>
			<th><label for="dealer_address"><?php esc_html_e( 'Address', 'autoroyal' ); ?></label></th>
			<td>
				<input id="dealer_address" name="dealer_address" value="<?php echo esc_attr( $dealer_address ); ?>" class="regular-text" />
			</td>
		</tr>
		<tr>
			<th><label for="dealer_address_latitude"><?php esc_html_e( 'Latitude', 'autoroyal' ); ?></label></th>
			<td>
				<input  id="dealer_address_latitude" name="dealer_address_latitude" value="<?php echo esc_attr( $dealer_address_latitude ); ?>" class="regular-text" />
			</td>
		</tr>
		<tr>
			<th><label for="dealer_address_longitude"><?php esc_html_e( 'Longitude', 'autoroyal' ); ?></label></th>
			<td>
				<input id="dealer_address_longitude" name="dealer_address_longitude" value="<?php echo esc_attr( $dealer_address_longitude ); ?>" class="regular-text" />
			</td>
		</tr>
	</table>
	<?php
}


add_action( 'personal_options_update', 'autoroyal_update_profile_fields' );
add_action( 'edit_user_profile_update', 'autoroyal_update_profile_fields' );

function autoroyal_update_profile_fields( $user_id ) {
	if ( ! current_user_can( 'edit_user', $user_id ) ) {
		return false;
	}

	update_user_meta( $user_id, 'dealer_address', $_POST['dealer_address'] );
	update_user_meta( $user_id, 'dealer_address_latitude', $_POST['dealer_address_latitude'] );
	update_user_meta( $user_id, 'dealer_address_longitude', $_POST['dealer_address_longitude'] );
}

function autoroyal_custom_bg_shape_color() {

	wp_enqueue_style(
		'autoroyal-custom-style-shape',
		autoroyal_PLUGIN_URL . '/assets/css/custom-styles.css'
	);

	// Get all the Customized Theme Mods
    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    //
    $select_bg = "";
    if(strlen($MODS['select_bg'])>0) {
        $select_bg = $MODS['select_bg'];
    }

    // Main Hover Color
    if(!empty($select_bg)) {

        $bg_shape_1 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 481" style="enable-background:new 0 0 500 481;" xml:space="preserve">
            <path fill="'.$select_bg.'" d="M495,242.7c0,128.1-103.9,232-232,232s-330.3-149.8-232-232C130,160,183.1,32.9,263,10.7
                C386.5-23.5,495,114.6,495,242.7z"/>
            </svg>';
        $bg_shape_encoded_1 = base64_encode($bg_shape_1); 

        $bg_shape_2 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 426.8" style="enable-background:new 0 0 500 426.8;" xml:space="preserve">
            <path fill="'.$select_bg.'" d="M182.7,419.3c46.5-4.5,183.3-15.5,233.8-9.8c128.5,14.5,81.1-236-13.5-329S161-16.1,73.9,72.6
                s-101,263.1,13.5,329C113.4,416.7,145.9,420.3,182.7,419.3"/>
            </svg>';
        $bg_shape_encoded_2 = base64_encode($bg_shape_2); 

        $bg_shape_3 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 436.6" style="enable-background:new 0 0 500 436.6;" xml:space="preserve">
            <path fill="'.$select_bg.'" d="M430.6,217.6c-192,148.8-95.3,212.8-212.8,212.8S5,335.1,5,217.6S100.3,4.8,217.8,4.8S622.6,68.8,430.6,217.6z"
                />
            </svg>';
        $bg_shape_encoded_3 = base64_encode($bg_shape_3); 

        $bg_shape_4 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 397" style="enable-background:new 0 0 500 397;" xml:space="preserve">
            <path fill="'.$select_bg.'" d="M493.6,270.5c-3.1,26.3-9.5,47.4-18.2,64.3c-11.7,22.4-31.6,31.5-49.4,40.9c-5.1,2.7-10.5,5.1-16,7
                c-32.4,11.2-68.7,8.3-97.1,2.3c-20-4.2-40.3-6.7-60.6-7.7c-5.8-0.3-11.6-0.4-17.5-0.4c-9,0-170.7,3.1-210.1-76.7
                c-9.7-19.7-16.4-43.7-18.8-73C-1,144.5,36.3,90.1,84.3,54.6c90.9-67.2,215.4-64.4,305,4.6C448.9,105.1,504.7,174.7,493.6,270.5z"/>
            </svg>';
        $bg_shape_encoded_4 = base64_encode($bg_shape_4);

        $custom_select_bg = "

                .autoroyal-icon-box-centered-alt .autoroyal-icon-box-icon.icon-bg-shape_1 i, 
                .nav .nav-item.icon-bg-shape_1 i {
                    background-image: url('data:image/svg+xml;base64,{$bg_shape_encoded_1}') !important;
                }

                .autoroyal-icon-box-centered-alt .autoroyal-icon-box-icon.icon-bg-shape_2 i, 
                .nav .nav-item.icon-bg-shape_2 i {
                    background-image: url('data:image/svg+xml;base64,{$bg_shape_encoded_2}') !important;
                }

                .autoroyal-icon-box-centered-alt .autoroyal-icon-box-icon.icon-bg-shape_3 i, 
                .nav .nav-item.icon-bg-shape_3 i {
                    background-image: url('data:image/svg+xml;base64,{$bg_shape_encoded_3}') !important;
                }

                .autoroyal-icon-box-centered-alt .autoroyal-icon-box-icon.icon-bg-shape_4 i, 
                .nav .nav-item.icon-bg-shape_4 i {
                    background-image: url('data:image/svg+xml;base64,{$bg_shape_encoded_4}') !important;
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-shape', $custom_select_bg );

    }

}
add_action( 'wp_enqueue_scripts', 'autoroyal_custom_bg_shape_color', 9999 );

if( !function_exists('autoroyal_get_currency_symbol') ){
	/**
	 * Get Currency symbol.
	 *
	 * @param string $currency (default: '')
	 * @return string
	 */
	function autoroyal_get_currency_symbol( $currency = '' ) {
		if ( ! $currency ) {
			$currency = autoroyal_get_currency();
		}

		$symbols = apply_filters( 'autoroyal_currency_symbols', array(
			'AED' => '&#x62f;.&#x625;',
			'AFN' => '&#x60b;',
			'ALL' => 'L',
			'AMD' => 'AMD',
			'ANG' => '&fnof;',
			'AOA' => 'Kz',
			'ARS' => '&#36;',
			'AUD' => '&#36;',
			'AWG' => '&fnof;',
			'AZN' => 'AZN',
			'BAM' => 'KM',
			'BBD' => '&#36;',
			'BDT' => '&#2547;&nbsp;',
			'BGN' => '&#1083;&#1074;.',
			'BHD' => '.&#x62f;.&#x628;',
			'BIF' => 'Fr',
			'BMD' => '&#36;',
			'BND' => '&#36;',
			'BOB' => 'Bs.',
			'BRL' => '&#82;&#36;',
			'BSD' => '&#36;',
			'BTC' => '&#3647;',
			'BTN' => 'Nu.',
			'BWP' => 'P',
			'BYR' => 'Br',
			'BZD' => '&#36;',
			'CAD' => '&#36;',
			'CDF' => 'Fr',
			'CHF' => '&#67;&#72;&#70;',
			'CLP' => '&#36;',
			'CNY' => '&yen;',
			'COP' => '&#36;',
			'CRC' => '&#x20a1;',
			'CUC' => '&#36;',
			'CUP' => '&#36;',
			'CVE' => '&#36;',
			'CZK' => '&#75;&#269;',
			'DJF' => 'Fr',
			'DKK' => 'DKK',
			'DOP' => 'RD&#36;',
			'DZD' => '&#x62f;.&#x62c;',
			'EGP' => 'EGP',
			'ERN' => 'Nfk',
			'ETB' => 'Br',
			'EUR' => '&euro;',
			'FJD' => '&#36;',
			'FKP' => '&pound;',
			'GBP' => '&pound;',
			'GEL' => '&#x10da;',
			'GGP' => '&pound;',
			'GHS' => '&#x20b5;',
			'GIP' => '&pound;',
			'GMD' => 'D',
			'GNF' => 'Fr',
			'GTQ' => 'Q',
			'GYD' => '&#36;',
			'HKD' => '&#36;',
			'HNL' => 'L',
			'HRK' => 'Kn',
			'HTG' => 'G',
			'HUF' => '&#70;&#116;',
			'IDR' => 'Rp',
			'ILS' => '&#8362;',
			'IMP' => '&pound;',
			'INR' => '&#8377;',
			'IQD' => '&#x639;.&#x62f;',
			'IRR' => '&#xfdfc;',
			'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
			'ISK' => 'kr.',
			'JEP' => '&pound;',
			'JMD' => '&#36;',
			'JOD' => '&#x62f;.&#x627;',
			'JPY' => '&yen;',
			'KES' => 'KSh',
			'KGS' => '&#x441;&#x43e;&#x43c;',
			'KHR' => '&#x17db;',
			'KMF' => 'Fr',
			'KPW' => '&#x20a9;',
			'KRW' => '&#8361;',
			'KWD' => '&#x62f;.&#x643;',
			'KYD' => '&#36;',
			'KZT' => 'KZT',
			'LAK' => '&#8365;',
			'LBP' => '&#x644;.&#x644;',
			'LKR' => 'Rs',
			'LRD' => '&#36;',
			'LSL' => 'L',
			'LYD' => '&#x644;.&#x62f;',
			'MAD' => '&#x62f;.&#x645;.',
			'MDL' => 'MDL',
			'MGA' => 'Ar',
			'MKD' => '&#x434;&#x435;&#x43d;',
			'MMK' => 'Ks',
			'MNT' => '&#x20ae;',
			'MOP' => 'P',
			'MRO' => 'UM',
			'MUR' => '&#x20a8;',
			'MVR' => '.&#x783;',
			'MWK' => 'MK',
			'MXN' => '&#36;',
			'MYR' => '&#82;&#77;',
			'MZN' => 'MT',
			'NAD' => '&#36;',
			'NGN' => '&#8358;',
			'NIO' => 'C&#36;',
			'NOK' => '&#107;&#114;',
			'NPR' => '&#8360;',
			'NZD' => '&#36;',
			'OMR' => '&#x631;.&#x639;.',
			'PAB' => 'B/.',
			'PEN' => 'S/.',
			'PGK' => 'K',
			'PHP' => '&#8369;',
			'PKR' => '&#8360;',
			'PLN' => '&#122;&#322;',
			'PRB' => '&#x440;.',
			'PYG' => '&#8370;',
			'QAR' => '&#x631;.&#x642;',
			'RMB' => '&yen;',
			'RON' => 'lei',
			'RSD' => '&#x434;&#x438;&#x43d;.',
			'RUB' => '&#8381;',
			'RWF' => 'Fr',
			'SAR' => '&#x631;.&#x633;',
			'SBD' => '&#36;',
			'SCR' => '&#x20a8;',
			'SDG' => '&#x62c;.&#x633;.',
			'SEK' => '&#107;&#114;',
			'SGD' => '&#36;',
			'SHP' => '&pound;',
			'SLL' => 'Le',
			'SOS' => 'Sh',
			'SRD' => '&#36;',
			'SSP' => '&pound;',
			'STD' => 'Db',
			'SYP' => '&#x644;.&#x633;',
			'SZL' => 'L',
			'THB' => '&#3647;',
			'TJS' => '&#x405;&#x41c;',
			'TMT' => 'm',
			'TND' => '&#x62f;.&#x62a;',
			'TOP' => 'T&#36;',
			'TRY' => '&#8378;',
			'TTD' => '&#36;',
			'TWD' => '&#78;&#84;&#36;',
			'TZS' => 'Sh',
			'UAH' => '&#8372;',
			'UGX' => 'UGX',
			'USD' => '&#36;',
			'UYU' => '&#36;',
			'UZS' => 'UZS',
			'VEF' => 'Bs F',
			'VND' => '&#8363;',
			'VUV' => 'Vt',
			'WST' => 'T',
			'XAF' => 'CFA',
			'XCD' => '&#36;',
			'XOF' => 'Fr',
			'XPF' => 'Fr',
			'YER' => '&#xfdfc;',
			'ZAR' => '&#82;',
			'ZMW' => 'ZK',
		) );

		$currency_symbol = isset( $symbols[ $currency ] ) ? $symbols[ $currency ] : '';

		return apply_filters( 'autoroyal_currency_symbol', $currency_symbol, $currency );
	}

}
