/* global jQuery:false */
/* global FNT_ADDONS_STORAGE:false */

jQuery(document).ready(function(){

	"use strict";

	// Hide/Show pages list on change import_posts
	jQuery('#fnt_importer_form .fnt_importer_item_posts').on('change', function() {
		var demo_set = jQuery('#fnt_importer_form [name="demo_set"]:checked').val();
		if (jQuery(this).get(0).checked && demo_set=='part') 
			jQuery('.fnt_importer_part_pages').show();
		else
			jQuery('.fnt_importer_part_pages').hide();
	});

	// Change demo type
	jQuery('input[type=radio][name=demo_type]').change(function() {
		var type = jQuery(this).val();
		// Refresh list of the pages
		var data = {
			ajax_nonce: FNT_ADDONS_STORAGE['ajax_nonce'],
			action: 'fnt_addons_importer_get_list_pages',
			demo_type: type
		};
		jQuery.post(FNT_ADDONS_STORAGE['ajax_url'], data, function(response) {
			var rez = {};
			try {
				rez = JSON.parse(response);
			} catch (e) {
				rez = { error: FNT_ADDONS_STORAGE['ajax_error']+':<br>'+response };
				console.log(response);
			}
			if (rez.error === '') {
				var html = '';
				for (var id in rez.data) {
					html += '<label>'
							+ '<input class="fnt_importer_pages" type="checkbox" value="'+id+'" name="import_pages_'+id+'" id="import_pages_'+id+'" />'
							+ ' ' + rez.data[id]
							+ '</label>';
				}
				if (html != '') jQuery('.fnt_importer_part_pages').html(html);
			}
		});
	});

	// Change demo set
	jQuery('.fnt_importer_demo_set input[type="radio"]').on('change', function() {
		var set = jQuery(this).val();
		// Show/hide description of the set
		jQuery(this).parents('.fnt_importer_demo_set')
			.find('.fnt_importer_description').slideUp()
			.end()
			.find('.fnt_importer_description_'+set).slideDown();
		// Show/hide set items
		jQuery(this).parents('form').find('[data-set-'+set+'="1"]').parent().show();
		jQuery(this).parents('form').find('[data-set-'+set+'="0"]').removeAttr('checked').parent().hide();
		jQuery(this).parents('form').find('.fnt_importer_item_posts').trigger('change');
	});
	jQuery('.fnt_importer_demo_set input[type="radio"]:checked').trigger('change');
	
	// Start import
	jQuery('.fnt_importer_section').on('click', '.fnt_buttons input[type="button"]', function() {
		var steps = [];
		var demo_type = jQuery('#fnt_importer_form [name="demo_type"]:checked').val();
		var demo_set = jQuery('#fnt_importer_form [name="demo_set"]:checked').val();
		var demo_parts = '', demo_pages = '';
		jQuery(this).parents('form').find('input[type="checkbox"].fnt_importer_item').each(function() {
			var name = jQuery(this).attr('name');
			// Collect parts to be imported
			if (jQuery(this).get(0).checked) {
				demo_parts += (demo_parts ? ',' : '') + name.substr(7); // Remove 'import_' from name - save only slug
				// Collect pages to be import
				if (demo_set=='part' && name == 'import_posts') {
					jQuery('.fnt_importer_part_pages input[type="checkbox"]').each(function() {
						if (jQuery(this).get(0).checked) {
							demo_pages += (demo_pages ? ',' : '') + jQuery(this).val();
						}
					});
				}
				var step = {
					action: name,
					data: {
						demo_type: demo_type,
						demo_set: demo_set,
						demo_parts: demo_parts,
						demo_pages: demo_pages,
						start_from_id: 0
					}
				};
				steps.push(step);
			} else
				jQuery('#fnt_importer_progress .'+name).hide();
		});
		steps.unshift({
			action: 'import_start',
			data: { 
				demo_type: demo_type,
				demo_set: demo_set,
				demo_parts: demo_parts
			}
		});
		steps.push({
			action: 'import_end',
			data: { 
				demo_type: demo_type,
				demo_set: demo_set,
				demo_parts: demo_parts
			}
		});
		// Start banners rotator
		jQuery('.fnt_exporter_section').hide();
		jQuery('.fnt_banners_section').show();
		// Start import
		jQuery('#fnt_importer_form').hide();
		jQuery('#fnt_importer_progress').fadeIn();
		FNT_ADDONS_STORAGE['importer_error_messages'] = '';
		FNT_ADDONS_STORAGE['importer_ignore_errors'] = true;
		fnt_addons_importer_do_action(steps, 0);
	});
	
	// Call specified action (step)
	function fnt_addons_importer_do_action(steps, idx) {
		if ( !jQuery('#fnt_importer_progress .'+steps[idx].action+' .import_progress_status').hasClass('step_in_progress') ) {
			jQuery('#fnt_importer_progress .'+steps[idx].action+' .import_progress_status').addClass('step_in_progress');
			jQuery('#fnt_importer_progress .'+steps[idx].action+' .import_progress_status.step_in_progress span').html('0%');
		}
		// AJAX query params
		var data = {
			ajax_nonce: FNT_ADDONS_STORAGE['ajax_nonce'],
			action: 'fnt_addons_importer_start_import',
			importer_action: steps[idx].action
		};
		// Additional params depend current step
		for (var i in steps[idx].data)
			data[i] = steps[idx].data[i];
		// Send request to server
		//console.log(steps);
		//console.log(data);
		jQuery.post(FNT_ADDONS_STORAGE['ajax_url'], data, function(response) {
			console.log(response);
			var rez = {};
			try {
				rez = JSON.parse(response);
			} catch (e) {
				rez = { error: FNT_ADDONS_STORAGE['ajax_error']+':<br>'+response };
				console.log(response);
			}
			if (rez.error === '' || FNT_ADDONS_STORAGE['importer_ignore_errors']) {
				if (rez.error !== '') 
					FNT_ADDONS_STORAGE['importer_error_messages'] += '<p class="error_message">' + rez.error + '</p>';
				var action = rez.action;
				if (rez.result === null || rez.result >= 100) {
					jQuery('#fnt_importer_progress .'+action+' .import_progress_status span').html('');
					jQuery('#fnt_importer_progress .'+action+' .import_progress_status').removeClass('step_in_progress').addClass('step_complete'+(rez.error ? ' step_complete_with_error' : ''));

					idx++;
				} else {
					jQuery('#fnt_importer_progress .'+action+' .import_progress_status span').html(rez.result + '%');
					steps[idx].data['start_from_id'] = (typeof rez.start_from_id != 'undefined') ? rez.start_from_id : 0;
					steps[idx].data['attempt'] = (typeof rez.attempt != 'undefined') ? rez.attempt : 0;
				}
				// Do next action
				if (idx < steps.length) {
					fnt_addons_importer_do_action(steps, idx);
				} else {
					if (FNT_ADDONS_STORAGE['importer_error_messages']) {
						jQuery('#fnt_importer_progress').removeClass('notice-info').addClass('notice-error').append('<h4>' + FNT_ADDONS_STORAGE['msg_importer_error'] + '</h4>' + FNT_ADDONS_STORAGE['importer_error_messages']);
					} else {
						jQuery('#fnt_importer_progress').removeClass('notice-info').addClass('notice-success');
						jQuery('.fnt_importer_progress_complete').show();
					}
				}
			} else {
				// Add Error block above Import section
				jQuery('#fnt_importer_progress span').removeClass('notice-info').addClass('notice-error').css({'paddingTop': '1em', 'paddingBottom': '1em'}).html(rez.error);
			}
		});
	}

});
