<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_entry_button_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'title' => 'Title',
		'btn_url' => '#',
		'title_color' => '#ffffff',
		'title_hover_color' => '#ffffff',
		'button_color' => '#D00027',
		'button_hover_color' => '#aa0020',
		'align' => 'left',
		'button_size' => 'default',
		'icon_align' => 'left',
		'add_icon' => 'true',
    	'icon_type' => 'material',
    	'icon_material' => '3d_rotation',
    	'icon_fontawesome' => '',
		'icon_openiconic' => '',
		'icon_typicons' => '',
		'icon_entypo' => '',
		'icon_linecons' => '',
		'icon_monosocial' => '',
    	'css' => '',
   	), $atts ) );

	ob_start();

	$class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;

    $unique_id = uniqid();
    $button_class = "autoroyal_button_" . $unique_id;

    if ( 'true' === $add_icon ) {

		if( $icon_type !== 'autoroyal' ) {

			vc_icon_element_fonts_enqueue( $icon_type );

			if ( isset( ${'icon_' . $icon_type} ) ) {
				$icon_class = ${'icon_' . $icon_type};
			} else {
				$icon_class = 'fa fa-adjust';
			}

		}

	}

	?>

	<div class="autoroyal-button-container <?php echo esc_attr($css_class); ?>">

		<a class="autoroyal-button <?php echo esc_attr($button_class); ?> button-icon-<?php echo esc_attr($icon_align); ?> <?php if($button_size == "small" ) { echo "autoroyal-button-size-small"; } ?> autoroyal-button-align-<?php echo esc_attr($align); ?>" href="<?php echo esc_url($btn_url); ?>">

			<?php if ( 'true' === $add_icon AND $icon_align == "left" ) { ?>
				<?php if( $icon_type == "material" ) { echo "<i class='" . wp_kses($icon_material, true) . "'></i>"; } else { echo "<i class='" . wp_kses($icon_class, true) . "'></i>"; } ?>
			<?php } ?>
			<span><?php echo esc_attr($title); ?></span>
			<?php if ( 'true' === $add_icon AND $icon_align == "right" ) { ?>
				<?php if( $icon_type == "material" ) { echo "<i class='" . wp_kses($icon_material, true) . "'></i>"; } else { echo "<i class='" . wp_kses($icon_class, true) . "'></i>"; } ?>
			<?php } ?>

		</a>

	</div>

	<?php

	wp_enqueue_style(
        'autoroyal-custom-style-button',
        get_template_directory_uri() . '/assets/css/custom-styles.css'
    );

    if(!empty($title_color)) {

        $custom_title_color = "

                .{$button_class} { 
                    color: {$title_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-button', $custom_title_color );

    }

    if(!empty($button_color)) {

        $custom_button_color = "

                .{$button_class} { 
                    background-color: {$button_color};
                    border-color: {$button_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-button', $custom_button_color );

    }

    if(!empty($title_hover_color)) {

        $custom_title_hover_color = "

                .{$button_class}:hover { 
                    color: {$title_hover_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-button', $custom_title_hover_color );

    }

    if(!empty($button_hover_color)) {

        $custom_button_hover_color = "

                .{$button_class}:hover { 
                    background-color: {$button_hover_color};
                    border-color: {$button_hover_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-button', $custom_button_hover_color );

    }

	return ob_get_clean();

}
add_shortcode( 'autoroyal_entry_button', 'autoroyal_entry_button_func' );

vc_map( array(
  	'name' => esc_html__( 'autoRoyal Button', 'autoroyal' ),
	'base' => 'autoroyal_entry_button',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal icon box', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Button Text', 'autoroyal' ),
			'param_name' => 'title',
			'admin_label' => true,
			'value' => esc_html__( 'Button Text', 'autoroyal' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Button URL', 'autoroyal' ),
			'param_name' => 'btn_url',
			'admin_label' => true,
			'value' => esc_html__( '#', 'autoroyal' ),
		),
		array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Text Color', 'autoroyal' ),
            'param_name' => 'title_color',
            'description' => esc_html__( 'Select color for button text.', 'autoroyal' ),
            'std' => '#ffffff',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Text Hover Color', 'autoroyal' ),
            'param_name' => 'title_hover_color',
            'description' => esc_html__( 'Select color for button text hover.', 'autoroyal' ),
            'std' => '#ffffff',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Background Color', 'autoroyal' ),
            'param_name' => 'button_color',
            'description' => esc_html__( 'Select color for button background .', 'autoroyal' ),
            'std' => '#D00027',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Hover Background Color', 'autoroyal' ),
            'param_name' => 'button_hover_color',
            'description' => esc_html__( 'Select color for button hover background.', 'autoroyal' ),
            'std' => '#aa0020',
        ),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Align', 'autoroyal' ),
			'value' => array(
				__( 'Left', 'autoroyal' ) => 'left',
				__( 'Center', 'autoroyal' ) => 'center',
				__( 'Right', 'autoroyal' ) => 'right',
			),
			'param_name' => 'align',
			'description' => esc_html__( 'Select align.', 'autoroyal' ),
			'std' => 'left',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon Align', 'autoroyal' ),
			'value' => array(
				__( 'Left', 'autoroyal' ) => 'left',
				__( 'Right', 'autoroyal' ) => 'right',
			),
			'param_name' => 'icon_align',
			'description' => esc_html__( 'Select align.', 'autoroyal' ),
			'std' => 'left',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Add icon?', 'autoroyal' ),
			'param_name' => 'add_icon',
			'std' => 'true',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon library', 'autoroyal' ),
			'value' => array(
				__( 'Material Icons', 'autoroyal' ) => 'material',
				__( 'Font Awesome', 'autoroyal' ) => 'fontawesome',
				__( 'Open Iconic', 'autoroyal' ) => 'openiconic',
				__( 'Typicons', 'autoroyal' ) => 'typicons',
				__( 'Entypo', 'autoroyal' ) => 'entypo',
				__( 'Linecons', 'autoroyal' ) => 'linecons',
				__( 'Mono Social', 'autoroyal' ) => 'monosocial',
			),
			'param_name' => 'icon_type',
			'description' => esc_html__( 'Select icon library.', 'autoroyal' ),
			'dependency' => array(
				'element' => 'add_icon',
				'value' => 'true',
			),
			'std' => 'material',
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_material',
			'value' => '3d_rotation', // default value to backend editor admin_label
			'settings' => array(
				'emptyIcon' => false, // default true, display an "EMPTY" icon?
				'type' => 'material',
				'iconsPerPage' => 4000, // default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'material',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_fontawesome',
			'value' => 'fa fa-info-circle',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'fontawesome',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'std' => 'fa fa-info-circle',
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_openiconic',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'openiconic',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'openiconic',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_typicons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'typicons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'typicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_entypo',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'entypo',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'entypo',
			),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_linecons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'linecons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'linecons',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_monosocial',
			'value' => 'vc-mono vc-mono-fivehundredpx', // default value to backend editor admin_label
			'settings' => array(
				'emptyIcon' => false, // default true, display an "EMPTY" icon?
				'type' => 'monosocial',
				'iconsPerPage' => 4000, // default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'monosocial',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),

));

