<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function search_by_price_item_func( $atts, $content ) {

    extract( shortcode_atts( array(
        "columns" => "4",
        'price' => '10000',
        'price_title' => 'Under $10k',
    ), $atts ) );

    ob_start();

    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $vehicles_search_url = "";
    $vehicles_search_url = get_option("autoroyal_search_vehicles_page_id");

    $items = get_posts( array(
        'post_type'   => 'vehicle',
        'post_status' => 'publish',
        'numberposts' => -1,
        'meta_query' => array(
                array(
                    'key' => 'vehicle_price',
                    'value' => $price,
                    'type' => 'NUMERIC',
                    'compare' => '<='
                )
            )
        ) 
    );

    $count = count( $items );

    ?>

        <div class="<?php if($columns == "4") { ?>col-lg-3 col-md-6<?php } else if($columns == "3") { ?>col-lg-4 col-md-6<?php } elseif($columns == "2") { ?>col-lg-6 col-md-6<?php } elseif($columns == "1") { ?>col-lg-12 col-md-12<?php } ?> col-sm-12">

            <a href="<?php echo get_permalink( $vehicles_search_url ); ?>?price=<?php echo esc_attr($price); ?>">
                <?php echo esc_attr($price_title); ?> <span class="text-muted"><?php echo esc_attr($count); ?></span>
            </a>

        </div>

    <?php

    return ob_get_clean();

}
add_shortcode( 'search_by_price_item', 'search_by_price_item_func' );

vc_map( array(
    'name' => esc_html__( 'Seacrh by Price Item', 'autoroyal' ),
    'base' => 'search_by_price_item',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'description' => esc_html__( 'Custom autoroyal search by price item', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "content_element" => true,
    "as_child" => array('only' => 'autoroyal_slider'), 
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Columns', 'autoroyal' ),
            'value' => array(
                __( '4 Columns', 'autoroyal' ) => '4',
                __( '3 Columns', 'autoroyal' ) => '3',
                __( '2 Columns', 'autoroyal' ) => '2',
                __( '1 Column', 'autoroyal' ) => '1',
            ),
            'param_name' => 'columns',
            'description' => esc_html__( 'Select the number of columns.', 'autoroyal' ),
            'std' => '4',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Maxim price', 'autoroyal' ),
            'param_name' => 'price',
            'value' => "10000",
            'admin_label' => true,
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Maxim price text', 'autoroyal' ),
            'param_name' => 'price_title',
            'value' => "Under $10k",
            'admin_label' => true,
        ),
    ),
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_search_by_price_item extends WPBakeryShortCode {
    }
}

