<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_vehicle_banner_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'car_selection_type' => 'random',
		'post_id' => '',
    	'css' => '',
   	), $atts ) );

	ob_start();

	$class_to_filter = vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	$unique_id = uniqid();
	$banner_class = "vehicle_banner_class_" . $unique_id;

	if($car_selection_type == "random") {
		$posts = get_posts('post_type=vehicle&orderby=rand&numberposts=1');
		$post_id = $posts[0]->ID;
	}

	if(!empty($post_id)) {

        $current_vehicle_year = esc_attr(get_post_meta($post_id, 'vehicle_year',true));
        $current_vehicle_make = esc_attr(get_post_meta($post_id, 'vehicle_make',true));
        $current_vehicle_model = esc_attr(get_post_meta($post_id, 'vehicle_model',true));
        $current_vehicle_make_desc_init = esc_attr(get_post_meta($post_id, 'vehicle_make_desc_init',true));

        $current_vehicle_name = "";
        if(!empty($current_vehicle_make_desc_init)) {
            $current_vehicle_name .= $current_vehicle_make_desc_init . " ";
        }
        if(!empty($current_vehicle_model)) {
            $current_vehicle_name .= $current_vehicle_model . " ";
        }

        //
        $vehicle_mileage = esc_attr(get_post_meta($post_id, 'vehicle_mileage',true));
        $vehicle_condition = esc_attr(get_post_meta($post_id, 'vehicle_condition',true));

        $terms_vehicle_transmission = "";
        $terms_vehicle_transmission_id = "";
        $vehicle_transmission = get_the_terms($post_id, 'vehicle_transmission' );
        if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
            $terms_vehicle_transmission = $vehicle_transmission[0]->name;
            $terms_vehicle_transmission_id = $vehicle_transmission[0]->term_id;
        endif;

        $terms_vehicle_fuel_type = "";
        $terms_vehicle_fuel_type_id = "";
        $vehicle_fuel_type = get_the_terms($post_id, 'vehicle_fuel_type' );
        if ($vehicle_fuel_type && ! is_wp_error($vehicle_fuel_type)) :
            $terms_vehicle_fuel_type = $vehicle_fuel_type[0]->name;
            $terms_vehicle_fuel_type_id = $vehicle_fuel_type[0]->term_id;
        endif;

        $price = esc_attr(get_post_meta($post_id, 'vehicle_price',true));

        $vehicle_stock = esc_attr(get_post_meta($post_id, 'vehicle_stock',true));

        $vehicle_engine_volume_l = esc_attr(get_post_meta($post_id, 'vehicle_engine_volume_l',true));

        $vehicle_drive = get_the_terms($post_id, 'vehicle_drive' );
        $terms_vehicle_drive = $vehicle_drive[0]->name;

        $vehicle_cover_image = get_post_meta($post_id, 'vehicle_cover_image',true);

    ?>

	<div class="ft-vehicle-banner <?php echo esc_attr($css_class); ?> <?php echo esc_attr($banner_class); ?>">
      	<div class="ft-vehicle-banner-inner">
      		<h4 class="autoroyal-vehicle-block-meta-price text-white"><?php echo autoroyal_price($price); ?></h4>
			<a class="heading" href="<?php echo get_permalink( $post_id ); ?>"><span><?php echo esc_attr($current_vehicle_year); ?> - <?php echo esc_attr($current_vehicle_name); ?></span></a>
			<ul class="autoroyal-vehicle-block-specs text-white">

                <?php if(!empty($vehicle_mileage)) { ?>

                    <li class="autoroyal-vehicle-transmission">

                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>


                        <span><?php echo autoroyal_number($vehicle_mileage); ?> <?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?></span>

                    </li>

                <?php } elseif( !empty($vehicle_condition) ) { ?>

                    <li class="autoroyal-vehicle-condition">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="48.997px" height="48.998px" viewBox="0 0 48.997 48.998" style="enable-background:new 0 0 48.997 48.998;" xml:space="preserve"><path d="M45.961,18.702c-0.033-0.038-0.061-0.075-0.1-0.112l-1.717-1.657c1.424-0.323,2.957-1.516,2.957-2.74
c0-1.426-1.979-1.932-3.668-1.932c-1.766,0-1.971,1.21-1.992,2.065l-4.43-4.271c-0.9-0.891-2.607-1.592-3.883-1.592H24.5h-0.002
h-8.63c-1.275,0-2.981,0.701-3.882,1.592l-4.429,4.271c-0.023-0.855-0.228-2.065-1.992-2.065c-1.691,0-3.669,0.506-3.669,1.932
c0,1.224,1.534,2.417,2.958,2.74l-1.717,1.657c-0.039,0.037-0.066,0.074-0.1,0.112C1.2,20.272,0,23.184,0,25.297v6.279
c0,1.524,0.601,2.907,1.572,3.938v2.435c0,1.424,1.192,2.585,2.658,2.585h3.214c1.466,0,2.657-1.159,2.657-2.585v-0.623h14.397
H24.5h14.396v0.623c0,1.426,1.19,2.585,2.658,2.585h3.213c1.467,0,2.657-1.161,2.657-2.585v-2.435
c0.972-1.031,1.572-2.414,1.572-3.938v-6.279C48.998,23.184,47.798,20.272,45.961,18.702z M13.613,11.953
c0.623-0.519,1.712-0.913,2.255-0.913h8.63H24.5h8.63c0.543,0,1.632,0.394,2.255,0.913l5.809,5.63H24.5h-0.002H7.805L13.613,11.953
z M1.993,24.347c0-1.546,1.21-2.801,2.704-2.801c1.493,0,6.372,2.864,6.372,4.41s-4.879,1.188-6.372,1.188
C3.203,27.144,1.993,25.894,1.993,24.347z M10.102,34.573H9.587H9.072l-3.055,0.005c-0.848-0.264-1.446-0.572-1.869-0.903
c-0.214-0.167-0.378-0.341-0.506-0.514c-0.129-0.175-0.223-0.347-0.284-0.519c-0.38-1.074,0.405-2.061,0.405-2.061h5.214
l3.476,3.99L10.102,34.573L10.102,34.573z M31.996,34.575H24.5h-0.002h-7.496c-1.563,0-2.832-1.269-2.832-2.831h10.328H24.5h10.328
C34.828,33.308,33.559,34.575,31.996,34.575z M32.654,29.812H24.5h-0.002h-8.154c-1.7,0-3.08-2.096-3.08-4.681h11.234H24.5h11.234
C35.734,27.717,34.354,29.812,32.654,29.812z M45.641,32.644c-0.062,0.172-0.156,0.344-0.285,0.518
c-0.127,0.173-0.291,0.347-0.506,0.514c-0.422,0.331-1.021,0.641-1.869,0.903l-3.055-0.005h-0.515h-0.515h-2.353l3.478-3.99h5.213
C45.234,30.583,46.02,31.568,45.641,32.644z M44.301,27.144c-1.492,0-6.371,0.356-6.371-1.188s4.879-4.41,6.371-4.41
c1.494,0,2.704,1.255,2.704,2.801C47.005,25.892,45.795,27.144,44.301,27.144z"/></svg>

                        <span><?php echo esc_attr($vehicle_condition); ?></span>
                    </li>

                <?php } ?>

                <?php if(!empty($terms_vehicle_transmission)) { ?>

                    <li class="autoroyal-vehicle-transmission">

                        <svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"/><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"/><circle cx="70" cy="70" r="4"/></svg>

                        <span><?php echo esc_attr($terms_vehicle_transmission); ?></span>

                    </li>

                <?php } ?>

                <?php if(!empty($terms_vehicle_drive)) { ?>
                    <!-- Stock # -->
                    <li class="autoroyal-vehicle-stock">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 480 493" style="enable-background:new 0 0 480 493;" xml:space="preserve"><path d="M360,149h16c13.3,0,24-10.7,24-24V29c0-13.3-10.7-24-24-24h-16c-13.3,0-24,10.7-24,24v24H144V29c0-13.3-10.7-24-24-24h-16
C90.7,5,80,15.7,80,29v96c0,13.3,10.7,24,24,24h16c13.3,0,24-10.7,24-24v-24h37.8l34.2,20.5v98.9l-15.8,110.4l-21.8,51l-34.4,5.8
V365c0-13.3-10.7-24-24-24h-16c-13.3,0-24,10.7-24,24v96c0,13.3,10.7,24,24,24h16c13.3,0,24-10.7,24-24v-22.6l38.7,6.4
c0.2,0,0.4,0,0.6,0c0.2,0,0.5,0.1,0.7,0.1h112c0.2,0,0.5-0.1,0.7-0.1c0.2,0,0.4,0,0.6,0l38.7-6.4V461c0,13.3,10.7,24,24,24h16
c13.3,0,24-10.7,24-24v-96c0-13.3-10.7-24-24-24h-16c-13.3,0-24,10.7-24,24v22.6l-34.4-5.7l-21.8-51L264,220.4v-98.9l34.2-20.5H336
v24C336,138.3,346.7,149,360,149z M277,365L277,365L277,365L277,365z"/></svg>

                        <span><?php echo esc_attr($terms_vehicle_drive); ?></span>
                    </li>
                <?php } ?>

                <?php if(!empty($vehicle_engine_volume_l)) { ?>
                    <!-- Stock # -->
                    <li class="autoroyal-vehicle-stock">
                        <svg class="svg-icon" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 15.4 12.1" style="enable-background:new 0 0 15.4 12.1;" xml:space="preserve"><path class="st0" d="M14.9,6.2c-0.3,0-0.5,0.2-0.5,0.5v0.6h-1.1V6.8c0-0.3-0.2-0.5-0.5-0.5h-0.7l-0.7-0.7V3.3c0-0.3-0.2-0.5-0.5-0.5
                        H5.1V1.5h1.8c0.3,0,0.5-0.2,0.5-0.5S7.1,0.5,6.9,0.5h-4C2.5,0.5,2.3,0.8,2.3,1s0.2,0.5,0.5,0.5h1.8v1.3H2.8C2.5,2.8,2.3,3,2.3,3.3
                        v2.8H1V4.4c0-0.3-0.2-0.5-0.5-0.5S0,4.1,0,4.4v4c0,0.3,0.2,0.5,0.5,0.5S1,8.7,1,8.4V6.6h1.3v3c0,0.3,0.2,0.5,0.5,0.5h1.3l0.3,0.3
                        v0.9c0,0.3,0.2,0.5,0.5,0.5h7.8c0.3,0,0.5-0.2,0.5-0.5v-0.5h1.1v0.7c0,0.3,0.2,0.5,0.5,0.5s0.5-0.2,0.5-0.5v-1.2V7.8V6.7
                        C15.4,6.5,15.2,6.2,14.9,6.2z M12.8,9.9c-0.3,0-0.5,0.2-0.5,0.5v0.5H5.5v-0.7c0-0.1-0.1-0.3-0.2-0.4L4.7,9.3
                        C4.6,9.2,4.4,9.1,4.3,9.1h-1V3.8h7.1v2.1c0,0.1,0.1,0.3,0.1,0.4l1,1c0.1,0.1,0.2,0.1,0.4,0.1h0.4v0.5c0,0.3,0.2,0.5,0.5,0.5h1.6v1.5
                        H12.8z"></path>
                        </svg>

                        <span><?php echo esc_attr($vehicle_engine_volume_l); ?>L</span>
                    </li>
                <?php } ?>

                <?php if(!empty($terms_vehicle_fuel_type)) { ?>
                    <!-- Stock # -->
                    <li class="autoroyal-vehicle-stock">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="200" width="200" fill="#000000" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve"><path d="M89.417,36.305c0.18-1.034-0.144-2.146-0.953-2.877l-11.045-9.943c-1.193-1.071-3.198-1.139-4.459-0.146l-1.392,1.098   l0.55-7.6c0.116-1.6-1.102-2.907-2.705-2.907h-4.241V7.292C65.172,3.281,61.892,0,57.88,0H17.819c-4.011,0-7.292,3.281-7.292,7.292   V92.71c0,4.009,3.281,7.29,7.292,7.29H57.88c4.012,0,7.292-3.281,7.292-7.29V70.482h0.241c1.604,0,2.915-1.312,2.915-2.916v-1.449   c1.66,0.897,3.29,2.75,3.75,6.534c0.553,4.566-0.074,8.193-0.579,11.107c-0.301,1.734-0.56,3.231-0.56,4.679   c0,6.78,4.317,10.439,8.38,10.439c2.228,0,4.346-1.059,5.812-2.9c1.49-1.877,2.278-4.481,2.278-7.539   c0-5.536-0.67-10.292-1.318-14.894c-0.787-5.587-1.537-10.905-1.138-17.48c1.454-0.025,2.705-1.127,2.854-2.608l1.653-16.373   C89.488,36.812,89.464,36.554,89.417,36.305z M27.008,35.317c-1.512,0-2.738-1.227-2.738-2.737c0-1.515,1.227-2.738,2.738-2.738   c1.513,0,2.738,1.224,2.738,2.738C29.746,34.091,28.521,35.317,27.008,35.317z M37.851,35.317c-1.511,0-2.737-1.227-2.737-2.737   c0-1.515,1.227-2.738,2.737-2.738c1.514,0,2.739,1.224,2.739,2.738C40.59,34.091,39.364,35.317,37.851,35.317z M48.694,35.317   c-1.512,0-2.737-1.227-2.737-2.737c0-1.515,1.226-2.738,2.737-2.738c1.513,0,2.739,1.224,2.739,2.738   C51.434,34.091,50.207,35.317,48.694,35.317z M59.258,19.937c0,1.604-1.313,2.916-2.917,2.916H19.359   c-1.604,0-2.916-1.312-2.916-2.916v-9.825c0-1.604,1.312-2.916,2.916-2.916h36.981c1.604,0,2.917,1.312,2.917,2.916V19.937z    M81.167,92.824c-1.734,2.182-5.164,0.629-5.164-4.387c0-1.012,0.226-2.311,0.485-3.813c0.531-3.07,1.259-7.277,0.616-12.583   c-0.829-6.815-4.753-10.178-8.776-11.322v-1.161c0-1.604-1.312-2.916-2.915-2.916h-0.241v-13.07h2.096   c1.604,0,3.011-1.308,3.127-2.907l0.331-4.587l7.198,3.511l-0.065,12.875c-0.008,1.316,0.871,2.512,2.067,2.993   c-0.468,7.242,0.35,13.108,1.15,18.797c0.653,4.629,1.27,9.003,1.27,14.185C82.346,90.31,81.927,91.868,81.167,92.824z"></path></svg>

                        <span><?php echo esc_attr($terms_vehicle_fuel_type); ?></span>
                    </li>
                <?php } ?>

                <?php if(!empty($vehicle_stock)) { ?>
                    <!-- Stock # -->
                    <li class="autoroyal-vehicle-stock">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"> <path d="M371.6,231.2v-49.5h-41.3v-41.3h-49.5v41.3h-49.5v-41.3h-49.5v41.3h-41.3v49.5h41.3v49.5h-41.3v49.5h41.3v41.3h49.5v-41.3
h49.5v41.3h49.5v-41.3h41.3v-49.5h-41.3v-49.5L371.6,231.2L371.6,231.2z M280.8,280.8h-49.5v-49.5h49.5V280.8z"/><path d="M404.2,510H107.8C49.5,510,2,462.5,2,404.2V107.8C2,49.5,49.5,2,107.8,2h296.3C462.5,2,510,49.5,510,107.8v296.3
C510,462.5,462.5,510,404.2,510z M107.8,62C82.6,62,62,82.6,62,107.8v296.3c0,25.3,20.6,45.8,45.8,45.8h296.3
c25.3,0,45.8-20.6,45.8-45.8V107.8c0-25.3-20.6-45.8-45.8-45.8H107.8z"/></svg>

                        <span><?php echo esc_attr($vehicle_stock); ?></span>
                    </li>
                <?php } ?>

            </ul>
            <span class="w-100">
            	<a class="autoroyal-button button-icon-right autoroyal-button-align-left btn btn-icon-right" href="<?php echo get_permalink( $post_id ); ?>">
	            	<span><?php esc_html_e('Details','autoroyal'); ?></span>
	            	<i class="material-icons">trending_flat</i>			
				</a>
			</span>
      	</div>
    </div>

	<?php

	}

	wp_enqueue_style(
		'autoroyal-custom-style-banner',
		get_template_directory_uri() . '/assets/css/custom-styles.css'
	);

    // Main Hover Color
	if(!empty($vehicle_cover_image)) {

        $css_custom_banner_bg = "

                .{$banner_class} { 
                    background-image: url({$vehicle_cover_image});
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-banner', $css_custom_banner_bg );

    }

	return ob_get_clean();

}
add_shortcode( 'autoroyal_vehicle_banner', 'autoroyal_vehicle_banner_func' );

//
$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
    'post_type'           => 'vehicle',
    'post_status'         => 'publish',
    'posts_per_page'      => -1,
));

$search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
$cars_query  = new WP_Query;
$cars        = $cars_query->query( $search_args );

$cars_array = array();

if ( $cars ) :

    foreach ( $cars as $car ) :

        $car_ID = $car->ID; 

        $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
        $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
        $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));

        $vehicle_name = $vehicle_make_desc_init . " " . $vehicle_model . " " . $vehicle_year;

        $cars_array[$vehicle_name] = $car_ID; 

    endforeach;

endif;

vc_map( array(
  	'name' => esc_html__( 'Vehicle Banner', 'autoroyal' ),
	'base' => 'autoroyal_vehicle_banner',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoRoyal vehicle banner', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Vehicle', 'autoroyal' ),
			'value' => array(
				__( 'Random', 'autoroyal' ) => 'random',
				__( 'Select Vehicle', 'autoroyal' ) => 'select_car',
			),
			'param_name' => 'car_selection_type',
			'std' => 'random',
		),
		array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Select Car', 'autoroyal' ),
            'param_name' => 'post_id',
            'admin_label' => true,
            'value' => $cars_array,
            'std' => '',
            'dependency' => array(
				'element' => 'car_selection_type',
				'value' => 'select_car',
			),
        ),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
	),

));

