<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_vehicles_map_func( $atts ) {

	extract( shortcode_atts( array(
        "height" => "600",
    	"css" => "",
   	), $atts ) );

	ob_start();

    wp_enqueue_script( 'populate-cars' );

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	?>

    <div class="autoroyal-vechile-collections <?php echo esc_attr($css_class); ?>">

    	<!-- map with car delears locations -->
        <section id="cd-locations" style="height: <?php echo esc_attr($height); ?>px"></section>
        <!-- /.map with car delears locations -->

        <div id="demoCars" style="display: none;">

        <?php 

            $search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
                'post_type'           => 'vehicle',
                'post_status'         => 'publish',
                'posts_per_page'      => -1,
                'meta_key'            => '_featured',
                'orderby'             => array('meta_value_num' => 'DESC', 'date' => 'DESC'),
                'ignore_sticky_posts' => 1,
                'meta_query' => array(
                    array(
                        'key' => '_sold',
                        'value' => 0
                    )
                )
            ) );

            $search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
            $cars_query  = new WP_Query;
            $cars        = $cars_query->query( $search_args );

            if ( $cars ) :
            
                foreach ( $cars as $car ) :

                    $car_ID = $car->ID; 

                    $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
                    $vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
                    $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
                    $vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
                    $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
                    $vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
                    $vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

                    $vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
                    if(!empty($vehicle_exterior_color)) {
                        $color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
                        $color_id   = $vehicle_exterior_color[0]->term_id;
                        $color_name = $vehicle_exterior_color[0]->name;
                    } else {
                        $color_name = "";
                    }

                    $vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

                    $vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
                    $vehicle_discount = esc_attr(get_post_meta($car_ID, 'vehicle_discount',true));

                    $vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
                    $vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
                    $price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));
                    $vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));

                    if($vehicle_discount == "on") {
                        $price_off = 100 - round(($price * 100)/$vehicle_retail_price);
                    } else {
                        $price_off = "0";
                    }

                    $vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
                    $vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
                    $vehicle_image_url = "";

                    if(!empty($vehicle_image_gallery[0]['url'])) {

                        $vehicle_image_url = $vehicle_image_gallery[0]['url'];

                    } elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

                        $vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

                    }

                    $vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
                    if(!empty($vehicle_cover_image)) {
                        $vehicle_image_url = $vehicle_cover_image;
                    }

                    $vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
                    $vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

                    $vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
                    $terms_vehicle_drive = $vehicle_drive[0]->name;

                    $total_photos = autoroyal_get_total_photos_by_car( $car_ID );

                    $address_latitude = "";
                    $address_longitude = "";

                    $website_type = get_option("autoroyal_webiste_type");
                    if( !empty($website_type) AND $website_type == "marketplace" ) {

                        //$user_id = get_the_author_meta('ID');
                        $user_id = get_post_field( 'post_author', $car_ID );
                        $address_latitude = get_user_meta( $user_id, 'dealer_address_latitude', true );
                        $address_longitude = get_user_meta( $user_id, 'dealer_address_longitude', true );

                    } else {

                        $vehicle_location = get_the_terms($car_ID, 'vehicle_location' );
                        if(!empty($vehicle_location)) {
                            $term_id = $vehicle_location[0]->term_id;
                            $address_latitude = get_term_meta( $term_id, 'vehicle_location_latitude', true );
                            $address_longitude = get_term_meta( $term_id, 'vehicle_location_longitude', true );
                        }

                    }

                    $vehicle_name = $vehicle_make_desc_init . " " . $vehicle_model;
                    $vehicle_name_final = strlen($vehicle_name) > 43 ? substr($vehicle_name,0,43)."..." : $vehicle_name;

                    $expense_currency = "";
                    $autoroyal_currency = get_option( 'autoroyal_currency' ); 
                    $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );

                ?>

                <div class="cd-offer-blk thumbnail bg-white sale-offer" data-lat="<?php echo esc_attr($address_latitude); ?>" data-long="<?php echo esc_attr($address_longitude); ?>" data-thumb="<?php if(!empty($vehicle_image_url)) { echo esc_url($vehicle_image_url); } ?>" data-pin="<?php echo get_template_directory_uri(); ?>/assets/images/map-pin.png" data-type="" data-link="<?php echo get_permalink( $car_ID ); ?>" data-title="<?php echo esc_attr($vehicle_name_final); ?>" data-year="<?php echo esc_attr($vehicle_year); ?>" data-price="<?php echo esc_attr($price); ?>" data-currency="<?php echo esc_attr($currency_symbol); ?>"></div>

            <?php endforeach; ?>

        <?php endif; ?>

        </div>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_vehicles_map', 'autoroyal_vehicles_map_func' );

vc_map( array(
  	'name' => esc_html__( 'Vehicles on Map', 'autoroyal' ),
	'base' => 'autoroyal_vehicles_map',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Vehicles on map', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Height in px', 'autoroyal' ),
            'param_name' => 'height',
            'value' => "600",
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

