<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_video_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'image' => '',
    	'video' => 'https://www.youtube.com/watch?v=DkeiKbqa02g',
   	), $atts ) );

	ob_start();

	$img_id = preg_replace( '/[^\d]/', '', $image );
	$link_image = wp_get_attachment_image_src( $img_id, 'full' );
	$img_src = $link_image[0];

	?>

	<video
      poster="<?php echo esc_url($img_src); ?>"
      id="video"
      class="youtube video-js vjs-default-skin video-16-9"
      controls
      width="640" height="264"
      data-setup='{ "techOrder": ["youtube"], "sources": [{ "type": "video/youtube", "src": "<?php echo esc_url($video); ?>"}], "youtube": { "ytControls": 2 } }'
    >
    </video>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_video', 'autoroyal_video_func' );

vc_map( array(
  	'name' => esc_html__( 'Youtube Video Block', 'autoroyal' ),
	'base' => 'autoroyal_video',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoRoyal youtube video block', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Video URL', 'autoroyal' ),
			'param_name' => 'video',
			'admin_label' => true,
			'value' => 'https://www.youtube.com/watch?v=DkeiKbqa02g',
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Poster Image', 'autoroyal' ),
			'param_name' => 'image',
			'value' => '',
			'description' => esc_html__( 'Select image from media library.', 'autoroyal' ),
		),
	),

));

