<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

?>

<div id="autoroyal-inventory">

	<div class="row">

		<div class="col-md-12">

			<div id="dealer-info-block" class="dealer-info-block">

				<div class="row">

					<?php

						global $wpdb, $wp_rewrite, $chefs_per_page, $total_cheefs, $total_pages, $current_page;

						$chefs_per_page = 12;

						$total_cheefs = 0;

						$current_page = max(1, get_query_var('paged'));

						$wpcook_cheefs = $wpdb->get_results( "SELECT post_author, count(*) as ct FROM `{$wpdb->prefix}posts` WHERE post_type = 'vehicle' and post_status = 'publish' group by post_author ORDER BY ct DESC");
						  
						$total_cheefs = count($wpcook_cheefs);

						$total_pages = ceil($total_cheefs/$chefs_per_page);

						$current_pos = -1; 

						foreach($wpcook_cheefs as $q) {	

							$current_pos++;

							if($current_page == 1) {
								$start_loop = 0;
							} else {
								$start_loop = ($current_page - 1) * $chefs_per_page;
							}

							$end_loop = $current_page * $chefs_per_page;

							if($current_pos >= $start_loop && $current_pos <= ($end_loop-1)) {

								$author_id = $q->post_author;

								$dealer_address_latitude = get_user_meta( $author_id, 'dealer_address_latitude', true );
								$dealer_address_longitude = get_user_meta( $author_id, 'dealer_address_longitude', true );
								$dealer_cover_image = get_user_meta( $author_id, 'dealer_cover_image', true );
								if(empty($dealer_cover_image)) {
									$dealer_cover_image = autoroyal_PLUGIN_URL . '/assets/images/dealer-placeholder.png';
									$dealer_cover_image_size = autoroyal_get_resized_image( $dealer_cover_image, 'dealer_block_image' );
								} else {
									$dealer_cover_image_size = autoroyal_get_resized_image( $dealer_cover_image, 'dealer_block_image' );
								}

								$dealer_map_pin = autoroyal_PLUGIN_URL . '/assets/images/map-icon.png';

						?>

						<div class="col-sm-6 col-lg-3">
			                <div class="dealer-card text-center bg-white rounded shadow" data-lat="<?php echo esc_attr($dealer_address_latitude); ?>" data-long="<?php echo esc_attr($dealer_address_longitude); ?>" data-thumb="<?php echo esc_url($dealer_cover_image); ?>" data-pin="<?php echo esc_url($dealer_map_pin); ?>" data-type="sale" data-link="<?php echo get_author_posts_url($author_id);?>" data-title=" ">
			                  	<img src="<?php echo esc_attr($dealer_cover_image_size); ?>" alt="dealer-shop-image" class="img-responsive">
			                  	<h4 class="text-capitalize">
			                    	<a href="<?php echo get_author_posts_url($author_id);?>"><?php echo get_the_author_meta('display_name', $author_id);?></a>
			                  	</h4>
			                  	<span><?php $total_vehicles = autoroyal_get_total_cars_all_by_user( $author_id ); echo esc_attr($total_vehicles); ?> <?php if( $total_vehicles == 1 ) { esc_html_e( 'vehicle', 'autoroyal' ); } else { esc_html_e( 'vehicles', 'autoroyal' ); } ?> <?php $hot = autoroyal_get_total_featured_cars_all_by_user( $author_id ); if($hot > 0) { ?>and <u><?php echo esc_attr($hot); ?> <?php esc_html_e( 'hot deals', 'autoroyal' ) ?></u><?php } ?></span>
			                </div>
		              	</div>

		            <?php } } ?>  
					  
					<?php  

						if($total_pages > 1) {  

			                $autoroyal_pagination = array(
								'base' => @add_query_arg('page','%#%'),
								'format' => '',
								'total' => $total_pages,
								'current' => $current_page,
								'prev_next' => true,
								'prev_text'    => __('←', 'autoroyal'),
								'next_text'    => __('→', 'autoroyal'),
								'type' => 'list',
								);

							if( $wp_rewrite->using_permalinks() )
								$autoroyal_pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg('s',get_pagenum_link(1) ) ) . 'page/%#%/', 'paged');

							if( !empty($wp_query->query_vars['s']) )
								$autoroyal_pagination['add_args'] = array('s'=>get_query_var('s'));

							echo '<div class="col-md-12"><nav class="autoroyal-pagination">' . paginate_links($autoroyal_pagination) . '</nav></div>'; 

						}
						
					?> 

				</div>

			</div>

		</div>

	</div>

</div>
