<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Shortcode_Submit_Lead class.
 */
class autoroyal_Shortcode_Submit_Lead {

	/**
	 * Inventory message
	 *
	 * @access private
	 * @var string
	 */
	private $lead_submit_message = '';
	private $lead_submit_status = '0';
	private $lead_delete_status = '0';
	private $lead_id = '';

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'wp', array( $this, 'shortcode_submit_lead_action_handler' ) );
		add_shortcode( 'autoroyal_submit_lead', array( $this, 'autoroyal_submit_lead' ) );
	}

	/**
	 * Handle actions which need to be run before the shortcode e.g. post actions
	 */
	public function shortcode_submit_lead_action_handler() {
		global $post;

		if ( is_page() && strstr( $post->post_content, '[autoroyal_submit_lead' ) ) {
			$this->lead_submit_handler();
		}
	}

	/**
	 * Handles actions on autoroyal dashboard
	 */
	public function lead_submit_handler() {

		if ( ! empty( $_REQUEST['action'] ) && ! empty( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'autoroyal_lead_actions' ) ) {

			$td_post_id = $_REQUEST['lead_id'];
			$action = $_REQUEST['action'];

			try {
				// Get lead
				$lead    = get_post( $td_post_id );

				// Check ownership
				if ( ! autoroyal_user_can_edit_car( $td_post_id ) ) {
					throw new Exception( __( 'Invalid ID', 'autoroyal' ) );
				}

				switch ( $action ) {
					case 'delete' :
						// Trash it
						wp_trash_post( $td_post_id );

						// Message
						$this->lead_submit_message = '<div class="car-manager-message">' . sprintf( __( '%s has been deleted', 'autoroyal' ), $lead->post_title ) . '</div>';
						$this->lead_delete_status = '1';

						break;
					default :
						do_action( 'autoroyal_leads_do_action_' . $action );
						break;
				}

				do_action( 'autoroyal_my_lead_do_action', $action, $td_post_id );

			} catch ( Exception $e ) {
				$this->lead_submit_message = '<div class="car-manager-error">' . $e->getMessage() . '</div>';
			}
		}

		if( 'POST' == $_SERVER['REQUEST_METHOD'] ) {

			if( isset( $_POST['submitLeadFunction_nonce'] ) && wp_verify_nonce( $_POST['submitLeadFunction_nonce'], 'submitLeadFunction_html' ) ){

				$td_post_id = $_POST['lead_id'];
				$action = $_POST['action_name'];

				$lead_first_name = esc_attr( $_POST['lead_first_name'] );
				$lead_middle_name = esc_attr( $_POST['lead_middle_name'] );
				$lead_last_name = esc_attr( $_POST['lead_last_name'] );

				$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

				if( !empty($td_post_id) AND ! autoroyal_user_can_edit_car( $td_post_id ) ) {

					$this->lead_submit_message = "<div class='car-manager-error'>" . __( 'Invalid ID', 'autoroyal' ). "</div>";
					$this->lead_submit_status = "1";

				} else {

					if( empty($td_post_id) ) {

						$my_post = array(
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'lead',
						  	'post_status'   => 'publish',
						);
						 
						// Insert the post into the database
						$td_post_id = wp_insert_post( $my_post );

						//
						$lead_first_name = esc_attr(get_post_meta($td_post_id, 'lead_first_name',true));
						$lead_middle_name = esc_attr(get_post_meta($td_post_id, 'lead_middle_name',true));
						$lead_last_name = esc_attr(get_post_meta($td_post_id, 'lead_last_name',true));

						$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

						$my_post = array(
							'ID'            => $td_post_id,
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'lead',
						  	'post_status'   => 'publish',
						);

						wp_update_post( $my_post );

					} else {

						//
						$lead_first_name = esc_attr(get_post_meta($td_post_id, 'lead_first_name',true));
						$lead_middle_name = esc_attr(get_post_meta($td_post_id, 'lead_middle_name',true));
						$lead_last_name = esc_attr(get_post_meta($td_post_id, 'lead_last_name',true));

						$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

						$my_post = array(
							'ID'            => $td_post_id,
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'lead',
						  	'post_status'   => 'publish',
						);

						wp_update_post( $my_post );

					}

					$this->lead_id = $td_post_id;

					// Lead Info
					update_post_meta($td_post_id, 'lead_first_name', sanitize_text_field($_POST['lead_first_name']));
					update_post_meta($td_post_id, 'lead_middle_name', sanitize_text_field($_POST['lead_middle_name']));
					update_post_meta($td_post_id, 'lead_last_name', sanitize_text_field($_POST['lead_last_name']));

					update_post_meta($td_post_id, 'lead_address_1', sanitize_text_field($_POST['lead_address_1']));
					update_post_meta($td_post_id, 'lead_address_2', sanitize_text_field($_POST['lead_address_2']));

					update_post_meta($td_post_id, 'lead_city', sanitize_text_field($_POST['lead_city']));
					update_post_meta($td_post_id, 'lead_state', sanitize_text_field($_POST['lead_state']));
					update_post_meta($td_post_id, 'lead_zip', sanitize_text_field($_POST['lead_zip']));

					update_post_meta($td_post_id, 'lead_home_phone', sanitize_text_field($_POST['lead_home_phone']));
					update_post_meta($td_post_id, 'lead_mobile_phone', sanitize_text_field($_POST['lead_mobile_phone']));
					update_post_meta($td_post_id, 'lead_work_phone', sanitize_text_field($_POST['lead_work_phone']));

					update_post_meta($td_post_id, 'lead_email', sanitize_text_field($_POST['lead_email']));

					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'lead_birth_date', sanitize_text_field($_POST['lead_birth_date']));
						update_post_meta($td_post_id, 'lead_social_security', sanitize_text_field($_POST['lead_social_security']));
					}

					update_post_meta($td_post_id, 'lead_driver_license_state', sanitize_text_field($_POST['lead_driver_license_state']));

					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'lead_driver_license_number', sanitize_text_field($_POST['lead_driver_license_number']));
					}

					update_post_meta($td_post_id, 'lead_driver_license_exp', sanitize_text_field($_POST['lead_driver_license_exp']));

					update_post_meta($td_post_id, 'lead_vehicle_id', sanitize_text_field($_POST['lead_vehicle_id']));
					$lead_vehicle_id = esc_attr(get_post_meta($td_post_id, 'lead_vehicle_id',true));
					$lead_vehicle_sku_own = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
					update_post_meta($td_post_id, 'lead_vehicle_sku', $lead_vehicle_sku_own);

					//
					$old_lead_status = get_the_terms($td_post_id, 'lead_status' );

					if(!empty($_POST['lead_status'])) {
						$lead_status = $_POST['lead_status'];
					} else {
						$lead_status = "";
					}
					update_post_meta($td_post_id, 'lead_status', $lead_status);

					$lead_history = array();
					$lead_history = get_post_meta( $td_post_id, 'lead_history', true );
					
					if( $lead_status != $old_lead_status[0]->term_id ) {
						$lead_status_name = get_term( $lead_status, 'lead_status' );
						$lead_history[] = array(
							'status' => $lead_status_name->name,
							'date' => strtotime(date("Y-m-d H:i:s"))
						);
						update_post_meta( $td_post_id, 'lead_history', $lead_history );
					}

					wp_set_post_terms( $td_post_id, $lead_status, "lead_status", false );

					//
					if(!empty($_POST['lead_up_type'])) {
						$lead_up_type = $_POST['lead_up_type'];
					} else {
						$lead_up_type = "";
					}
					wp_set_post_terms( $td_post_id, $lead_up_type, "lead_up_type", false );
					update_post_meta($td_post_id, 'lead_up_type', $lead_up_type);

					//
					if(!empty($_POST['lead_ad_source'])) {
						$lead_ad_source = $_POST['lead_ad_source'];
					} else {
						$lead_ad_source = "";
					}
					wp_set_post_terms( $td_post_id, $lead_ad_source, "lead_ad_source", false );
					update_post_meta($td_post_id, 'lead_ad_source', $lead_ad_source);

					//
					update_post_meta($td_post_id, 'lead_appointment_date', sanitize_text_field($_POST['lead_appointment_date']));
					update_post_meta($td_post_id, 'lead_appointment_time', sanitize_text_field($_POST['lead_appointment_time']));

					if( !empty($_POST['lead_appointment_date']) AND !empty($_POST['lead_appointment_time']) ) {
						$appointment_strtotime = strtotime($_POST['lead_appointment_date'] . " " . $_POST['lead_appointment_time']);
					} else {
						$appointment_strtotime = "";
					}
					update_post_meta($td_post_id, 'lead_appointment_strtotime', $appointment_strtotime);

					//
					update_post_meta($td_post_id, 'lead_comments', wp_kses($_POST['lead_comments'], true));
					update_post_meta($td_post_id, 'lead_notes', wp_kses($_POST['lead_notes'], true));

					// Current Residence
					update_post_meta($td_post_id, 'lead_current_residence_years', sanitize_text_field($_POST['lead_current_residence_years']));
					update_post_meta($td_post_id, 'lead_current_residence_months', sanitize_text_field($_POST['lead_current_residence_months']));
					update_post_meta($td_post_id, 'lead_current_residence_type', sanitize_text_field($_POST['lead_current_residence_type']));
					update_post_meta($td_post_id, 'lead_current_residence_price', sanitize_text_field($_POST['lead_current_residence_price']));

					// Previous Residence
					update_post_meta($td_post_id, 'lead_previous_residence', $_POST['lead_previous_residence']);
					update_post_meta($td_post_id, 'lead_previous_residence_years', sanitize_text_field($_POST['lead_previous_residence_years']));
					update_post_meta($td_post_id, 'lead_previous_residence_months', sanitize_text_field($_POST['lead_previous_residence_months']));
					update_post_meta($td_post_id, 'lead_previous_residence_type', sanitize_text_field($_POST['lead_previous_residence_type']));
					update_post_meta($td_post_id, 'lead_previous_residence_price', sanitize_text_field($_POST['lead_previous_residence_price']));

					// Previous2 Residence
					update_post_meta($td_post_id, 'lead_previous2_residence', $_POST['lead_previous2_residence']);
					update_post_meta($td_post_id, 'lead_previous2_residence_years', sanitize_text_field($_POST['lead_previous2_residence_years']));
					update_post_meta($td_post_id, 'lead_previous2_residence_months', sanitize_text_field($_POST['lead_previous2_residence_months']));
					update_post_meta($td_post_id, 'lead_previous2_residence_type', sanitize_text_field($_POST['lead_previous2_residence_type']));
					update_post_meta($td_post_id, 'lead_previous2_residence_price', sanitize_text_field($_POST['lead_previous2_residence_price']));

					// Previous3 Residence
					update_post_meta($td_post_id, 'lead_previous3_residence', $_POST['lead_previous3_residence']);
					update_post_meta($td_post_id, 'lead_previous3_residence_years', sanitize_text_field($_POST['lead_previous3_residence_years']));
					update_post_meta($td_post_id, 'lead_previous3_residence_months', sanitize_text_field($_POST['lead_previous3_residence_months']));
					update_post_meta($td_post_id, 'lead_previous3_residence_type', sanitize_text_field($_POST['lead_previous3_residence_type']));
					update_post_meta($td_post_id, 'lead_previous3_residence_price', sanitize_text_field($_POST['lead_previous3_residence_price']));

					// Previous4 Residence
					update_post_meta($td_post_id, 'lead_previous4_residence', $_POST['lead_previous4_residence']);
					update_post_meta($td_post_id, 'lead_previous4_residence_years', sanitize_text_field($_POST['lead_previous4_residence_years']));
					update_post_meta($td_post_id, 'lead_previous4_residence_months', sanitize_text_field($_POST['lead_previous4_residence_months']));
					update_post_meta($td_post_id, 'lead_previous4_residence_type', sanitize_text_field($_POST['lead_previous4_residence_type']));
					update_post_meta($td_post_id, 'lead_previous4_residence_price', sanitize_text_field($_POST['lead_previous4_residence_price']));

					// Current Employer
					update_post_meta($td_post_id, 'lead_current_employer', $_POST['lead_current_employer']);
					update_post_meta($td_post_id, 'lead_current_employer_years', sanitize_text_field($_POST['lead_current_employer_years']));
					update_post_meta($td_post_id, 'lead_current_employer_months', sanitize_text_field($_POST['lead_current_employer_months']));

					// Previous Employer
					update_post_meta($td_post_id, 'lead_previous_employer', $_POST['lead_previous_employer']);
					update_post_meta($td_post_id, 'lead_previous_employer_years', sanitize_text_field($_POST['lead_previous_employer_years']));
					update_post_meta($td_post_id, 'lead_previous_employer_months', sanitize_text_field($_POST['lead_previous_employer_months']));

					// Previous2 Employer
					update_post_meta($td_post_id, 'lead_previous2_employer', $_POST['lead_previous2_employer']);
					update_post_meta($td_post_id, 'lead_previous2_employer_years', sanitize_text_field($_POST['lead_previous2_employer_years']));
					update_post_meta($td_post_id, 'lead_previous2_employer_months', sanitize_text_field($_POST['lead_previous2_employer_months']));

					// Previous3 Employer
					update_post_meta($td_post_id, 'lead_previous3_employer', $_POST['lead_previous3_employer']);
					update_post_meta($td_post_id, 'lead_previous3_employer_years', sanitize_text_field($_POST['lead_previous3_employer_years']));
					update_post_meta($td_post_id, 'lead_previous3_employer_months', sanitize_text_field($_POST['lead_previous3_employer_months']));

					// Previous4 Employer
					update_post_meta($td_post_id, 'lead_previous4_employer', $_POST['lead_previous4_employer']);
					update_post_meta($td_post_id, 'lead_previous4_employer_years', sanitize_text_field($_POST['lead_previous4_employer_years']));
					update_post_meta($td_post_id, 'lead_previous4_employer_months', sanitize_text_field($_POST['lead_previous4_employer_months']));




					// Co Buyer
					// Current Residence
					update_post_meta($td_post_id, 'lead_cobuyer_current_residence', $_POST['lead_cobuyer_current_residence']);
					update_post_meta($td_post_id, 'lead_cobuyer_current_residence_years', sanitize_text_field($_POST['lead_cobuyer_current_residence_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_current_residence_months', sanitize_text_field($_POST['lead_cobuyer_current_residence_months']));
					update_post_meta($td_post_id, 'lead_cobuyer_current_residence_type', sanitize_text_field($_POST['lead_cobuyer_current_residence_type']));
					update_post_meta($td_post_id, 'lead_cobuyer_current_residence_price', sanitize_text_field($_POST['lead_cobuyer_current_residence_price']));

					// Previous Residence
					update_post_meta($td_post_id, 'lead_cobuyer_previous_residence', $_POST['lead_cobuyer_previous_residence']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous_residence_years', sanitize_text_field($_POST['lead_cobuyer_previous_residence_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous_residence_months', sanitize_text_field($_POST['lead_cobuyer_previous_residence_months']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous_residence_type', sanitize_text_field($_POST['lead_cobuyer_previous_residence_type']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous_residence_price', sanitize_text_field($_POST['lead_cobuyer_previous_residence_price']));

					// Previous2 Residence
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_residence', $_POST['lead_cobuyer_previous2_residence']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_residence_years', sanitize_text_field($_POST['lead_cobuyer_previous2_residence_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_residence_months', sanitize_text_field($_POST['lead_cobuyer_previous2_residence_months']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_residence_type', sanitize_text_field($_POST['lead_cobuyer_previous2_residence_type']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_residence_price', sanitize_text_field($_POST['lead_cobuyer_previous2_residence_price']));

					// Previous3 Residence
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_residence', $_POST['lead_cobuyer_previous3_residence']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_residence_years', sanitize_text_field($_POST['lead_cobuyer_previous3_residence_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_residence_months', sanitize_text_field($_POST['lead_cobuyer_previous3_residence_months']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_residence_type', sanitize_text_field($_POST['lead_cobuyer_previous3_residence_type']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_residence_price', sanitize_text_field($_POST['lead_cobuyer_previous3_residence_price']));

					// Previous4 Residence
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_residence', $_POST['lead_cobuyer_previous4_residence']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_residence_years', sanitize_text_field($_POST['lead_cobuyer_previous4_residence_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_residence_months', sanitize_text_field($_POST['lead_cobuyer_previous4_residence_months']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_residence_type', sanitize_text_field($_POST['lead_cobuyer_previous4_residence_type']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_residence_price', sanitize_text_field($_POST['lead_cobuyer_previous4_residence_price']));

					//

					// Current Employer
					update_post_meta($td_post_id, 'lead_cobuyer_current_employer', $_POST['lead_cobuyer_current_employer']);
					update_post_meta($td_post_id, 'lead_cobuyer_current_employer_years', sanitize_text_field($_POST['lead_cobuyer_current_employer_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_current_employer_months', sanitize_text_field($_POST['lead_cobuyer_current_employer_months']));

					// Previous Employer
					update_post_meta($td_post_id, 'lead_cobuyer_previous_employer', $_POST['lead_cobuyer_previous_employer']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous_employer_years', sanitize_text_field($_POST['lead_cobuyer_previous_employer_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous_employer_months', sanitize_text_field($_POST['lead_cobuyer_previous_employer_months']));

					// Previous2 Employer
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_employer', $_POST['lead_cobuyer_previous2_employer']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_employer_years', sanitize_text_field($_POST['lead_cobuyer_previous2_employer_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous2_employer_months', sanitize_text_field($_POST['lead_cobuyer_previous2_employer_months']));

					// Previous3 Employer
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_employer', $_POST['lead_cobuyer_previous3_employer']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_employer_years', sanitize_text_field($_POST['lead_cobuyer_previous3_employer_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous3_employer_months', sanitize_text_field($_POST['lead_cobuyer_previous3_employer_months']));

					// Previous4 Employer
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_employer', $_POST['lead_cobuyer_previous4_employer']);
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_employer_years', sanitize_text_field($_POST['lead_cobuyer_previous4_employer_years']));
					update_post_meta($td_post_id, 'lead_cobuyer_previous4_employer_months', sanitize_text_field($_POST['lead_cobuyer_previous4_employer_months']));

					// Lead Info
					update_post_meta($td_post_id, 'lead_cobuyer_first_name', sanitize_text_field($_POST['lead_cobuyer_first_name']));
					update_post_meta($td_post_id, 'lead_cobuyer_middle_name', sanitize_text_field($_POST['lead_cobuyer_middle_name']));
					update_post_meta($td_post_id, 'lead_cobuyer_last_name', sanitize_text_field($_POST['lead_cobuyer_last_name']));

					update_post_meta($td_post_id, 'lead_cobuyer_home_phone', sanitize_text_field($_POST['lead_cobuyer_home_phone']));
					update_post_meta($td_post_id, 'lead_cobuyer_mobile_phone', sanitize_text_field($_POST['lead_cobuyer_mobile_phone']));
					update_post_meta($td_post_id, 'lead_cobuyer_work_phone', sanitize_text_field($_POST['lead_cobuyer_work_phone']));

					update_post_meta($td_post_id, 'lead_cobuyer_email', sanitize_text_field($_POST['lead_cobuyer_email']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'lead_cobuyer_birth_date', sanitize_text_field($_POST['lead_cobuyer_birth_date']));
						update_post_meta($td_post_id, 'lead_cobuyer_social_security', sanitize_text_field($_POST['lead_cobuyer_social_security']));
					}

					update_post_meta($td_post_id, 'lead_cobuyer_driver_license_state', sanitize_text_field($_POST['lead_cobuyer_driver_license_state']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'lead_cobuyer_driver_license_number', sanitize_text_field($_POST['lead_cobuyer_driver_license_number']));
					}
					update_post_meta($td_post_id, 'lead_cobuyer_driver_license_exp', sanitize_text_field($_POST['lead_cobuyer_driver_license_exp']));

					//
					update_post_meta($td_post_id, 'lead_tradein_vehicle_year', sanitize_text_field($_POST['cq-year']));
					update_post_meta($td_post_id, 'lead_tradein_vehicle_make', sanitize_text_field($_POST['cq-make']));
					update_post_meta($td_post_id, 'lead_tradein_vehicle_model', sanitize_text_field($_POST['cq-model']));
					update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_id', sanitize_text_field($_POST['cq-trim']));
					update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_desc_init', sanitize_text_field($_POST['vehicle_trim_desc_init']));
					update_post_meta($td_post_id, 'lead_tradein_vehicle_make_desc_init', sanitize_text_field($_POST['vehicle_make_desc_init']));

					update_post_meta($td_post_id, 'lead_tradein_vehicle_vin', sanitize_text_field($_POST['lead_tradein_vehicle_vin']));
					update_post_meta($td_post_id, 'lead_tradein_vehicle_mileage', sanitize_text_field($_POST['lead_tradein_vehicle_mileage']));
					update_post_meta($td_post_id, 'lead_tradein_vehicle_color', sanitize_text_field($_POST['lead_tradein_vehicle_color']));

					update_post_meta($td_post_id, 'lead_tradein_payoff', sanitize_text_field($_POST['lead_tradein_payoff']));
					update_post_meta($td_post_id, 'lead_tradein_payoff_good', sanitize_text_field($_POST['lead_tradein_payoff_good']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_name', sanitize_text_field($_POST['lead_tradein_lien_holder_name']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_addres_1', sanitize_text_field($_POST['lead_tradein_lien_holder_addres_1']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_addres_2', sanitize_text_field($_POST['lead_tradein_lien_holder_addres_2']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_city', sanitize_text_field($_POST['lead_tradein_lien_holder_city']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_state', sanitize_text_field($_POST['lead_tradein_lien_holder_state']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_zip', sanitize_text_field($_POST['lead_tradein_lien_holder_zip']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_phone', sanitize_text_field($_POST['lead_tradein_lien_holder_phone']));
					update_post_meta($td_post_id, 'lead_tradein_lien_holder_acc_number', sanitize_text_field($_POST['lead_tradein_lien_holder_acc_number']));

					//
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'lead_bank_checking_account_number', sanitize_text_field($_POST['lead_bank_checking_account_number']));
						update_post_meta($td_post_id, 'lead_bank_checking_name', sanitize_text_field($_POST['lead_bank_checking_name']));
					}
					update_post_meta($td_post_id, 'lead_bank_checking_address_1', sanitize_text_field($_POST['lead_bank_checking_address_1']));
					update_post_meta($td_post_id, 'lead_bank_checking_address_2', sanitize_text_field($_POST['lead_bank_checking_address_2']));
					update_post_meta($td_post_id, 'lead_bank_checking_city', sanitize_text_field($_POST['lead_bank_checking_city']));
					update_post_meta($td_post_id, 'lead_bank_checking_state', sanitize_text_field($_POST['lead_bank_checking_state']));
					update_post_meta($td_post_id, 'lead_bank_checking_zip', sanitize_text_field($_POST['lead_bank_checking_zip']));
					update_post_meta($td_post_id, 'lead_bank_checking_phone', sanitize_text_field($_POST['lead_bank_checking_phone']));

					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'lead_bank_savings_account_number', sanitize_text_field($_POST['lead_bank_savings_account_number']));
						update_post_meta($td_post_id, 'lead_bank_savings_name', sanitize_text_field($_POST['lead_bank_savings_name']));
					}
					update_post_meta($td_post_id, 'lead_bank_savings_address_1', sanitize_text_field($_POST['lead_bank_savings_address_1']));
					update_post_meta($td_post_id, 'lead_bank_savings_address_2', sanitize_text_field($_POST['lead_bank_savings_address_2']));
					update_post_meta($td_post_id, 'lead_bank_savings_city', sanitize_text_field($_POST['lead_bank_savings_city']));
					update_post_meta($td_post_id, 'lead_bank_savings_state', sanitize_text_field($_POST['lead_bank_savings_state']));
					update_post_meta($td_post_id, 'lead_bank_savings_zip', sanitize_text_field($_POST['lead_bank_savings_zip']));
					update_post_meta($td_post_id, 'lead_bank_savings_phone', sanitize_text_field($_POST['lead_bank_savings_phone']));

					update_post_meta($td_post_id, 'lead_financing_preferred', sanitize_text_field($_POST['lead_financing_preferred']));
					update_post_meta($td_post_id, 'lead_financing_loan_term', sanitize_text_field($_POST['lead_financing_loan_term']));
					update_post_meta($td_post_id, 'lead_financing_amount_req', sanitize_text_field($_POST['lead_financing_amount_req']));
					update_post_meta($td_post_id, 'lead_financing_downpayment', sanitize_text_field($_POST['lead_financing_downpayment']));

					//
					$lead_first_name = esc_attr(get_post_meta($td_post_id, 'lead_first_name',true));
					$lead_middle_name = esc_attr(get_post_meta($td_post_id, 'lead_middle_name',true));
					$lead_last_name = esc_attr(get_post_meta($td_post_id, 'lead_last_name',true));

					$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

					$this->lead_submit_message = '<div class="car-manager-message">' . sprintf( __( '%s lead has been saved', 'autoroyal' ), $postNewTitle ) . '</div>';
					$this->lead_submit_status = "0";

				}

			}

		}

	}

	/**
	 * Shortcode which lists the logged in user's cars
	 */
	public function autoroyal_submit_lead( $atts ) {
		
		if ( ! is_user_logged_in() ) {
			ob_start();
			get_autoroyal_template( 'autoroyal-login.php' );
			return ob_get_clean();
		}

		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

		ob_start();

		// If doing an action, show conditional content if needed....
		if ( ! empty( $_REQUEST['action'] ) ) {
			$action = sanitize_title( $_REQUEST['action'] );

			// Show alternative content if a plugin wants to
			if ( has_action( 'autoroyal_submit_lead_content_' . $action ) ) {
				do_action( 'autoroyal_submit_lead_content_' . $action, $atts );

				return ob_get_clean();
			}
		}

		echo $this->lead_submit_message;

		if($this->lead_submit_status == 0) {

			get_autoroyal_template( 'autoroyal-submit-lead.php', array( 'lead_id' => $this->lead_id ) );

		}

		return ob_get_clean();
	}

}

new autoroyal_Shortcode_Submit_Lead();
