<?php 

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function autoroyal_vertical_search_filter( $shortcode_filter ) { ?>

	<?php

		$autoroyal_vehicles_query = autoroyal_vehicle_query();

		$page_url = "";

		if( isset($shortcode_filter) AND $shortcode_filter == 1 ) {

			$page_url = autoroyal_get_permalink( 'cars' );

		} else {

			$page_url = get_permalink();

		}

		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'touch-punch' );
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

		$results_status = 0;

		$make = "0";
		if ( isset( $_GET['make'] ) ) {

	        $make = $_GET['make'];

	        if($make != "0" ) {
	        	$results_status = 1;
	        }

	    }

	    $model = "0";
		if ( isset( $_GET['model'] ) ) {

	        $model = $_GET['model'];

	        if( $model != "0" ) {
	        	$results_status = 1;
	        }

	    }

	    $posts_per_page_set = get_option("autoroyal_posts_per_page");
		if( isset($posts_per_page_set) AND !empty($posts_per_page_set) AND $posts_per_page_set != 0 ) {
			
			$posts_per_page = $posts_per_page_set;

		} else {

			$posts_per_page = "12";

		}
		if ( isset( $_GET['posts_per_page'] ) AND !empty($_GET['posts_per_page']) ) {
            $posts_per_page = $_GET['posts_per_page'];
        }

	    $fuel_type = "";
		if ( isset( $_GET['fuel_type'] ) ) {

	        $fuel_type = $_GET['fuel_type'];

	        if( $fuel_type != "0" ) {
	        	$results_status = 1;
	        }

	    }

	    $price_max = autoroyal_get_max_price();
	    $price = $price_max;
		if ( isset( $_GET['price'] ) ) {

	        $price = $_GET['price'];

	        if( $price != $price_max ) {
	        	$results_status = 1;
	        }

	    }

	    $price_min = autoroyal_get_min_price();
		if ( isset( $_GET['price_min'] ) ) {

	        $price_min = $_GET['price_min'];

	        if( $price_min != $price_min ) {
	        	$results_status = 1;
	        }

	    }

	    $vehicle_min_year = autoroyal_get_min_year();
		if ( isset( $_GET['vehicle_year_min'] ) ) {

	        $vehicle_min_year = $_GET['vehicle_year_min'];

	        if( $vehicle_min_year != $vehicle_min_year ) {
	        	$results_status = 1;
	        }

	    }

	    $vehicle_year_max = autoroyal_get_max_year();
		if ( isset( $_GET['vehicle_year_max'] ) ) {

	        $vehicle_year_max = $_GET['vehicle_year_max'];

	        if( $vehicle_year_max != $vehicle_year_max ) {
	        	$results_status = 1;
	        }

	    }

	    $vehicle_condition = "";
		if ( isset( $_GET['vehicle_condition'] ) ) {

	        $vehicle_condition = $_GET['vehicle_condition'];
	        $results_status = 1;

	    }

	    $mileage_min = autoroyal_get_min_mileage();
	    $mileage_min_value = $mileage_min;
		if ( isset( $_GET['mileage_min'] ) ) {

	        $mileage_min_value = $_GET['mileage_min'];
	        
	        if( ( $mileage_min_value * 1000 ) != $mileage_min ) {
	        	$results_status = 1;
	        }

	    }

	    $mileage = autoroyal_get_max_mileage();
	    $mileage_value = $mileage;
		if ( isset( $_GET['mileage'] ) ) {

	        $mileage_value = $_GET['mileage'];
	        
	        if( ( $mileage_value * 1000 ) != $mileage ) {
	        	$results_status = 1;
	        }

	    }

	    // Transmission
	    $transmission = "";
	    if ( isset( $_GET['transmission'] ) AND !empty($_GET['transmission'] ) ) {

	        $transmission = $_GET['transmission'];
	        $results_status = 1;

	    }

	    // Body Style
	    $body_style = "";
	    if ( isset( $_GET['body_style'] ) AND !empty($_GET['body_style'] ) ) {

	        $body_style = $_GET['body_style'];
	        $results_status = 1;

	    }

	    $orderby = "default";
		if ( isset( $_GET['orderby'] ) AND !empty($_GET['orderby']) ) {
	        $orderby = $_GET['orderby'];
	    }

	    // Vehicle Exterior Color
	    $vehicle_exterior_color = array();
	    if ( isset( $_GET['vehicle_exterior_color'] ) AND !empty($_GET['vehicle_exterior_color'] ) ) {

	        $vehicle_exterior_color = $_GET['vehicle_exterior_color'];
	        $results_status = 1;

	    }

	    if( !empty($page_url)) {

	?> 

		<div id="autoroyal-vertical-car-holder">
		
			<form id="autoroyal-advance-search-form" class="autoroyal-vertical-car-filter" action="<?php echo esc_url($page_url); ?>" method="get">

				<div class="vertical-filter-fields-group pdbtm10">

					<div class="form-group"> 

						<div class="title"><?php esc_html_e('Make', 'autoroyal' ); ?></div>

						<select id="make" name="make" class="chosen-select">
							<option value="0" <?php selected( 0, $make ); ?>><?php esc_html_e('Any', 'autoroyal' ); ?></option>
							<?php 

								$total_cars_by_make = autoroyal_get_total_makes_and_models();

								if( !empty($total_cars_by_make) ) {

									sort($total_cars_by_make);
									$total = count($total_cars_by_make);

									for( $i = 0; $i <= ($total - 1); ++$i ){

					    	?>
							<option value="<?php echo esc_attr($total_cars_by_make[$i]['make_clean']); ?>" <?php selected( $total_cars_by_make[$i]['make_clean'], $make ); ?>><?php echo esc_attr($total_cars_by_make[$i]['make']); ?></option>
							<?php

									}

						    	}

							?>
						</select>

						<script>
			          		jQuery("document").ready(function(){

								// object literal holding data for option elements
								var Select_List_Data = {
								    
								    'model': { // name of associated select box
								        
								        // names match option values in controlling select box
								        <?php 

											$total_cars_by_make = autoroyal_get_total_makes_and_models();

											if( !empty($total_cars_by_make) ) {

												$total = count($total_cars_by_make);

												for( $i = 1; $i <= $total; ++$i ){

								    	?>'<?php echo esc_attr($total_cars_by_make[$i]['make_clean']); ?>': {
								        	text: [<?php 

														if( !empty($total_cars_by_make[$i]['model']) ) {

															$total_models = count($total_cars_by_make[$i]['model']);

															for( $j = 0; $j <= $total_models; ++$j ){

																if(!empty($total_cars_by_make[$i]['model'][$j])) {

											    	?>'<?php echo esc_attr($total_cars_by_make[$i]['model'][$j]); ?>',<?php
							            						}

															}

												    	}

													?>]
								        },
								       <?php

												}

									    	}

										?>
								    
								    }    
								};

								// removes all option elements in select box 
								// removeGrp (optional) boolean to remove optgroups
								function removeAllOptions(sel, removeGrp) {
								    var len, groups, par;
								    if (removeGrp) {
								        groups = sel.getElementsByTagName('optgroup');
								        len = groups.length;
								        for (var i=len; i; i--) {
								            sel.removeChild( groups[i-1] );
								        }
								    }
								    
								    len = sel.options.length;
								    for (var i=len; i; i--) {
								        par = sel.options[i-1].parentNode;
								        par.removeChild( sel.options[i-1] );
								    }
								}

								function appendDataToSelect(sel, obj) {

								    var f = document.createDocumentFragment();
								    var labels = [], group, opts;

								    if(obj != '0') {
								    
									    function addOptions(obj) {
									        var f = document.createDocumentFragment();
									        var o;

									        o = document.createElement('option');
								            o.appendChild( document.createTextNode( '<?php esc_html_e('Any', 'autoroyal' ); ?>' ) );
								            o.value = '0';
									        f.appendChild(o);
									        
									        for (var i=0, len=obj.text.length; i<len; i++) {
									            o = document.createElement('option');
									            o.appendChild( document.createTextNode( obj.text[i] ) );
									            
									            o.value = obj.text[i];

									            if( o.value == '<?php echo esc_attr($model); ?>' ) {
									            	o.setAttribute('selected', 'selected');
									            }
									            
									            f.appendChild(o);
									        }
									        
									        return f;
									    }
									    
									    if ( obj.text ) {
									        opts = addOptions(obj);
									        f.appendChild(opts);
									    } else {
									        for ( var prop in obj ) {
									            if ( obj.hasOwnProperty(prop) ) {
									                labels.push(prop);
									            }
									        }
									        
									        for (var i=0, len=labels.length; i<len; i++) {
									            group = document.createElement('optgroup');
									            group.label = labels[i];
									            f.appendChild(group);
									            opts = addOptions(obj[ labels[i] ] );
									            group.appendChild(opts);
									        }
									    }

									} else {

										var f = document.createDocumentFragment();
								        var o;

								        o = document.createElement('option');
							            o.appendChild( document.createTextNode( '<?php esc_html_e('Select a Make', 'autoroyal' ); ?>' ) );
							            o.value = '0';
								        f.appendChild(o);

									}
								    sel.appendChild(f);

								    $('.chosen-select').trigger("chosen:updated");

								}

								$('select#make').on('change', function(){

								   	var selected = $('select#make option:selected').val();

								   	// name of associated select box
								    var relName = 'model';
								    
								    // reference to associated select box 
								    var relList = this.form.elements[ relName ];
								    
								    // get data from object literal based on selection in controlling select box (this.value)
								    var obj = Select_List_Data[ relName ][ selected ];

								   	if(selected != '0') {
									    
									    // remove current option elements
									    removeAllOptions(relList, true);
									    
									    // call function to add optgroup/option elements
									    // pass reference to associated select box and data for new options
									    appendDataToSelect(relList, obj);

									} else {

										// remove current option elements
									    removeAllOptions(relList, true);
									    
									    // call function to add optgroup/option elements
									    // pass reference to associated select box and data for new options
									    appendDataToSelect(relList, '0');

									}

								});

								// populate associated select box as page loads
								(function() { // immediate function to avoid globals
								    
								    var form = document.forms['autoroyal-advance-search-form'];

								    // reference to controlling select box
								    var sel = form.elements['model'];
								    sel.selectedIndex = '<?php echo esc_attr($make); ?>';
								    selected = '<?php echo esc_attr($make); ?>';
								    
								    // name of associated select box
								    var relName = 'model';
								    // reference to associated select box
								    var rel = form.elements[ relName ];
								    
								    // get data for associated select box passing its name
								    // and value of selected in controlling select box
								    var data = Select_List_Data[ relName ][ selected ];

								   	if(selected != '0') {

								   		// remove current option elements
									    removeAllOptions(rel, true);
									    
									    // call function to add optgroup/option elements
									    // pass reference to associated select box and data for new options
									    appendDataToSelect(rel, data);

									} else {

										// remove current option elements
									    removeAllOptions(rel, true);
									    
									    // call function to add optgroup/option elements
									    // pass reference to associated select box and data for new options
									    appendDataToSelect(rel, '0');

									}
								    
								}());

						  	})
			          	</script>

					</div>

					<div class="form-group"> 

						<div class="title"><?php esc_html_e('Model', 'autoroyal' ); ?></div>

						<select id="model" name="model" class="chosen-select"> 
							<option value="0"><?php esc_html_e('Select a Make', 'autoroyal' ); ?></option>
						</select>

					</div> 

					<div class="form-group"> 

						<div class="title"><?php esc_html_e('Condition', 'autoroyal' ); ?></div>

						<select id="vehicle_condition" name="vehicle_condition" class="chosen-select">
							<option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
							<option value="Used" <?php selected( $vehicle_condition, "Used" ); ?>><?php esc_html_e('Used', 'autoroyal' ); ?></option>
							<option value="New" <?php selected( $vehicle_condition, "New" ); ?>><?php esc_html_e('New', 'autoroyal' ); ?></option>
						</select>

					</div>

					<div class="form-group"> 

						<div class="title"><?php esc_html_e('Fuel type', 'autoroyal' ); ?></div>

						<select id="fuel_type" name="fuel_type" class="chosen-select">
							
							<option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
							<?php

								$categories = get_categories( array('taxonomy' => 'vehicle_fuel_type', 'hide_empty' => true,  'parent' => 0) );

								foreach ($categories as $category) {

									$option = '<option value="'.$category->term_id.'" '. selected( $fuel_type, $category->term_id ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									echo $option;

								}

							?>

						</select>

					</div>

					<div class="form-group"> 

						<div class="title"><?php esc_html_e('Transmission', 'autoroyal' ); ?></div>

						<select id="transmission" name="transmission" class="chosen-select">
							
							<option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
							<?php

								$categories_transmission = get_categories( array('taxonomy' => 'vehicle_transmission', 'hide_empty' => true,  'parent' => 0) );

								foreach ($categories_transmission as $category_transmission) {

									$option_cat = '<option value="'.$category_transmission->term_id.'" '. selected( $category_transmission->term_id, $transmission) .' >';
									$option_cat .= $category_transmission->cat_name;
									$option_cat .= '</option>';

									echo $option_cat;

								}

							?>

						</select>

					</div>

					<div class="form-group"> 

						<div class="title"><?php esc_html_e('Body Style', 'autoroyal' ); ?></div>

						<select id="body_style" name="body_style" class="chosen-select">
							
							<option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
							<?php

								$categories_body_style = get_categories( array('taxonomy' => 'vehicle_body_style', 'hide_empty' => true,  'parent' => 0) );

								foreach ($categories_body_style as $category_body_style) {

									$option = '<option value="'.$category_body_style->term_id.'" '. selected( $category_body_style->term_id, $body_style) .' >';
									$option .= $category_body_style->cat_name;
									$option .= '</option>';

									echo $option;

								}

							?>

						</select>

					</div>

				</div>

				<div class="vertical-filter-fields-group pdbtm10">

					<div class="form-group custom-range"> 

						<div class="title">
                            <?php esc_html_e('Price', 'autoroyal' ); ?>
                        </div>

                        <div class="range-wrapper">
                            <a class="open_range">
                                <span id="price_up" class="filter-dynamic-data">
                                    <span class="filter-dynamic-data-min"></span> - <span class="filter-dynamic-data-max"></span>
                                </span>
                                <i class="material-icons">expand_more</i>
                            </a>
                            <div class="range-container">
                                <span class="filter-surrency-symbol"><?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); echo esc_attr($currency_symbol); } ?></span> 
                                <div class="range-holder">
                                    <div id="priceUpRange2" class="pull-right"></div>
                                </div>
                            </div>
                            <input type="hidden" id="priceUp2" name="price" readonly class="filter-meta">
                            <input type="hidden" id="priceUp1" name="price_min" readonly class="filter-meta">
                        </div>

			          	<div class="clearfix"></div>

			          	<script>
			          		jQuery("document").ready(function(){

			          			var carPriceMin = parseFloat(<?php echo autoroyal_get_min_price(); ?>);
			          			var carPriceMinValue = parseFloat(<?php echo $price_min; ?>);

					            var carPriceMax = parseFloat(<?php echo autoroyal_get_max_price(); ?>);
					            var carPriceMaxValue = parseFloat(<?php echo esc_attr($price); ?>);

					            var currency_symbol = jQuery(".filter-surrency-symbol").text();
					            var currency_pos = autoroyalSettings.currency_pos;
        						console.log(currency_pos);

								$( "#priceUpRange2" ).slider({
								    range: true,
								    min: carPriceMin,
								    max: carPriceMax,
								    values: [ carPriceMinValue, carPriceMaxValue ],
								    slide: function( event, ui ) {
								    	$( "#priceUp1" ).val( ui.values[ 0 ] );
								      	$( "#priceUp2" ).val( ui.values[ 1 ] );

								      	if( currency_pos == 'right' || currency_pos == 'right_space' ) {
                                            $( "#price_up .filter-dynamic-data-min" ).text( addCommas( ui.values[ 0 ] ) + currency_symbol );
                                            $( "#price_up .filter-dynamic-data-max" ).text( addCommas( ui.values[ 1 ] ) + currency_symbol );
                                        } else {
                                            $( "#price_up .filter-dynamic-data-min" ).text( currency_symbol + addCommas( ui.values[ 0 ] ) );
                                            $( "#price_up .filter-dynamic-data-max" ).text( currency_symbol + addCommas( ui.values[ 1 ] ) );
                                        }
								    }
							  	});
							  	$( "#priceUp1" ).val( $( "#priceUpRange2" ).slider( "values", 0 ) );
							  	$( "#priceUp2" ).val( $( "#priceUpRange2" ).slider( "values", 1 ) );

						      	if( currency_pos == 'right' || currency_pos == 'right_space' ) {
                                    $( "#price_up span.filter-dynamic-data-min" ).text( addCommas( $( "#priceUpRange2" ).slider( "values", 0 ) ) + currency_symbol );
                                    $( "#price_up span.filter-dynamic-data-max" ).text( addCommas( $( "#priceUpRange2" ).slider( "values", 1 ) ) + currency_symbol );
                                } else {
                                    $( "#price_up span.filter-dynamic-data-min" ).text( currency_symbol + addCommas( $( "#priceUpRange2" ).slider( "values", 0 ) ) );
                                    $( "#price_up span.filter-dynamic-data-max" ).text( currency_symbol + addCommas( $( "#priceUpRange2" ).slider( "values", 1 ) ) );
                                }

						      	$('#priceUpRange2').draggable();

							  	function addCommas(nStr) {
								    nStr += '';
								    var x = nStr.split('.');
								    var x1 = x[0];
								    var x2 = x.length > 1 ? '.' + x[1] : '';
								    var rgx = /(\d+)(\d{3})/;
								    while (rgx.test(x1)) {
								        x1 = x1.replace(rgx, '$1' + ' ' + '$2');
								    }
								    return x1 + x2;
								}

						  	})
			          	</script>

					</div>

					<div class="form-group custom-range"> 

						<div class="title">
                            <?php esc_html_e('Year', 'autoroyal' ); ?>
                        </div>

                        <div class="range-wrapper">
                            <a class="open_range">
                                <span id="year_up" class="filter-dynamic-data">
                                    <span class="filter-dynamic-data-min"></span> - <span class="filter-dynamic-data-max"></span>
                                </span>
                                <i class="material-icons">expand_more</i>
                            </a>
                            <div class="range-container">
                                <div class="range-holder">
                                    <div id="registrationRange2" class="pull-right"></div>
                                </div>
                            </div>
                            <input type="hidden" name="vehicle_year_max" id="cd-registration2" readonly class="filter-meta">
                            <input type="hidden" name="vehicle_year_min" id="cd-registration1" readonly class="filter-meta">
                        </div>

						<script>
			          		jQuery("document").ready(function(){

			          			var regYearMin = parseFloat(<?php echo autoroyal_get_min_year(); ?>);
			          			var regYearMinValue = parseFloat(<?php echo $vehicle_min_year; ?>);

					            var regYearMax = parseFloat(<?php echo autoroyal_get_max_year(); ?>);
					            var regYearMaxValue = parseFloat(<?php echo $vehicle_year_max; ?>);

								$( "#registrationRange2" ).slider({
								    range: true,
								    min: regYearMin,
								    max: regYearMax,
								    values: [ regYearMinValue, regYearMaxValue ],
								    slide: function( event, ui ) {
								      	$( "#cd-registration1" ).val( ui.values[ 0 ] );
								      	$( "#cd-registration2" ).val( ui.values[ 1 ] );

								      	$( "#year_up span.filter-dynamic-data-min" ).text( ui.values[ 0 ] );
								      	$( "#year_up span.filter-dynamic-data-max" ).text( ui.values[ 1 ] );
								    }
							  	});
							  	$( "#cd-registration1" ).val( $( "#registrationRange2" ).slider( "values", 0 ) );
							  	$( "#cd-registration2" ).val( $( "#registrationRange2" ).slider( "values", 1 ) );

							  	$( "#year_up span.filter-dynamic-data-min" ).text( $( "#registrationRange2" ).slider( "values", 0 ) );
						      	$( "#year_up span.filter-dynamic-data-max" ).text( $( "#registrationRange2" ).slider( "values", 1 ) );

						      	$('#registrationRange2').draggable();

						  	})
			          	</script>
					
					</div>

					<div class="form-group custom-range">

						<div class="title">
                            <?php esc_html_e('Mileage', 'autoroyal' ); ?>
                        </div>

                        <div class="range-wrapper">
                            <a class="open_range">
                                <span id="mileage_up" class="filter-dynamic-data">
                                    <span class="filter-dynamic-data-min"></span> - <span class="filter-dynamic-data-max"></span>
                                </span>
                                <i class="material-icons">expand_more</i>
                            </a>
                            <div class="range-container">
                                <div class="range-holder">
                                    <div id="mileageRange2" class="pull-right"></div>
                                </div>
                            </div>
                            <input type="hidden" name="mileage_min" id="cd-mileage1" readonly class="filter-meta">
                            <input type="hidden" name="mileage" id="cd-mileage2" readonly class="filter-meta">
                        </div>

                        <?php $mileage_min = autoroyal_get_min_mileage(); $mileage = autoroyal_get_max_mileage(); ?>

			          	<script>

			          		jQuery("document").ready(function(){

			          			var mileageMin = parseFloat(<?php echo esc_attr($mileage_min / 1000); ?>);
			          			var mileageMinValue = parseFloat(<?php echo $mileage_min_value; ?>);

					            var mileageMax = parseFloat(<?php echo esc_attr($mileage / 1000); ?>);
					            var mileageMaxValue = parseFloat(<?php echo esc_attr($mileage_value); ?>);

								$( "#mileageRange2" ).slider({
								    range: true,
								    min: Math.floor(mileageMin),
								    max: Math.ceil(mileageMax),
								    values: [ Math.floor(mileageMinValue), Math.ceil(mileageMaxValue) ],
								    slide: function( event, ui ) {
								      	$( "#cd-mileage1" ).val( ui.values[ 0 ] );
								      	$( "#cd-mileage2" ).val( ui.values[ 1 ] );

								      	$( "#mileage_up span.filter-dynamic-data-min" ).text( ui.values[ 0 ] + "K" );
								      	$( "#mileage_up span.filter-dynamic-data-max" ).text( ui.values[ 1 ] + "K" );
								    }
							  	});
							  	$( "#cd-mileage1" ).val( $( "#mileageRange2" ).slider( "values", 0 ) );
							  	$( "#cd-mileage2" ).val( $( "#mileageRange2" ).slider( "values", 1 ) );

							  	$( "#mileage_up span.filter-dynamic-data-min" ).text( $( "#mileageRange2" ).slider( "values", 0 ) + "K" );
						      	$( "#mileage_up span.filter-dynamic-data-max" ).text( $( "#mileageRange2" ).slider( "values", 1 ) + "K" );

						      	$('#mileageRange2').draggable();

						  	})
			          	</script>

					</div> 

				</div>

				<div class="vertical-filter-fields-group filter-search-button">

					<button type="submit" class="btn btn-default autoroyal-filter-button"><i class="fa fa-search" aria-hidden="true"></i> <?php esc_html_e('Search', 'autoroyal' ); ?></button> 
					<a class="btn btn-default autoroyal-filter-reset-button autoroyal-filter-button" href="<?php echo esc_url($page_url); ?>"><?php esc_html_e( 'Reset All', 'autoroyal' ); ?></a>

				</div>

				<div class="vertical-filter-fields-group">

					<input type="hidden" id="posts_per_page_filter" name="posts_per_page" value="<?php echo esc_attr($posts_per_page); ?>">
					<input type="hidden" id="orderby_filter" name="orderby" value="<?php echo esc_attr($orderby); ?>">
					<input type="hidden" id="filter_page" name="filter_page" value="1" />
					<input type="hidden" id="ajax_columns" name="ajax_columns" value="3" />
					<input type="hidden" id="view_type" name="view_type" value="grid" />
					<input type="hidden" name="action" value="autoroyal_ajax_filter" />

					<!-- car exterior colors -->
		            <div class="aside-blk colors">

		                <label><?php esc_html_e('Exterior color', 'autoroyal' ); ?></label>

		                <ul class="list-inline color-list multiple">

		                    <?php

		                        $vehicle_colors = $autoroyal_vehicles_query["vehicle_color"];
		                        foreach ( $vehicle_colors as $vehicle_colors_item ) {

		                            $vehicle_color_obj = get_term_by( 'id', $vehicle_colors_item, 'vehicle_exterior_color' );
		                            if(!empty($vehicle_color_obj)) {
		                                $vehicle_color_name = $vehicle_color_obj->name;
		                            } else {
		                                $vehicle_color_name = "";
		                            }

		                            $color      = autoroyal_get_term_color( $vehicle_colors_item, true );
		                            $color_id   = $vehicle_colors_item;
		                            $color_name = $vehicle_color_name;
		                            $color_type = get_term_meta( $vehicle_colors_item, 'color_type', true );

		                            ?>

		                                <?php if($color_type == "combined") { ?>

		                                    <li id="autoroyal-filter-vehicle-color-<?php echo esc_attr($vehicle_colors_item); ?>">
		                                        <button type="button" class="btn btn-default <?php if(in_array($vehicle_colors_item, $vehicle_exterior_color)) { echo "selected"; } ?>" data-toggle="tooltip" data-value="<?php echo esc_attr($vehicle_colors_item); ?>" data-placement="top" title="<?php esc_html_e('Combined', 'autoroyal' ); ?>"
		                                              style="background: #ebdec9;
		                                                     background: -moz-linear-gradient(left,  #ebdec9 0%, #ebdec9 50%, #000333 50%, #000333 100%);
		                                                     background: -webkit-linear-gradient(left,  #ebdec9 0%,#ebdec9 50%,#000333 50%,#000333 100%);
		                                                     background: linear-gradient(to right,  #ebdec9 0%,#ebdec9 50%,#000333 50%,#000333 100%);
		                                                     filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ebdec9', endColorstr='#000333',GradientType=1 );">
		                                        </button>
		                                    </li>

		                                <?php } elseif($color_type == "na") { ?>

		                                    <li id="autoroyal-filter-vehicle-color-<?php echo esc_attr($vehicle_colors_item); ?>">
		                                        <button type="button" class="btn btn-default <?php if(in_array($vehicle_colors_item, $vehicle_exterior_color)) { echo "selected"; } ?>" style="background-color: #cccccc" data-toggle="tooltip" data-value="<?php echo esc_attr($vehicle_colors_item); ?>" data-placement="top" title="<?php esc_html_e('N/A', 'autoroyal' ); ?>" ><?php esc_html_e('N/A', 'autoroyal' ); ?></button>
		                                    </li>

		                                <?php } else { ?>

		                                    <li id="autoroyal-filter-vehicle-color-<?php echo esc_attr($vehicle_colors_item); ?>">
		                                        <button type="button" class="btn btn-default <?php if(in_array($vehicle_colors_item, $vehicle_exterior_color)) { echo "selected"; } ?>" data-toggle="tooltip" data-value="<?php echo esc_attr($vehicle_colors_item); ?>" data-placement="top" title="<?php echo esc_attr($color_name); ?>" style="background-color: <?php echo esc_attr($color); ?>"></button>
		                                    </li>

		                                <?php } ?>

		                            <?php
		                        }

		                    ?>

		                    <div class="clearfix"></div>

		                </ul>

		                <div id="autoroyal-filter-color-wrapper">
		                    <?php 

		                        if(!empty($vehicle_exterior_color)) { 

		                            foreach ($vehicle_exterior_color as $vehicle_exterior_color_item) {

		                                echo '<input id="color-id-' . $vehicle_exterior_color_item . '" type="hidden" name="vehicle_exterior_color[]" value="' . $vehicle_exterior_color_item . '" />';

		                            }
		                        } 

		                    ?>
		                </div>

		            </div>

		        </div>

			</form>

			<div class="autoroyal-filter-results">

				<div class="autoroyal-search-filter-results-buttons">

					<a href="<?php echo esc_url($page_url); ?>" <?php if( $results_status == 1) { ?>style="display: inline-block;"<?php } ?>><?php esc_html_e( 'Reset', 'autoroyal' ); ?></a>
					
					<?php if ( ! is_user_logged_in() ) { ?>
					<span id="subscribe-filter">
						<i class="fa fa fa-spinner fa-spin"></i>
						<i class="fa fa-exclamation-triangle" aria-hidden="true"></i>
						<i class="fa fa-check" aria-hidden="true"></i>
						<?php esc_html_e( 'Subscribe', 'autoroyal' ); ?>
						<span id="subscribe-filter-email-holder">
							<input type="text" id="filter_email_x" value="" placeholder="<?php esc_attr_e( 'your email', 'autoroyal' ); ?>"/>
							<span id="subscribe-filter-save"><?php esc_html_e( 'Submit', 'autoroyal' ); ?></span>
							<span id="subscribe-filter-close"><?php esc_html_e( 'Close', 'autoroyal' ); ?></span>
						</span>
					</span>
					<?php } else { ?>
					<a id="subscribe-filter" href="#" <?php if( $results_status == 1) { ?>style="display: inline-block;"<?php } ?>>
						<i class="fa fa fa-spinner fa-spin"></i>
						<i class="fa fa-exclamation-triangle" aria-hidden="true"></i>
						<i class="fa fa-check" aria-hidden="true"></i>
						<?php esc_html_e( 'Subscribe', 'autoroyal' ); ?>
					</a>
					<?php } ?>

					<form action="<?php echo admin_url('admin-ajax.php'); ?>" method="post" id="subscribe-filter-form">
						<input type="hidden" id="filter_email" name="filter_email" value="<?php $current_user = wp_get_current_user(); echo esc_attr($current_user->user_email); ?>" />
						<input type="hidden" id="filter_make" name="filter_make" value="<?php echo esc_attr($make); ?>" />
	                    <input type="hidden" id="filter_model" name="filter_model" value="<?php echo esc_attr($model); ?>" />
	                    <input type="hidden" id="filter_fuel_type" name="filter_fuel_type" value="<?php echo esc_attr($fuel_type); ?>" />
	                    <input type="hidden" id="filter_price" name="filter_price" value="<?php echo esc_attr($price_max); ?>" />
	                    <input type="hidden" id="filter_year" name="filter_year" value="<?php echo esc_attr($vehicle_year_max); ?>" />
	                    <input type="hidden" id="filter_mileage" name="filter_mileage" value="<?php echo esc_attr($mileage); ?>" />
	                    <input type="hidden" id="filter_condition" name="filter_condition" value="<?php echo esc_attr($vehicle_condition); ?>" />
	                    <input type="hidden" name="action" value="autoroyal_subscribe_filter" />
	                </form>

				</div>

			</div>

		</div>

		<?php } else { ?>

			<?php esc_html_e( 'Point the search result page in settings.', 'autoroyal' ); ?>

		<?php } ?>

<?php } ?>