<?php
/**
 * Register meta boxes
 */

add_filter( 'rwmb_meta_boxes', 'autoroyal_register_meta_boxes' );

if( !function_exists( 'autoroyal_register_meta_boxes' ) ) {
    function autoroyal_register_meta_boxes() {

        // Make sure there's no errors when the plugin is deactivated or during upgrade
        if (!class_exists('RW_Meta_Box')) {
            return;
        }

        $meta_boxes = array();
        $prefix = 'autoroyal_';

        // Team Meta Box
        $meta_boxes[] = array(
            'id' => 'team-meta-box',
            'title' => esc_html__('Provide Team Member Information', 'autoroyal'),
            'pages' => array('team'),
            'context' => 'normal',
            'priority' => 'high',
            'tabs' => array(
                'team_details' => array(
                    'label' => esc_html__('Info', 'autoroyal'),
                    'icon' => 'dashicons-admin-home',
                )
            ),
            'tab_style' => 'top',
            'fields' => array(
                array(
                    'name' => esc_html__('Position', 'autoroyal'),
                    'id' => "{$prefix}position",
                    'desc' => esc_html__("Provide Team Member Position", "autoroyal"),
                    'type' => 'text',
                    'tab' => 'team_details',
                ),
                array(
                    'name' => esc_html__('Short Description', 'autoroyal'),
                    'id' => "{$prefix}description",
                    'desc' => esc_html__("Provide team member short description", "autoroyal"),
                    'type' => 'textarea',
                    'tab' => 'team_details',
                ),
                array(
                    'name' => esc_html__('Facebook URL', 'autoroyal'),
                    'id' => "{$prefix}facebook_url",
                    'desc' => esc_html__("Provide Team Member Facebook URL", "autoroyal"),
                    'type' => 'text',
                    'tab' => 'team_details',
                ),
                array(
                    'name' => esc_html__('Twitter URL', 'autoroyal'),
                    'id' => "{$prefix}twitter_url",
                    'desc' => esc_html__("Provide Team Member Twitter URL", "autoroyal"),
                    'type' => 'text',
                    'tab' => 'team_details',
                ),
                array(
                    'name' => esc_html__('Google Plus URL', 'autoroyal'),
                    'id' => "{$prefix}google_plus_url",
                    'desc' => esc_html__("Provide Team Member Google Plus URL", "autoroyal"),
                    'type' => 'text',
                    'tab' => 'team_details',
                ),
                array(
                    'name' => esc_html__('LinkedIn URL', 'autoroyal'),
                    'id' => "{$prefix}linked_in_url",
                    'desc' => esc_html__("Provide Team Member LinkedIn URL", "autoroyal"),
                    'type' => 'text',
                    'tab' => 'team_details',
                )
            )
        );

        // apply a filter before returning meta boxes
        $meta_boxes = apply_filters('framework_theme_meta', $meta_boxes);

        return $meta_boxes;

    }
}

?>