<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_dealers_func( $atts ) {

	extract( shortcode_atts( array(
        "amount" => "4",
    	"css" => "",
   	), $atts ) );

	ob_start();

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	?>

    <div class="autoroyal-latest-vehicles <?php echo esc_attr($css_class); ?>">

        <div class="row">

    	<?php

            global $wpdb, $wp_rewrite, $dealers_per_page, $total_dealers, $total_pages, $current_page;

            $dealers_per_page = $amount;

            $total_dealers = 0;

            $current_page = max(1, get_query_var('paged'));

            $autoroyal_dealers = $wpdb->get_results( "SELECT post_author, count(*) as ct FROM `{$wpdb->prefix}posts` WHERE post_type = 'vehicle' and post_status = 'publish' group by post_author ORDER BY ct DESC");
              
            $total_dealers = count($autoroyal_dealers);

            $total_pages = ceil($total_dealers/$dealers_per_page);

            $current_pos = -1; 

            foreach($autoroyal_dealers as $q) { 

                $current_pos++;

                if($current_page == 1) {
                    $start_loop = 0;
                } else {
                    $start_loop = ($current_page - 1) * $dealers_per_page;
                }

                $end_loop = $current_page * $dealers_per_page;

                if($current_pos >= $start_loop && $current_pos <= ($end_loop-1)) {

                    $author_id = $q->post_author;

                    $dealer_address_latitude = get_user_meta( $author_id, 'dealer_address_latitude', true );
                    $dealer_address_longitude = get_user_meta( $author_id, 'dealer_address_longitude', true );
                    $dealer_cover_image = get_user_meta( $author_id, 'dealer_cover_image', true );
                    if(empty($dealer_cover_image)) {
                        $dealer_cover_image = get_template_directory_uri() . '/assets/images/dealer-placeholder.jpg';
                        $dealer_cover_image_size = autoroyal_get_resized_image( $dealer_cover_image, 'autoroyal-team-avatar' );
                    } else {
                        $dealer_cover_image_size = autoroyal_get_resized_image( $dealer_cover_image, 'autoroyal-team-avatar' );
                    }

                    $dealer_map_pin = get_template_directory_uri() . '/assets/images/map-icon.png';

            ?>

            <div class="col-sm-6 col-lg-3">
                <div class="autoroyal-dealer-card" data-lat="<?php echo esc_attr($dealer_address_latitude); ?>" data-long="<?php echo esc_attr($dealer_address_longitude); ?>" data-thumb="<?php echo esc_url($dealer_cover_image); ?>" data-pin="<?php echo esc_url($dealer_map_pin); ?>" data-type="sale" data-link="<?php echo get_author_posts_url($author_id);?>" data-title=" ">
                    <a href="<?php echo get_author_posts_url($author_id);?>" >
                        <img src="<?php echo esc_attr($dealer_cover_image_size); ?>" alt="dealer-shop-image" class="img-responsive">
                        <div class="dealer-details-inner">
                            <h4 class="text-capitalize">
                                <?php echo get_the_author_meta('display_name', $author_id);?>
                            </h4>
                            <span><?php $total_vehicles = autoroyal_get_total_cars_all_by_user( $author_id ); echo esc_attr($total_vehicles); ?> <?php if( $total_vehicles == 1 ) { esc_html_e( 'vehicle', 'autoroyal' ); } else { esc_html_e( 'vehicles', 'autoroyal' ); } ?> <?php $hot = autoroyal_get_total_featured_cars_all_by_user( $author_id ); if($hot > 0) { ?>and <strong><?php echo esc_attr($hot); ?> <?php esc_html_e( 'hot deals', 'autoroyal' ) ?></strong><?php } ?></span>
                        </div>
                    </a>
                </div>
            </div>

        <?php } } ?>

        </div>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_dealers', 'autoroyal_dealers_func' );

vc_map( array(
  	'name' => esc_html__( 'Dealers', 'autoroyal' ),
	'base' => 'autoroyal_dealers',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Dealers', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Amount number of dealer', 'autoroyal' ),
            'param_name' => 'amount',
            'value' => "4",
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

