<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_icon_box_func( $atts ) {

	extract( shortcode_atts( array(
		'image' => '',
		'title' => 'Box Title',
		'icon_position' => 'top',
		'align' => 'left',
		'content_text' => '',
		'content_color' => '#696969',
		'icon_title_color' => '#2c425d',
		'icon_bg_color' => '#f0f7ff',
		'icon_color' => '#2C425D',
		'boxed' => '',
		'border_color' => '#f0f7ff',
    	'add_icon' => '',
    	'icon_source_type' => 'icon',
    	'icon_type' => 'material',
    	'icon_material' => '3d_rotation',
    	'icon_fontawesome' => '',
		'icon_openiconic' => '',
		'icon_typicons' => '',
		'icon_entypo' => '',
		'icon_linecons' => '',
		'icon_monosocial' => '',
		'icon_bg_type' => 'circle',
		'add_button' => 'false',
		'button_title' => '',
		'button_url' => '',
		'button_bg_color' => '#F0F7FF',
		'button_text_color' => '#2C425D',
		'button_bg_hover_color' => '#2C425D',
		'button_text_hover_color' => '#F0F7FF',
		'fade_direction' => '',
		'delay' => '0',
    	'css' => '',
   	), $atts ) );

	ob_start();

	$img_id = preg_replace( '/[^\d]/', '', $image );
	$link_image = wp_get_attachment_image_src( $img_id, 'full' );
	$img_src = $link_image[0];

	if ( 'true' === $add_icon ) {
		vc_icon_element_fonts_enqueue( $icon_type );

		if ( isset( ${'icon_' . $icon_type} ) ) {
			$icon_class = ${'icon_' . $icon_type};
		} else {
			$icon_class = 'fa fa-adjust';
		}
		if( $icon_type == "material" ) {
			$icon_class = 'material-icons';
		}
	}

	$class_to_filter = vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	$unique_id = uniqid();
	$button_class = "autoroyal_button_class_" . $unique_id;
	$icon_bg_class = "autoroyal_icon_bg_class_" . $unique_id;

	$bg_shape_1 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 500 481" style="enable-background:new 0 0 500 481;" xml:space="preserve">
		<path fill="'.$icon_bg_color.'" d="M495,242.7c0,128.1-103.9,232-232,232s-330.3-149.8-232-232C130,160,183.1,32.9,263,10.7
			C386.5-23.5,495,114.6,495,242.7z"/>
		</svg>';
	$bg_shape_1_encoded = base64_encode($bg_shape_1); 

	$bg_shape_2 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 500 426.8" style="enable-background:new 0 0 500 426.8;" xml:space="preserve">
		<path fill="'.$icon_bg_color.'" d="M182.7,419.3c46.5-4.5,183.3-15.5,233.8-9.8c128.5,14.5,81.1-236-13.5-329S161-16.1,73.9,72.6
			s-101,263.1,13.5,329C113.4,416.7,145.9,420.3,182.7,419.3"/>
		</svg>';
	$bg_shape_2_encoded = base64_encode($bg_shape_2); 

	$bg_shape_3 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 500 436.6" style="enable-background:new 0 0 500 436.6;" xml:space="preserve">
		<path fill="'.$icon_bg_color.'" d="M430.6,217.6c-192,148.8-95.3,212.8-212.8,212.8S5,335.1,5,217.6S100.3,4.8,217.8,4.8S622.6,68.8,430.6,217.6z"
			/>
		</svg>';
	$bg_shape_3_encoded = base64_encode($bg_shape_3); 

	$bg_shape_4 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 500 397" style="enable-background:new 0 0 500 397;" xml:space="preserve">
		<path fill="'.$icon_bg_color.'" d="M493.6,270.5c-3.1,26.3-9.5,47.4-18.2,64.3c-11.7,22.4-31.6,31.5-49.4,40.9c-5.1,2.7-10.5,5.1-16,7
			c-32.4,11.2-68.7,8.3-97.1,2.3c-20-4.2-40.3-6.7-60.6-7.7c-5.8-0.3-11.6-0.4-17.5-0.4c-9,0-170.7,3.1-210.1-76.7
			c-9.7-19.7-16.4-43.7-18.8-73C-1,144.5,36.3,90.1,84.3,54.6c90.9-67.2,215.4-64.4,305,4.6C448.9,105.1,504.7,174.7,493.6,270.5z"/>
		</svg>';
	$bg_shape_4_encoded = base64_encode($bg_shape_4); 

	if( $icon_position == 'top' ) {

	?>

	<div class="autoroyal-icon-box autoroyal-icon-box-centered-alt <?php if ( 'true' === $boxed ) { echo "autoroyal-card"; } ?> <?php echo esc_attr($align); ?> <?php echo esc_attr($css_class); ?>" style="border-color: <?php echo esc_attr($border_color); ?>;" <?php if(!empty($fade_direction)) { ?>data-aos="fade-<?php echo esc_attr($fade_direction); ?>"<?php } ?> data-aos-anchor-placement="top-center"  data-aos-delay="<?php echo esc_attr($delay); ?>">

		<?php if ( 'true' === $add_icon ) { ?>
		<div class="autoroyal-icon-box-icon icon-bg-<?php echo esc_attr($icon_bg_type); ?>">
			<?php if($icon_source_type == 'icon') { ?>
				<?php if( $icon_type == "material" ) { echo "<i class='" . wp_kses($icon_material, true) . "' style='background-color: ".$icon_bg_color."; color: ".$icon_color."'></i>"; } else { echo "<i class='" . wp_kses($icon_class, true) . " " . $icon_bg_class . "'></i>"; } ?>
			<?php } elseif ($icon_source_type == 'svg') { ?>
				<img src="<?php echo esc_url($img_src); ?>" alt="">
			<?php } ?>
		</div>
		<?php } ?>
		<div class="autoroyal-icon-box-content">
			<h4 style="color: <?php echo esc_attr($icon_title_color); ?>"><?php echo esc_attr($title); ?></h4>
			<p <?php if ( 'true' != $add_button ) { echo 'class="mb-0"'; } ?> style="color: <?php echo esc_attr($content_color); ?>"><?php echo esc_attr($content_text); ?></p>
		</div>
		<?php if ( 'true' === $add_button ) { ?>
		<a class="btn btn-icon-right <?php echo esc_attr($button_class); ?> mt-3" href="<?php echo esc_url($button_url); ?>"><?php echo esc_attr($button_title); ?> <i class="material-icons">trending_flat</i></a>
		<?php } ?>

	</div>

	<?php

	} else {

	?>

	<div class="icon-box-left-holder autoroyal-icon-box autoroyal-icon-box-centered-alt <?php if ( 'true' === $boxed ) { echo "autoroyal-card"; } ?> <?php echo esc_attr($align); ?> <?php echo esc_attr($css_class); ?>" style="border-color: <?php echo esc_attr($border_color); ?>;" <?php if(!empty($fade_direction)) { ?>data-aos="fade-<?php echo esc_attr($fade_direction); ?>"<?php } ?> data-aos-anchor-placement="top-center"  data-aos-delay="<?php echo esc_attr($delay); ?>">

		<?php if ( 'true' === $add_icon ) { ?>
		<div class="icon-box-left autoroyal-icon-box-icon icon-bg-<?php echo esc_attr($icon_bg_type); ?>">
			<?php if($icon_source_type == 'icon') { ?>
				<?php if( $icon_type == "material" ) { echo "<i class='" . wp_kses($icon_material, true) . "' style='background-color: ".$icon_bg_color."; color: ".$icon_color."'></i>"; } else { echo "<i class='" . wp_kses($icon_class, true) . " " . $icon_bg_class . "'></i>"; } ?>
			<?php } elseif ($icon_source_type == 'svg') { ?>
				<img src="<?php echo esc_url($img_src); ?>" alt="">
			<?php } ?>
		</div>
		<?php } ?>
		<div class="media-body">
			<div class="autoroyal-icon-box-content">
				<h4 style="color: <?php echo esc_attr($icon_title_color); ?>"><?php echo esc_attr($title); ?></h4>
				<p <?php if ( 'true' != $add_button ) { echo 'class="mb-0"'; } ?> style="color: <?php echo esc_attr($content_color); ?>"><?php echo esc_attr($content_text); ?></p>
			</div>
			<?php if ( 'true' === $add_button ) { ?>
			<a class="btn btn-icon-right <?php echo esc_attr($button_class); ?> mt-3" href="<?php echo esc_url($button_url); ?>"><?php echo esc_attr($button_title); ?> <i class="material-icons">trending_flat</i></a>
			<?php } ?>
		</div>

	</div>

	<?php

	}

	wp_enqueue_style(
		'autoroyal-custom-style-icon-box',
		get_template_directory_uri() . '/assets/css/custom-styles.css'
	);

	$custom_icon_bg_shape_1 = "

            .icon-bg-shape_1 .{$icon_bg_class} { 
                background-image: url('data:image/svg+xml;base64,{$bg_shape_1_encoded}') !important;
            }

    ";
    wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_icon_bg_shape_1 );

    $custom_icon_bg_shape_2 = "

            .icon-bg-shape_2 .{$icon_bg_class} { 
                background-image: url('data:image/svg+xml;base64,{$bg_shape_2_encoded}') !important;
            }

    ";
    wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_icon_bg_shape_2 );

    $custom_icon_bg_shape_3 = "

            .icon-bg-shape_3 .{$icon_bg_class} { 
                background-image: url('data:image/svg+xml;base64,{$bg_shape_3_encoded}') !important;
            }

    ";
    wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_icon_bg_shape_3 );

    $custom_icon_bg_shape_4 = "

            .icon-bg-shape_4 .{$icon_bg_class} { 
                background-image: url('data:image/svg+xml;base64,{$bg_shape_4_encoded}') !important;
            }

    ";
    wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_icon_bg_shape_4 );

	if(!empty($icon_bg_color)) {

        $custom_icon_bg_color = "

                .icon-bg-circle .{$icon_bg_class},
                .icon-bg-shape_1 .{$icon_bg_class},
                .icon-bg-shape_2 .{$icon_bg_class},
                .icon-bg-shape_3 .{$icon_bg_class},
                .icon-bg-shape_4 .{$icon_bg_class} { 
                    background-color: {$icon_bg_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_icon_bg_color );

    }

    if(!empty($icon_color)) {

        $custom_icon_color = "

                .icon-bg-circle .{$icon_bg_class},
                .icon-bg-shape_1 .{$icon_bg_class},
                .icon-bg-shape_2 .{$icon_bg_class},
                .icon-bg-shape_3 .{$icon_bg_class},
                .icon-bg-shape_4 .{$icon_bg_class} { 
                    color: {$icon_color} !important;
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_icon_color );

    }

    // Main Hover Color
    if( 'true' === $add_button ) {

    	if(!empty($button_bg_color)) {

	        $custom_button_bg_color = "

	                .{$button_class} { 
	                    background-color: {$button_bg_color};
	                    border-color: {$button_bg_color};
	                }

	                ";
	        wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_button_bg_color );

	    }

	    if(!empty($button_text_color)) {

	        $custom_button_text_color = "

	                .{$button_class} { 
	                    color: {$button_text_color};
	                }

	                ";
	        wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_button_text_color );

	    }

	    if(!empty($button_bg_hover_color)) {

	        $custom_button_bg_hover_color = "

	                .{$button_class}:hover { 
	                    background-color: {$button_bg_hover_color};
	                    border-color: {$button_bg_hover_color};
	                }

	                ";
	        wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_button_bg_hover_color );

	    }

	    if(!empty($button_text_hover_color)) {

	        $custom_button_text_hover_color = "

	                .{$button_class}:hover { 
	                    color: {$button_text_hover_color};
	                }

	                ";
	        wp_add_inline_style( 'autoroyal-custom-style-icon-box', $custom_button_text_hover_color );

	    }

    }

	return ob_get_clean();

}
add_shortcode( 'autoroyal_icon_box', 'autoroyal_icon_box_func' );

vc_map( array(
  	'name' => esc_html__( 'Icon Box', 'autoroyal' ),
	'base' => 'autoroyal_icon_box',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal icon box', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'autoroyal' ),
			'param_name' => 'title',
			'admin_label' => true,
			'value' => esc_html__( 'Card Title', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
		),
		array(
			'type' => 'textarea',
			'heading' => esc_html__( 'Content', 'autoroyal' ),
			'param_name' => 'content_text',
			'value' => '',
			'group' => esc_html__( 'Content', 'autoroyal' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon Position', 'autoroyal' ),
			'description' => esc_html__( 'Select icon display style.', 'autoroyal' ),
			'param_name' => 'icon_position',
			'value' => array(
				__( 'Top', 'autoroyal' ) => 'top',
				__( 'Left', 'autoroyal' ) => 'left',
			),
			'std' => 'top',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Content Align', 'autoroyal' ),
			'description' => esc_html__( 'Select content align.', 'autoroyal' ),
			'param_name' => 'align',
			'value' => array(
				__( 'Left', 'autoroyal' ) => 'left',
				__( 'Center', 'autoroyal' ) => 'center',
				__( 'Right', 'autoroyal' ) => 'right',
			),
			'dependency' => array(
				'element' => 'icon_position',
				'value' => 'top',
			),
			'std' => 'left',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Boxed', 'autoroyal' ),
			'param_name' => 'boxed',
			'group' => esc_html__( 'Style', 'autoroyal' ),
			'std' => 'false',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Border Color', 'autoroyal' ),
			'param_name' => 'border_color',
			'description' => esc_html__( 'Select color for boxed card border.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
			'std' => '#f0f7ff',
			'dependency' => array(
				'element' => 'boxed',
				'value' => 'true',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Title Color', 'autoroyal' ),
			'param_name' => 'icon_title_color',
			'description' => esc_html__( 'Select color for icon title.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
			'std' => '#2c425d',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Content Text Color', 'autoroyal' ),
			'param_name' => 'content_color',
			'description' => esc_html__( 'Select color for content text.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
			'std' => '#696969',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Add icon?', 'autoroyal' ),
			'param_name' => 'add_icon',
			'group' => esc_html__( 'Icon', 'autoroyal' ),
			'std' => 'false',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon Type', 'autoroyal' ),
			'value' => array(
				__( 'Icon', 'autoroyal' ) => 'icon',
				__( 'SVG Image', 'autoroyal' ) => 'svg',
			),
			'dependency' => array(
				'element' => 'add_icon',
				'value' => 'true',
			),
			'param_name' => 'icon_source_type',
			'description' => esc_html__( 'Select icon type.', 'autoroyal' ),
			'std' => 'icon',
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Image', 'autoroyal' ),
			'param_name' => 'image',
			'value' => '',
			'description' => esc_html__( 'Select image from media library.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
			'dependency' => array(
				'element' => 'icon_source_type',
				'value' => 'svg',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon library', 'autoroyal' ),
			'value' => array(
				__( 'Material Icons', 'autoroyal' ) => 'material',
				__( 'Font Awesome', 'autoroyal' ) => 'fontawesome',
				__( 'Open Iconic', 'autoroyal' ) => 'openiconic',
				__( 'Typicons', 'autoroyal' ) => 'typicons',
				__( 'Entypo', 'autoroyal' ) => 'entypo',
				__( 'Linecons', 'autoroyal' ) => 'linecons',
				__( 'Mono Social', 'autoroyal' ) => 'monosocial',
			),
			'param_name' => 'icon_type',
			'description' => esc_html__( 'Select icon library.', 'autoroyal' ),
			'dependency' => array(
				'element' => 'icon_source_type',
				'value' => 'icon',
			),
			'std' => 'material',
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_material',
			'value' => '3d_rotation', // default value to backend editor admin_label
			'settings' => array(
				'emptyIcon' => false, // default true, display an "EMPTY" icon?
				'type' => 'material',
				'iconsPerPage' => 4000, // default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'material',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
			
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_fontawesome',
			'value' => 'fa fa-info-circle',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'fontawesome',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'std' => 'fa fa-info-circle',
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_openiconic',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'openiconic',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'openiconic',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_typicons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'typicons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'typicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_entypo',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'entypo',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'entypo',
			),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_linecons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'linecons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'linecons',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_monosocial',
			'value' => 'vc-mono vc-mono-fivehundredpx', // default value to backend editor admin_label
			'settings' => array(
				'emptyIcon' => false, // default true, display an "EMPTY" icon?
				'type' => 'monosocial',
				'iconsPerPage' => 4000, // default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'monosocial',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Icon Background Color', 'autoroyal' ),
			'param_name' => 'icon_bg_color',
			'description' => esc_html__( 'Select color for icon background.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
			'std' => '#f0f7ff',
			'dependency' => array(
				'element' => 'icon_source_type',
				'value' => 'icon',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Icon Color', 'autoroyal' ),
			'param_name' => 'icon_color',
			'description' => esc_html__( 'Select color for icon.', 'autoroyal' ),
			'group' => esc_html__( 'Icon', 'autoroyal' ),
			'std' => '#2C425D',
			'dependency' => array(
				'element' => 'icon_source_type',
				'value' => 'icon',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon background', 'autoroyal' ),
			'value' => array(
				__( 'None', 'autoroyal' ) => 'none',
				__( 'Circle', 'autoroyal' ) => 'circle',
				__( 'Shape 1', 'autoroyal' ) => 'shape_1',
				__( 'Shape 2', 'autoroyal' ) => 'shape_2',
				__( 'Shape 3', 'autoroyal' ) => 'shape_3',
				__( 'Shape 4', 'autoroyal' ) => 'shape_4',
			),
			'param_name' => 'icon_bg_type',
			'description' => esc_html__( 'Select icon background type.', 'autoroyal' ),
			'dependency' => array(
				'element' => 'icon_source_type',
				'value' => 'icon',
			),
			'std' => 'default',
			'group' => esc_html__( 'Icon', 'autoroyal' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Add button?', 'autoroyal' ),
			'param_name' => 'add_button',
			'group' => esc_html__( 'Button', 'autoroyal' ),
			'std' => 'false',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Button Title', 'autoroyal' ),
			'param_name' => 'button_title',
			'admin_label' => true,
			'value' => esc_html__( 'Button Title', 'autoroyal' ),
			'group' => esc_html__( 'Button', 'autoroyal' ),
			'dependency' => array(
				'element' => 'add_button',
				'value' => 'true',
			),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Button URL', 'autoroyal' ),
			'param_name' => 'button_url',
			'admin_label' => true,
			'group' => esc_html__( 'Button', 'autoroyal' ),
			'dependency' => array(
				'element' => 'add_button',
				'value' => 'true',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Background Color', 'autoroyal' ),
			'param_name' => 'button_bg_color',
			'description' => esc_html__( 'Select color for button background.', 'autoroyal' ),
			'group' => esc_html__( 'Button', 'autoroyal' ),
			'std' => '#F0F7FF',
			'dependency' => array(
				'element' => 'add_button',
				'value' => 'true',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Text Color', 'autoroyal' ),
			'param_name' => 'button_text_color',
			'description' => esc_html__( 'Select color for button text.', 'autoroyal' ),
			'group' => esc_html__( 'Button', 'autoroyal' ),
			'std' => '#2C425D',
			'dependency' => array(
				'element' => 'add_button',
				'value' => 'true',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Background Hover Color', 'autoroyal' ),
			'param_name' => 'button_bg_hover_color',
			'description' => esc_html__( 'Select color for button hover background.', 'autoroyal' ),
			'group' => esc_html__( 'Button', 'autoroyal' ),
			'std' => '#2C425D',
			'dependency' => array(
				'element' => 'add_button',
				'value' => 'true',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Text Hover Color', 'autoroyal' ),
			'param_name' => 'button_text_hover_color',
			'description' => esc_html__( 'Select color for button text hover.', 'autoroyal' ),
			'group' => esc_html__( 'Button', 'autoroyal' ),
			'std' => '#F0F7FF',
			'dependency' => array(
				'element' => 'add_button',
				'value' => 'true',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Fade', 'autoroyal' ),
			'value' => array(
				__( 'None', 'autoroyal' ) => 'none',
				__( 'Fade Up', 'autoroyal' ) => 'up',
				__( 'Fade Down', 'autoroyal' ) => 'down',
				__( 'Fade Left', 'autoroyal' ) => 'left',
				__( 'Fade Right', 'autoroyal' ) => 'right',
			),
			'param_name' => 'fade_direction',
			'description' => esc_html__( 'Select fade direction.', 'autoroyal' ),
			'std' => 'none',
			'group' => esc_html__( 'Animation', 'autoroyal' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Animation Delay', 'autoroyal' ),
			'param_name' => 'delay',
			'value' => esc_html__( '0', 'autoroyal' ),
			'group' => esc_html__( 'Animation', 'autoroyal' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),

));

