<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_image_slideshow_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'image' => '',
    	'css' => '',
   	), $atts ) );

	ob_start();

	$class_to_filter = vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	$unique_id = uniqid();
    $gallery_class = "gallery_class_" . $unique_id;

	// Get all the Customized Theme Mods
    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $select_bg_color = "";
    if(strlen($MODS['select_bg'])>0) {
        $select_bg_color = $MODS['select_bg'];
    }

    if(!empty($select_bg_color)) {

        $bg_shape = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="60px" height="60px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve">
				<style type="text/css">
					.st0{fill:'.$select_bg_color.';}
				</style>
				<circle class="st0" cx="20" cy="20" r="5"/>
				<circle class="st0" cx="35" cy="35" r="5"/>
				<circle class="st0" cx="5" cy="35" r="5"/>
				<circle class="st0" cx="5" cy="5" r="5"/>
				<circle class="st0" cx="35" cy="5" r="5"/>
				<circle class="st0" cx="50" cy="20" r="5"/>
				<circle class="st0" cx="20" cy="50" r="5"/>
				<circle class="st0" cx="50" cy="50" r="5"/>
			</svg>';
        $bg_shape_encoded = base64_encode($bg_shape); 

    }

	?>

	<div class="owl-carousel owl-image-slider owl-carousel-single pr-0 <?php echo esc_attr($css_class); ?> <?php echo esc_attr($gallery_class); ?>" data-dots="true" data-autoheight="true">
      	<?php 
    		if(!empty($image)) { 
    			$image_ids = explode(',', $image); 
    			$current = 0;
    			foreach($image_ids as $image_id) { 
    				$current++;
    				$link_image = wp_get_attachment_image_src( $image_id, 'large' );
					$img_src = $link_image[0];
    	?>
    	<img src="<?php echo esc_url($img_src); ?>" alt="Image">
      	<?php 
          		} 
      		} 
      	?>
    </div>

	<?php

    if(!empty($select_bg_color)) {

    	wp_enqueue_style(
	        'autoroyal-custom-style-slideshow',
	        get_template_directory_uri() . '/assets/css/custom-styles.css'
	    );

	    $custom_bg_image = "

	            .owl-image-slider.{$gallery_class}:after { 
	                background-image: url('data:image/svg+xml;base64,{$bg_shape_encoded}');
	            }

	            ";
	    wp_add_inline_style( 'autoroyal-custom-style-slideshow', $custom_bg_image );

	}

	return ob_get_clean();

}
add_shortcode( 'autoroyal_image_slideshow', 'autoroyal_image_slideshow_func' );

vc_map( array(
  	'name' => esc_html__( 'Image Slideshow', 'autoroyal' ),
	'base' => 'autoroyal_image_slideshow',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoRoyal image slideshow', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'attach_images',
			'heading' => esc_html__( 'Images', 'autoroyal' ),
			'param_name' => 'image',
			'value' => '',
			'description' => esc_html__( 'Select images from media library.', 'autoroyal' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
	),

));

