<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_car_types_list_func( $atts ) {

	extract( shortcode_atts( array(
        "columns" => "4",
        "amount" => "all",
    	"css" => "",
   	), $atts ) );

	ob_start();

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $vehicles_search_url = "";
    $vehicles_search_url = get_option("autoroyal_search_vehicles_page_id");

	?>

    <div class="autoroyal-search-by-make <?php echo esc_attr($css_class); ?>">

        <div class="row">

                <?php

                $args = array(
                    'hierarchical' => 0,
                    'orderby' => 'count',
                    'order' => 'DESC',
                    'number' => $amount
                );

                $current = 0;
                $terms = get_terms( 'vehicle_body_style', $args );

                if ( $terms ) {

                    foreach ( $terms as $term ) {

                        $current++;

                    ?>

                    <div class="<?php if($columns == "4") { ?>col-lg-3<?php } else if($columns == "3") { ?>col-lg-4<?php } elseif($columns == "2") { ?>col-lg-6<?php } elseif($columns == "1") { ?>col-lg-12<?php } ?> col-md-12 col-sm-12">

                        <a href="<?php echo get_permalink( $vehicles_search_url ); ?>?body_style=<?php echo esc_attr($term->term_id); ?>">
                            <?php echo esc_attr($term->name); ?> <span class="text-muted"><?php echo esc_attr($term->count); ?></span>
                        </a>

                    </div>

                <?php }

                }

            ?>

        </div>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_car_types_list', 'autoroyal_car_types_list_func' );

vc_map( array(
  	'name' => esc_html__( 'Search by Body Style - List', 'autoroyal' ),
	'base' => 'autoroyal_car_types_list',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Search by body style', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Columns', 'autoroyal' ),
            'value' => array(
                __( '4 Columns', 'autoroyal' ) => '4',
                __( '3 Columns', 'autoroyal' ) => '3',
                __( '2 Columns', 'autoroyal' ) => '2',
                __( '1 Column', 'autoroyal' ) => '1',
            ),
            'param_name' => 'columns',
            'description' => esc_html__( 'Select the number of columns.', 'autoroyal' ),
            'std' => '4',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Amount', 'autoroyal' ),
            'param_name' => 'amount',
            'value' => 'all',
            'description' => esc_html__( 'Enter the amont (-1 for all).', 'autoroyal' ),
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

