<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('moveme_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'moveme_revslider_theme_setup9', 9 );
	function moveme_revslider_theme_setup9() {
		if (moveme_exists_revslider()) {
			add_action( 'wp_enqueue_scripts', 					'moveme_revslider_frontend_scripts', 1100 );
			add_filter( 'moveme_filter_merge_styles',			'moveme_revslider_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'moveme_filter_tgmpa_required_plugins','moveme_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'moveme_exists_revslider' ) ) {
	function moveme_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'moveme_revslider_tgmpa_required_plugins' ) ) {
	
	function moveme_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', moveme_storage_get('required_plugins'))) {
			$path = moveme_get_file_dir('plugins/revslider/revslider.zip');
			$list[] = array(
					'name' 		=> esc_html__('Revolution Slider', 'moveme'),
					'slug' 		=> 'revslider',
                    'version'	=> '6.2.23',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'moveme_revslider_frontend_scripts' ) ) {
	
	function moveme_revslider_frontend_scripts() {
		if (moveme_is_on(moveme_get_theme_option('debug_mode')) && moveme_get_file_dir('plugins/revslider/revslider.css')!='')
			wp_enqueue_style( 'moveme-revslider',  moveme_get_file_url('plugins/revslider/revslider.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'moveme_revslider_merge_styles' ) ) {
	
	function moveme_revslider_merge_styles($list) {
		$list[] = 'plugins/revslider/revslider.css';
		return $list;
	}
}
?>