<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */
?>

<div class="author_info author vcard" itemprop="author" itemscope itemtype="//schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php 
		$moveme_mult = moveme_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120*$moveme_mult ); 
		?>
	</div><!-- .author_avatar -->

	<div class="author_description"><?php echo esc_html__('About author', 'moveme'); ?>
		<h6 class="author_title" itemprop="name"><?php echo wp_kses_data(sprintf(__('%s', 'moveme'), '<span class="fn">'.get_the_author().'</span>')); ?></h6>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses(wpautop(get_the_author_meta( 'description' )), 'moveme_kses_content'); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
