<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0.10
 */

// Copyright area
$moveme_footer_scheme =  moveme_is_inherit(moveme_get_theme_option('footer_scheme')) ? moveme_get_theme_option('color_scheme') : moveme_get_theme_option('footer_scheme');
$moveme_copyright_scheme = moveme_is_inherit(moveme_get_theme_option('copyright_scheme')) ? $moveme_footer_scheme : moveme_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($moveme_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				// Replace {{...}} and [[...]] on the <i>...</i> and <b>...</b>
				$moveme_copyright = moveme_prepare_macros(moveme_get_theme_option('copyright'));
				if (!empty($moveme_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $moveme_copyright, $moveme_matches)) {
						$moveme_copyright = str_replace($moveme_matches[1], date(str_replace(array('{', '}'), '', $moveme_matches[1])), $moveme_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($moveme_copyright));
				}
			?></div>
		</div>
	</div>
</div>
