<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0.06
 */

$moveme_header_css = $moveme_header_image = '';
$moveme_header_video = moveme_get_header_video();
if (true || empty($moveme_header_video)) {
	$moveme_header_image = get_header_image();
	if (moveme_is_on(moveme_get_theme_option('header_image_override')) && apply_filters('moveme_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($moveme_cat_img = moveme_get_category_image()) != '')
				$moveme_header_image = $moveme_cat_img;
		} else if (is_singular() || moveme_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$moveme_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($moveme_header_image)) $moveme_header_image = $moveme_header_image[0];
			} else
				$moveme_header_image = '';
		}
	}
}

$moveme_header_id = str_replace('header-custom-', '', moveme_get_theme_option("header_style"));
$moveme_header_meta = get_post_meta($moveme_header_id, 'trx_addons_options', true);

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($moveme_header_id); 
						?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($moveme_header_id)));
						echo !empty($moveme_header_image) || !empty($moveme_header_video) 
							? ' with_bg_image' 
							: ' without_bg_image';
						if ($moveme_header_video!='') 
							echo ' with_bg_video';
						if ($moveme_header_image!='') 
							echo ' '.esc_attr(moveme_add_inline_css_class('background-image: url('.esc_url($moveme_header_image).');'));
						if (!empty($moveme_header_meta['margin']) != '') 
							echo ' '.esc_attr(moveme_add_inline_css_class('margin-bottom: '.esc_attr(moveme_prepare_css_value($moveme_header_meta['margin'])).';'));
						if (is_single() && has_post_thumbnail()) 
							echo ' with_featured_image';
						if (moveme_is_on(moveme_get_theme_option('header_fullheight'))) 
							echo ' header_fullheight trx-stretch-height';
						?> scheme_<?php echo esc_attr(moveme_is_inherit(moveme_get_theme_option('header_scheme')) 
														? moveme_get_theme_option('color_scheme') 
														: moveme_get_theme_option('header_scheme'));
						?>"><?php

	// Background video
	if (!empty($moveme_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('moveme_action_show_layout', $moveme_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>