<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

// Page (category, tag, archive, author) title

if ( moveme_need_page_title()  && !is_front_page()) {
	moveme_sc_layouts_showed('title', true);
	moveme_sc_layouts_showed('postmeta', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_left">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_left">
						<?php
						// Post meta on the single post
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$moveme_blog_title = moveme_get_blog_title();
							$moveme_blog_title_text = $moveme_blog_title_class = $moveme_blog_title_link = $moveme_blog_title_link_text = '';
							if (is_array($moveme_blog_title)) {
								$moveme_blog_title_text = $moveme_blog_title['text'];
								$moveme_blog_title_class = !empty($moveme_blog_title['class']) ? ' '.$moveme_blog_title['class'] : '';
								$moveme_blog_title_link = !empty($moveme_blog_title['link']) ? $moveme_blog_title['link'] : '';
								$moveme_blog_title_link_text = !empty($moveme_blog_title['link_text']) ? $moveme_blog_title['link_text'] : '';
							} else
								$moveme_blog_title_text = $moveme_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($moveme_blog_title_class); ?>"><?php
								$moveme_top_icon = moveme_get_category_icon();
								if (!empty($moveme_top_icon)) {
									$moveme_attr = moveme_getimagesize($moveme_top_icon);
									?><img src="<?php echo esc_url($moveme_top_icon); ?>" alt="<?php esc_attr__('Image', 'moveme')?>" <?php if (!empty($moveme_attr[3])) moveme_show_layout($moveme_attr[3]);?>><?php
								}
								echo wp_kses($moveme_blog_title_text, 'moveme_kses_content');
							?></h1>
							<?php
							if (!empty($moveme_blog_title_link) && !empty($moveme_blog_title_link_text)) {
								?><a href="<?php echo esc_url($moveme_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($moveme_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'moveme_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>