<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

// Header sidebar
$moveme_header_name = moveme_get_theme_option('header_widgets');
$moveme_header_present = !moveme_is_off($moveme_header_name) && is_active_sidebar($moveme_header_name);
if ($moveme_header_present) { 
	moveme_storage_set('current_sidebar', 'header');
	$moveme_header_wide = moveme_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($moveme_header_name) ) {
		dynamic_sidebar($moveme_header_name);
	}
	$moveme_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($moveme_widgets_output)) {
		$moveme_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $moveme_widgets_output);
		$moveme_need_columns = strpos($moveme_widgets_output, 'columns_wrap')===false;
		if ($moveme_need_columns) {
			$moveme_columns = max(0, (int) moveme_get_theme_option('header_columns'));
			if ($moveme_columns == 0) $moveme_columns = min(6, max(1, substr_count($moveme_widgets_output, '<aside ')));
			if ($moveme_columns > 1)
				$moveme_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($moveme_columns).' widget ', $moveme_widgets_output);
			else
				$moveme_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($moveme_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$moveme_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($moveme_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'moveme_action_before_sidebar' );
				moveme_show_layout($moveme_widgets_output);
				do_action( 'moveme_action_after_sidebar' );
				if ($moveme_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$moveme_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>