(function($) {

	//'use strict';

	$(document).ready( function() {

		// 

		jQuery("#locations-map").height( jQuery(".autoroyal-locations-cards-holder .row").height() - 30 );

		//

		var map;
		var marker;
		var markers = [];

		function initializeMap() {

			var w = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
			var isDraggable = w > 480 ? true : false;

			var latlng = new google.maps.LatLng( 40.7127837, -74.00594130000002 );
			var mapOptions = {
				zoom: 14,
				height: 500,
				mapTypeControl: false,
				scrollwheel: false,
				needsFit: true,
				isPanned: false,
				formIndex: 0,
				center: latlng,
				draggable: isDraggable,
			}

			map = new google.maps.Map(document.getElementById('locations-map'), mapOptions);

			/* marker loop */
			createMarkers();
		}; 

	    function createMarkers() {

	    	tdClearMap();

	    	var oms = new OverlappingMarkerSpiderfier(map, {
		      	markersWontMove: true,
		      	markersWontHide: true,
	          	keepSpiderfied: true
	        });
		    oms.addListener('unspiderfy', function(spidered, unspidered) {
		      	for (var i = 0; i < spidered.length; i++) {
			        spidered[i].setLabel("" + (i + 1));
			        spidered[i].setOptions({
			          	zIndex: i
			        });
		      	}
		    });

		    // Clusterer
		    var styles = [[{
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-1.png',
			    width: 62, height: 62,
			    opt_anchor: [15, 15],
			    textColor: '#ffffff',
			    textSize: 12
			}, {
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-2.png',
			    width: 82, height: 82,
			    opt_anchor: [20, 20],
			    textColor: '#ffffff',
			    textSize: 14
			}	, {
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-3.png',
			    width: 102, height: 102,
			    opt_anchor: [25, 25],
			    textColor: '#ffffff',
			    textSize: 16
			}, {
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-3.png',
			    width: 102, height: 102,
			    opt_anchor: [30, 30],
			    textColor: '#ffffff',
			    textSize: 16
			}]];

		    var markerCluster = new MarkerClusterer(map, markers, {styles: styles[0]});
	        minClusterZoom = 14;
			markerCluster.setMaxZoom(minClusterZoom);
			markerCluster.setMap(map);

	    	var infobox = new InfoBox({
		        disableAutoPan: false,
		        maxWidth: 202,
	        	pixelOffset: new google.maps.Size(-150, -325),
		        zIndex: null,
		        boxStyle: {
		        	background: "url('" + autoroyalSettings.url_theme + "/assets/images/infobox-bg-2.png') no-repeat",
		            opacity: 1,
		            width: "300px",
	            	height: "270px"
		        },
		        closeBoxMargin: "28px 26px 0px 0px",
		        closeBoxURL: "",
		        infoBoxClearance: new google.maps.Size(1, 1),
		        pane: "floatPane",
		        enableEventPropagation: false
		    });

	    	var self = this;
			var section = jQuery( '.autoroyal-locations-cards-holder' ).eq( map.formIndex );

			this.results = {};
			this.items = section.find( '.listing-item-data' );

			//var marker, i;
		    var bounds = new google.maps.LatLngBounds();

		    var totalListings = 0;

			jQuery.each( this.items, function(i, el) {

				totalListings++;

				var $el = jQuery(el);

				if ( ! ( $el.data( 'latitude' ) && $el.data( 'longitude' ) ) ) {
					return;
				}

				var data = {
					lat:      $el.data( 'latitude' ),
					lng:      $el.data( 'longitude' ),
					pin:      $el.data( 'pin' ),
					title:    $el.data( 'name' ),
					address:  $el.data( 'address' ),
					phone:    $el.data( 'phone' ),
					email:    $el.data( 'email' ),
				}

				var siteLatLng = new google.maps.LatLng( data.lat, data.lng );
		        var marker = new MarkerWithLabel({
		            position: siteLatLng,
		            map: map,
		            draggable: false,
		            title: data.title,
		            icon: data.pin,
		            html:  '<div class="marker-holder"><div class="marker-content"><span class="marker-listing-title">'+data.title+'</span><span class="marker-listing-data"><a href="//maps.google.com/maps?daddr='+data.lat+','+data.lng+'" target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i>'+data.address+'</a></span><span class="marker-listing-data"><a href="tel:'+data.phone+'"><i class="fa fa-phone" aria-hidden="true"></i>'+data.phone+'</a></span><span class="marker-listing-data"><a href="mailto:'+data.email+'"><i class="fa fa-envelope" aria-hidden="true"></i>'+data.email+'</a></span></div></div>'
		        });

		        google.maps.event.addListener(marker, "click", function () {
		        	infobox.close();
				  	infobox.setContent(this.html);
		            infobox.open(map, this);
				});		
		        google.maps.event.addListener(map, 'click', function() {
				    infobox.close();
				});

		        bounds.extend(siteLatLng);
		        markers.push(marker);
		        oms.addMarker(marker);
		        markerCluster.addMarker(marker);

			});

	        /* end marker loop */

	        map.fitBounds(bounds);

	        jQuery.fn.exists = function(){return this.length>0;}

	        if( jQuery(".autoroyal-locations-cards-holder").exists() ) {

		        jQuery('.listing-item-data').each(function(i) {
		        	jQuery(this).on('mouseenter', function() {
						google.maps.event.trigger(markers[i], 'click');
		                infobox.open(map,markers[i]);
					});
		            jQuery(this).on('mouseleave', function() {
						infobox.open(null,null);
					});
				});

		    }

			jQuery(window).resize(function() {
			    // (the 'map' here is the result of the created 'var map = ...' above)
			    google.maps.event.trigger(map, "resize");
			});

	    }

		function tdClearMap() {
	        //Loop through all the markers and remove
	        for (var i = 0; i < markers.length; i++) {
	            markers[i].setMap(null);
	        }
	        markers = [];
	    };

	    var $target = jQuery( '.autoroyal-locations-cards-holder' );

		if ( $target.length > 0 ) {

			initializeMap();

		}

   	});

})(jQuery);
