<?php 

function autoroyal_custom_styles() {

	wp_enqueue_style(
		'autoroyal-custom-style',
		get_template_directory_uri() . '/assets/css/custom-styles.css'
	);

	// Get all the Customized Theme Mods
    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    // Establish the Main Color
    $autoroyal_main_color = "";
    if(strlen($MODS['main_color'])>0) {
        $autoroyal_main_color = $MODS['main_color'];
    }

    // Establish the Main Hover Color
    $autoroyal_main_hover_color = "";
    if(strlen($MODS['main_hover_color'])>0) {
        $autoroyal_main_hover_color = $MODS['main_hover_color'];
    }

    // Establish the Main Color
    $autoroyal_second_color = "";
    if(strlen($MODS['second_color'])>0) {
        $autoroyal_second_color = $MODS['second_color'];
    }

    // Establish the Main Hover Color
    $autoroyal_second_hover_color = "";
    if(strlen($MODS['second_hover_color'])>0) {
        $autoroyal_second_hover_color = $MODS['second_hover_color'];
    }

    //
    $button_bg_color = "";
    if(strlen($MODS['button_bg_color'])>0) {
        $button_bg_color = $MODS['button_bg_color'];
    }

    //
    $button_text_color = "";
    if(strlen($MODS['button_text_color'])>0) {
        $button_text_color = $MODS['button_text_color'];
    }

    //
    $button_hover_bg_color = "";
    if(strlen($MODS['button_hover_bg_color'])>0) {
        $button_hover_bg_color = $MODS['button_hover_bg_color'];
    }

    //
    $button_hover_text_color = "";
    if(strlen($MODS['button_hover_text_color'])>0) {
        $button_hover_text_color = $MODS['button_hover_text_color'];
    }

    //
    $select_text = "";
    if(strlen($MODS['select_text'])>0) {
        $select_text = $MODS['select_text'];
    }

    //
    $select_bg = "";
    if(strlen($MODS['select_bg'])>0) {
        $select_bg = $MODS['select_bg'];
    }

    // Main Color
    if(!empty($autoroyal_main_color)) {

        $main_color = esc_attr($autoroyal_main_color);

        $custom_css_main_color = "
                body a,
                .sidebar-1-area .widget ul li a:hover,
                .site-footer a:hover,
                .footer-widgets .widget ul li a:hover,
                .navbar-nav .current-menu-item > a.nav-link,
                .navbar-nav .current_page_item > a.nav-link,
                .navbar-nav li:hover > .nav-link,
                .widget ul > li:before,
                .autoroyal-testimonials .rating,
                .footer-extra-info-social a:hover .fa,
                .compare-list-style li .fa,
                .autoroyal-car-check-availability a .fa,
                .autoroyal-open-car-page a .fa,
                .autoroyal-vehicle-content-info .nav-tabs .nav-link.active,
                .listing-content ul.checked li::before,
                #paymentCalc .form-group label span,
                .autoroyal-icon-box-icon,
                .autoroyal-search-by-price a:hover,
                .vehicles-style2-carousel .autoroyal-vehicle-block .heading:hover,
                .vehicles-style2-carousel .autoroyal-vehicle-block .heading:hover span,
                .vehicles-style2-carousel a.autoroyal-check-availability .fa,
                .autoroyal-grid-view-all .fa,
                body.autoroyal.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab>a,
                body.autoroyal.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active>a .fa,
                .autoroyal-location-block .fa,
                .autoroyal-location-block svg,
                .autoroyal-location-block .address .heading-font a:hover,
                .marker-content .marker-listing-data a:hover,
                .marker-content .marker-listing-data .fa,
                .autoroyal-body-style-link a:hover span,
                .reservation-total #totDayP,
                .reservation-total .totDayP,
                .autoroyal-team-carousel-content .heading:hover,
                .error-404-page .input-with-icon i,
                .navbar-nav li:hover > .nav-link .ft-menu-bold,
                .navbar-nav .current-menu-item > a.nav-link .ft-menu-bold,
                .navbar-nav .current_page_item > a.nav-link .ft-menu-bold,
                .autoroyal-vehicle-block .heading,
                .post-navigation h4 a:hover,
                blockquote:after { 
                    color: {$main_color};
                }

                .compare-vehicles-price,
                .star-rating span:before,
                .autoroyal-search-by-make a:hover {
                    color: {$main_color} !important;
                }

                .footer-extra-info,
                ul.products li.product .onsale,
                .single-product .product .onsale,
                .button.add_to_cart_button,
                .shop_table.shop_table_responsive.woocommerce-cart-form__contents button[type='submit'], 
                .form-row.place-order button[type='submit'], 
                .single-product .summary.entry-summary button[type='submit'],
                .cat-links .ar-badge a {
                    background-color: {$main_color} !important;
                }

                .checkout-button.button, 
                .price_slider_amount button[type='submit'] {
                    background-color: {$main_color} !important;
                    border-color: {$main_color} !important;
                }

                .btn-primary:after,
                .icon-mobile-menu span.icon-wrap:after,
                .autoroyal-top-header-menu li a,
                .autoroyal-top-header-menu li.social-link a:hover,
                .autoroyal-top-header-menu li.social-link a:hover:before,
                .autoroyal-top-header-menu li.social-link a:hover:after,
                .autoroyal-top-header-menu > li > a:before,
                .autoroyal-top-header-menu > li > a:after,
                .autoroyal-top-header-menu ul.sub-menu li a:hover,
                .color_2 .circle-clipper .circle:after,
                .autoroyal-listing-view-type a.active,
                .autoroyal-listing-view-type a:hover,
                ul.list-view-car-specs li:hover,
                ul.reserv-subtitle li:hover,
                .autoroyal-car-check-availability a,
                .autoroyal-open-car-page a,
                .autoroyal-car-check-availability-alt a:hover,
                .autoroyal-car-check-availability-alt a .fa,
                .autoroyal-fuel-consumption .fuel-consumption-icon span,
                .cd-dealer-address ul.list-unstyled li .fa,
                .cs-modal-header,
                .autoroyal-homepage-search-box .autoroyal-homepage-filter-button:after,
                .autoroyal-icon-box-style-boxed.autoroyal-icon-box-style-boxed-colored-bg-style-2:hover,
                .vehicles-style2-carousel .autoroyal-check-availability,
                .autoroyal-grid-view-all,
                body.autoroyal.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab>a:hover,
                body.autoroyal.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active>a,
                #place_car_reservation ul.nav-tabs li a.active i,
                #place_car_reservation ul.nav-tabs li a:hover i,
                .xdsoft_datetimepicker .xdsoft_calendar td.xdsoft_default, 
                .xdsoft_datetimepicker .xdsoft_calendar td.xdsoft_current, 
                .xdsoft_datetimepicker .xdsoft_timepicker .xdsoft_time_box>div>div.xdsoft_current,
                .autoroyal-rent-filter-checkbox-unit.checked span,
                .autoroyal-filter-heading:before,
                .autoroyal-team-social a:hover,
                .autoroyal-team-single-social a:hover,
                .autoroyal-team-social-style-2 a:hover,
                .custom-checkbox .custom-control-input:checked ~ .custom-control-label::before,
                .highlight,
                .tagcloud a,
                .main-menu > li > a:before,
                .preloader-wrapper div:after,
                .btn, input[type='submit'], 
                #autoroyal-dashboard .options_group input[type='submit'], 
                .button {
                    background-color: {$main_color};
                }

                .spinner-layer.color_2,
                .owl-dots .owl-dot:before,
                .autoroyal-price-box.featured-autoroyal-price-box,
                #place_car_reservation ul.nav-tabs li a.active:before,
                .footer-social.social-background-light svg:hover,
                .footer-social.social-background-dark svg:hover {
                    border-color: {$main_color};
                }

                .button.add_to_cart_button,
                .shop_table.shop_table_responsive.woocommerce-cart-form__contents button[type='submit'], 
                .form-row.place-order button[type='submit'], 
                .single-product .summary.entry-summary button[type='submit'] {
                    border-color: {$main_color} !important;
                }

                .autoroyal-specifications-title svg,
                .autoroyal-specifications-title svg .st0,
                .autoroyal-location-block svg,
                .autoroyal-rent-booking-dates .row .col-md-3 svg,
                .footer-social.social-background-light svg:hover path,
                .footer-social.social-background-dark svg:hover path {
                    fill: {$main_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_css_main_color );

    }

    // Main Hover Color
    if(!empty($autoroyal_main_hover_color)) {

        $main_hover_color = esc_attr($autoroyal_main_hover_color);

        $custom_css_main_hover_color = "
                body a:hover,
                .entry-meta a:hover, 
                .comments-link a:hover, 
                .edit-link a:hover,
                a:hover,
                .entry-meta a:hover, 
                .comments-link a:hover, 
                .edit-link a:hover,
                .autoroyal-compare-menu li a:hover,
                .autoroyal-compare-menu li a .fa-check-circle-o,
                a#autoroyal-advanced-options:hover,
                .autoroyal-vehicle-block .heading:hover { 
                    color: {$main_hover_color};
                }
                
                .entry-title a:hover { 
                    color: {$main_hover_color} !important; 
                }                

                input[type='button'], 
                input[type='reset'], 
                input[type='submit'] {
                    background-color: {$main_hover_color}; 
                    border-color: {$main_hover_color};
                }

                .checkout-button.button:hover, 
                .price_slider_amount button[type='submit']:hover {
                    background-color: {$main_hover_color} !important; 
                    border-color: {$main_hover_color} !important;
                }

                .autoroyal-top-header-menu li a:hover,
                .autoroyal-top-header-menu li a:hover:before,
                .autoroyal-top-header-menu li a:hover:after,
                .autoroyal-top-header-menu > li:last-child > a:before,
                .autoroyal-top-header-menu > li:last-child > a,
                #autoroyal-advance-search-form .bootstrap-select>.btn:hover,
                #autoroyal-listing-sort .bootstrap-select>.btn:hover,
                #place_car_reservation .bootstrap-select>.btn:hover,
                .autoroyal-homepage-search-box .autoroyal-homepage-filter-button:hover:after,
                .vehicles-style2-carousel .autoroyal-check-availability:hover,
                .autoroyal-grid-view-all:hover,
                .tagcloud a:hover,
                .autoroyal-car-check-availability a:hover,
                .autoroyal-open-car-page a:hover,
                .btn, input[type='submit']:hover, 
                #autoroyal-dashboard .options_group input[type='submit']:hover, 
                .button:hover {
                    background-color: {$main_hover_color}; 
                }

                .xdsoft_datetimepicker .xdsoft_calendar td:hover, 
                .xdsoft_datetimepicker .xdsoft_timepicker .xdsoft_time_box>div>div:hover,
                .button.add_to_cart_button:hover,
                .shop_table.shop_table_responsive.woocommerce-cart-form__contents button[type='submit']:hover, 
                .form-row.place-order button[type='submit']:hover, 
                .single-product .summary.entry-summary button[type='submit']:hover,
                .autoroyal-vehicle-block-image-wrapper a.autoroyal-vehicle-block-image-gallery:hover, 
                .autoroyal-vehicle-block-image-wrapper a.autoroyal-vehicle-block-image-quick-view:hover,
                .cat-links .ar-badge a:hover {
                    background-color: {$main_hover_color} !important; 
                }

                .button.add_to_cart_button:hover,
                .shop_table.shop_table_responsive.woocommerce-cart-form__contents button[type='submit']:hover, 
                .form-row.place-order button[type='submit']:hover, 
                .single-product .summary.entry-summary button[type='submit']:hover {
                    border-color: {$main_hover_color} !important;
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_css_main_hover_color );

    }

    // Main Hover Color
    if(!empty($button_bg_color)) {

        $button_bg_color_rgba = autoroyal_hex2rgba($button_bg_color, 0.1);

        $custom_button_bg_color = "
                .btn, 
                input[type='submit'], 
                #autoroyal-dashboard .options_group input[type='submit'],
                .vehicles-style2-carousel .autoroyal-check-availability, 
                .autoroyal-button,
                .autoroyal-homepage-search-box .autoroyal-homepage-filter-button,
                .autoroyal-vehicle-content-info .nav-tabs,
                .autoroyal-read-more a.btn,
                .autoroyal-page-title,
                input[type='button'],
                input[type='reset'], 
                input[type='submit'],
                body.autoroyal.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab>a .fa,
                table.car-manager-cars .btn.blue:not(.btn-outline) { 
                    background-color: {$button_bg_color};
                    border-color: {$button_bg_color};
                }

                .btn-invers-colors,
                .ar-badge p, 
                p.ar-badge {
                    color: {$button_bg_color} !important;
                }

                .carousel-indicators .thumbnail:hover, 
                #cd-item-slider .carousel-indicators .thumbnail.active {
                    box-shadow: 0 0 0 4px {$button_bg_color} inset;
                }

                .widget_price_filter .ui-slider .ui-slider-range { 
                    background-color: {$button_bg_color} !important;
                }

                .ui-slider-horizontal .ui-slider-handle {
                    border-color: {$button_bg_color} !important;
                }

                .ui-slider-horizontal .ui-slider-handle {
                    box-shadow: 0 0 0 4px {$button_bg_color_rgba};
                }

                .autoroyal-pagination>ul>li>span.current, 
                .autoroyal-pagination>ul>li>span.current:hover, 
                .autoroyal-pagination>ul>li>span.current:focus, 
                .autoroyal-pagination>ul>li>a.current, 
                .autoroyal-pagination>ul>li>a.current:hover, 
                .autoroyal-pagination>ul>li>a.current:focus,
                .autoroyal-pagination>ul>li>a:focus, 
                .autoroyal-pagination>ul>li>a:hover, 
                .autoroyal-pagination>ul>li>span:focus, 
                .autoroyal-pagination>ul>li>span:hover,
                .woocommerce-pagination>ul>li>span.current, 
                .woocommerce-pagination>ul>li>span.current:hover, 
                .woocommerce-pagination>ul>li>span.current:focus, 
                .woocommerce-pagination>ul>li>a.current, 
                .woocommerce-pagination>ul>li>a.current:hover, 
                .woocommerce-pagination>ul>li>a.current:focus,
                .woocommerce-pagination>ul>li>a:focus, 
                .woocommerce-pagination>ul>li>a:hover, 
                .woocommerce-pagination>ul>li>span:focus, 
                .woocommerce-pagination>ul>li>span:hover,
                .pagelinks .post-page-numbers:hover,
                .pagelinks .post-page-numbers.current {
                    background-color: {$button_bg_color};
                    border-color: {$button_bg_color} !important;
                }

                .autoroyal-pagination>ul>li>a, 
                .autoroyal-pagination>ul>li>span,
                .woocommerce-pagination>ul>li>a, 
                .woocommerce-pagination>ul>li>span {
                    color: {$button_bg_color} !important;
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_button_bg_color );

    }

    // Main Hover Color
    if(!empty($button_text_color)) {

        $custom_button_text_color = "
                .btn, 
                input[type='submit'], 
                #autoroyal-dashboard .options_group input[type='submit'],
                .vehicles-style2-carousel .autoroyal-check-availability, 
                .autoroyal-button,
                .autoroyal-homepage-search-box .autoroyal-homepage-filter-button,
                .autoroyal-read-more a.btn,
                input[type='button'],
                input[type='reset'], 
                input[type='submit'],
                table.car-manager-cars .btn.blue:not(.btn-outline) { 
                    color: {$button_text_color};
                }

                .btn-invers-colors,
                .ar-badge p, 
                p.ar-badge {
                    background-color: {$button_text_color} !important;
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_button_text_color );

    }

    // Main Hover Color
    if(!empty($button_hover_bg_color)) {

        $custom_button_hover_bg_color = "
                .btn:hover, 
                input[type='submit']:hover, 
                #autoroyal-dashboard .options_group input[type='submit']:hover,
                .vehicles-style2-carousel .autoroyal-check-availability:hover, 
                .autoroyal-button:hover,
                .autoroyal-homepage-search-box .autoroyal-homepage-filter-button:hover,
                .autoroyal-read-more a.btn:hover,
                input[type='button']:hover,
                input[type='reset']:hover, 
                input[type='submit']:hover,
                input[type='button']:focus,
                input[type='reset']:focus, 
                input[type='submit']:focus,
                input[type='button']:active,
                input[type='reset']:active, 
                input[type='submit']:active,
                table.car-manager-cars .btn.blue:not(.btn-outline):hover,
                table.car-manager-cars .btn.blue:not(.btn-outline):focus,
                table.car-manager-cars .btn.blue:not(.btn-outline):active { 
                    background-color: {$button_hover_bg_color};
                    border-color: {$button_hover_bg_color};
                }

                .btn-invers-colors:hover {
                    color: {$button_hover_bg_color} !important;
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_button_hover_bg_color );

    }

    // Main Hover Color
    if(!empty($button_hover_text_color)) {

        $custom_button_hover_text_color = "
                .btn:hover, 
                input[type='submit']:hover, 
                #autoroyal-dashboard .options_group input[type='submit']:hover,
                .vehicles-style2-carousel .autoroyal-check-availability:hover, 
                .autoroyal-button:hover,
                .autoroyal-homepage-search-box .autoroyal-homepage-filter-button:hover,
                .autoroyal-read-more a.btn:hover,
                input[type='button']:hover,
                input[type='reset']:hover, 
                input[type='submit']:hover,
                input[type='button']:focus,
                input[type='reset']:focus, 
                input[type='submit']:focus,
                input[type='button']:active,
                input[type='reset']:active, 
                input[type='submit']:active,
                table.car-manager-cars .btn.blue:not(.btn-outline):hover,
                table.car-manager-cars .btn.blue:not(.btn-outline):focus,
                table.car-manager-cars .btn.blue:not(.btn-outline):active { 
                    color: {$button_hover_text_color};
                }

                .btn-invers-colors:hover {
                    background-color: {$button_hover_text_color} !important;
                    border-color: {$button_hover_text_color} !important;
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_button_hover_text_color );

    }

    // Main Hover Color
    if(!empty($select_text)) {

        $custom_select_text = "
                .chosen-container .chosen-results li.highlighted,
                .owl-image-slider .owl-nav .owl-prev, 
                .owl-image-slider .owl-nav .owl-next, 
                .testimonials-carousel .owl-nav .owl-prev, 
                .testimonials-carousel .owl-nav .owl-next,
                .autoroyal-testimonials-holder .material-icons,
                .nav-classic .nav-link.active,
                .nav-classic .nav-link:hover,
                .nav .nav-item.icon-bg-circle i, 
                .nav .nav-item.icon-bg-shape_1 i, 
                .nav .nav-item.icon-bg-shape_2 i, 
                .nav .nav-item.icon-bg-shape_3 i, 
                .nav .nav-item.icon-bg-shape_4 i,
                ul.autoroyal-dashboard-menu li a:hover, 
                ul.autoroyal-dashboard-menu li.active a { 
                    color: {$select_text};
                }

                .owl-image-slider .owl-nav .owl-prev:hover, 
                .owl-image-slider .owl-nav .owl-next:hover, 
                .testimonials-carousel .owl-nav .owl-prev:hover, 
                .testimonials-carousel .owl-nav .owl-next:hover { 
                    background-color: {$select_text};
                }

                .chosen-container-single .chosen-single:hover, 
                .chosen-container.chosen-container-single.chosen-with-drop.chosen-container-active .chosen-single { 
                    color: {$select_text} !important;
                }

                .nav-classic .nav-link.active {
                    border-bottom-color: {$select_text};
                }

                ul.autoroyal-dashboard-menu li a:hover, 
                ul.autoroyal-dashboard-menu li.active a {
                    border-left-color: {$select_text};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_select_text );

    }

    // Main Hover Color
    if(!empty($select_bg)) {

        $custom_select_bg = "
                .chosen-container .chosen-results li.highlighted,
                .owl-image-slider .owl-nav .owl-prev, 
                .owl-image-slider .owl-nav .owl-next, 
                .testimonials-carousel .owl-nav .owl-prev, 
                .testimonials-carousel .owl-nav .owl-next,
                ul.autoroyal-dashboard-menu li a:hover, 
                ul.autoroyal-dashboard-menu li.active a { 
                    background-color: {$select_bg};
                }

                .owl-image-slider .owl-nav .owl-prev:hover, 
                .owl-image-slider .owl-nav .owl-next:hover, 
                .testimonials-carousel .owl-nav .owl-prev:hover, 
                .testimonials-carousel .owl-nav .owl-next:hover { 
                    color: {$select_bg};
                }

                .nav-classic .nav-link {
                    border-bottom-color: {$select_bg};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_select_bg );

    }

    // Main Hover Color
    if(!empty($autoroyal_second_color)) {

        $custom_autoroyal_second_color = "
                .autoroyal-vehicle-block-meta .btn.add-to-compare svg { 
                    fill: {$autoroyal_second_color};
                }

                .fantasy-themes-sidebar-car .widget-area .autoroyal-price-list {
                    background-color: {$autoroyal_second_color};
                }

                .autoroyal-car-check-availability-alt a,
                .autoroyal-car-check-availability-alt a:hover .fa {
                    color: {$autoroyal_second_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_autoroyal_second_color );

    }

    // Main Hover Color
    if(!empty($autoroyal_second_hover_color)) {

        $custom_autoroyal_second_hover_color = "
                .autoroyal-vehicle-block-meta .btn.add-to-compare:hover svg { 
                    fill: {$autoroyal_second_hover_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style', $custom_autoroyal_second_hover_color );

    }

}
add_action( 'wp_enqueue_scripts', 'autoroyal_custom_styles' );

