<?php 

	$cars_in_compare = array();
	if ( ! empty( $_COOKIE['autoroyal_compare_ids'] ) ) {
		$cars_in_compare = $_COOKIE['autoroyal_compare_ids'];
	}

	$car_ID = $template_args['post_id'];

	$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
	$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
	$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
	$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
	$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
	$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
	$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

	$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
	if(!empty($vehicle_exterior_color)) {
		$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
		$color_id   = $vehicle_exterior_color[0]->term_id;
		$color_name = $vehicle_exterior_color[0]->name;
	} else {
		$color_name = "";
		$color_id   = "";
	}

	$vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

	$vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
	$vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
	$vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
	$price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

	$vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
	$vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
	$vehicle_image_url = "";

	if(!empty($vehicle_image_gallery[0]['url'])) {

		$vehicle_image_url = $vehicle_image_gallery[0]['url'];

	} elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

		$vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

	}

	$vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
	if(!empty($vehicle_cover_image)) {
		$vehicle_image_url = $vehicle_cover_image;
	}

	$vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
	$vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

	$vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
	$terms_vehicle_drive = $vehicle_drive[0]->name;

	// Cars meta
	$vehicle_consumption_urban = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_urban',true));
	$vehicle_consumption_highway = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_highway',true));

	$terms_vehicle_fuel_type = "";
	$terms_vehicle_fuel_type_id = "";
	$term_vehicle_fuel_type = "";
	$term_vehicle_fuel_type_id = "";
	$vehicle_fuel_type = get_the_terms($car_ID, 'vehicle_fuel_type' );
	if ($vehicle_fuel_type && ! is_wp_error($vehicle_fuel_type)) :
		$term_slugs_arr_cat = array();
			foreach ($vehicle_fuel_type as $term_cat) {
				$term_vehicle_fuel_type = $term_cat->name;
				$term_vehicle_fuel_type_id = $term_cat->term_id;
			}
		$terms_vehicle_fuel_type = join( " ", $term_vehicle_fuel_type);
		$terms_vehicle_fuel_type_id = join( " ", $term_vehicle_fuel_type_id);
	endif;

	$terms_vehicle_transmission = "";
	$terms_vehicle_transmission_id = "";
	$term_vehicle_transmission = "";
	$term_vehicle_transmission_id = "";
	$vehicle_transmission = get_the_terms($car_ID, 'vehicle_transmission' );
	if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
		$term_slugs_arr_cat = array();
			foreach ($vehicle_transmission as $term_cat) {
				$term_vehicle_transmission = $term_cat->name;
				$term_vehicle_transmission_id = $term_cat->term_id;
			}
		$terms_vehicle_transmission = join( " ", $term_vehicle_transmission);
		$terms_vehicle_transmission_id = join( " ", $term_vehicle_transmission_id);
	endif;

	$vehicle_name = $vehicle_year . " " . $vehicle_make . " " . $vehicle_model;

	$vehicle_condition = esc_attr(get_post_meta($car_ID, 'vehicle_condition',true));

	//
	$terms_vehicle_body_style = "";
	$term_vehicle_body_style = "";
	$vehicle_body_style = get_the_terms($car_ID, 'vehicle_body_style' );
	if ($vehicle_body_style && ! is_wp_error($vehicle_body_style)) :
		$term_slugs_arr_cat = array();
			foreach ($vehicle_body_style as $term_cat) {
				$term_vehicle_body_style = $term_cat->term_id;
			}
		$terms_vehicle_body_style = join( " ", $term_vehicle_body_style);
	endif;

	$total_photos = autoroyal_count_photos( $car_ID );

?>

<div class="<?php if( $template_args['filter'] == 'vertical_left' OR $template_args['filter'] == 'vertical_right' ) { ?>col-lg-4<?php } else { ?>col-lg-3<?php } ?> col-md-4 col-sm-6 autoroyal-animated-blk" data-make="<?php echo esc_attr($vehicle_make); ?>" data-model="<?php echo esc_attr($vehicle_model); ?>" data-price="<?php if(!empty($price)) { echo esc_attr($price); } else { echo "0"; } ?>" data-year="<?php echo esc_attr($vehicle_year); ?>" data-mileage="<?php echo esc_attr($vehicle_mileage); ?>" data-condition="<?php echo esc_attr($vehicle_condition); ?>" data-fuel="<?php echo esc_attr($terms_vehicle_fuel_type_id); ?>" data-transmission="<?php echo esc_attr($terms_vehicle_transmission_id); ?>" data-bodystyle="<?php echo esc_attr($terms_vehicle_body_style); ?>" data-color="<?php if(!empty($color_id)) { echo esc_attr($color_id); } else { echo "0"; } ?>" data-favorite-grid="<?php echo esc_attr($car_ID); ?>"> 

	<div class="autoroyal-vehicle-block autoroyal-block-<?php echo esc_attr($template_args['block']); ?>">
		
		<div class="autoroyal-vehicle-block-image-wrapper">
			
			<?php if(!empty($vehicle_image_url)) { ?>
			<a data-open-id="car-gallery-<?php echo esc_attr($car_ID); ?>" class="autoroyal-vehicle-block-image-gallery open-album" href="#"><i class="fa fa-file-image-o" aria-hidden="true"></i><?php if($total_photos['total'] > "0") {?><span><?php echo esc_attr($total_photos['total']); ?></span><?php } ?></a>
			
			<?php foreach ( $total_photos['image'] as $image ) { ?>
			<a rel="car-gallery-<?php echo esc_attr($car_ID); ?>"  class="fancybox" href="<?php echo esc_url($image); ?>"></a>
			<?php } ?>

			<?php } ?>
			<a class="autoroyal-vehicle-block-image-quick-view" href="#" data-toggle="modal" data-target="#quick-view-block" data-car-id="<?php echo esc_attr($car_ID); ?>"><i class="fa fa-eye" aria-hidden="true"></i></a>

			<?php if(!empty($vehicle_image_url)) { $foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); ?>
			<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-thumbnail" style="background-image: url(<?php echo esc_url($foto_large); ?>);"></a>
			<?php } else { ?>
			<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-no-thumbnail">
				<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 538.043 538.043" style="enable-background:new 0 0 538.043 538.043;" xml:space="preserve"><path d="M526.745,312.866h-15.005c-3.706-18.736-10.307-44.359-20.792-57.941c-49.022-63.573-110.574-97.697-187.945-97.697
c-50.134,0-82.787,4.902-99.789,14.981c-2.295,1.363-9.063,5.369-27.344,42.135c-26.687,0.419-97.278,5.261-131.127,43.414
c-16.99,19.143-23.746,39.719-26.352,55.096h-7.078C5.058,312.854,0,317.924,0,324.177c0,6.241,5.058,11.323,11.311,11.323h5.655
c0.048,0.61,0.096,1.076,0.108,1.219c0.598,5.739,5.464,10.115,11.239,10.115h14.252c8.752,19.968,28.66,33.981,51.831,33.981
s43.079-14.013,51.855-33.981h215.982c8.74,19.968,28.66,33.981,51.832,33.981c23.172,0,43.091-14.013,51.832-33.981h38.165
c0.084,0,0.155,0,0.215,0c6.253,0,11.335-5.07,11.335-11.323h11.131c6.241,0,11.299-5.081,11.299-11.323
C538.044,317.924,532.986,312.866,526.745,312.866z M94.397,358.169c-18.724,0-33.968-15.232-33.968-33.981
c0-18.748,15.232-33.992,33.968-33.992c18.748,0,34.004,15.245,34.004,33.992C128.402,342.937,113.145,358.169,94.397,358.169z
M295.183,226.433c0,3.133-2.523,5.667-5.667,5.667h-87.964c-1.937,0-3.742-1.016-4.783-2.666
c-1.052-1.662-1.148-3.731-0.287-5.476c4.149-8.537,11.67-23.327,15.269-26.4c11.981-7.616,36.001-11.227,72.002-11.227
c1.961,0,3.922,0.024,5.906,0.06c3.061,0.072,5.512,2.595,5.512,5.667L295.183,226.433L295.183,226.433z M306.53,226.433V193.66
c0-1.614,0.705-3.157,1.901-4.233c1.208-1.076,2.81-1.614,4.424-1.399c39.863,4.687,70.519,17.875,82.058,35.272
c1.16,1.746,1.244,3.97,0.263,5.811c-0.968,1.841-2.905,2.989-4.998,2.989h-78.004C309.077,232.1,306.53,229.565,306.53,226.433z
M414.067,358.169c-18.724,0-33.98-15.232-33.98-33.981c0-18.748,15.244-33.992,33.98-33.992c18.736,0,33.98,15.245,33.98,33.992
C448.047,342.937,432.791,358.169,414.067,358.169z"/></svg>

			</a>
			<?php } ?>
		</div>

		<div class="autoroyal-vehicle-block-meta">

			<a class="heading" href="<?php echo get_permalink( $car_ID ); ?>"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></a>

			<ul class="autoroyal-vehicle-block-specs">

				<?php if(!empty($vehicle_mileage)) { ?>

					<li class="autoroyal-vehicle-transmission">

						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
				c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
				c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
				c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
				C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
				c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
				c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
				c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
				C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
				c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
				c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
				C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
				c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
				c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>


						<span><?php echo autoroyal_number($vehicle_mileage); ?> <?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?></span>

					</li>

				<?php } else { ?>

					<li class="autoroyal-vehicle-condition">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="48.997px" height="48.998px" viewBox="0 0 48.997 48.998" style="enable-background:new 0 0 48.997 48.998;" xml:space="preserve"><path d="M45.961,18.702c-0.033-0.038-0.061-0.075-0.1-0.112l-1.717-1.657c1.424-0.323,2.957-1.516,2.957-2.74
c0-1.426-1.979-1.932-3.668-1.932c-1.766,0-1.971,1.21-1.992,2.065l-4.43-4.271c-0.9-0.891-2.607-1.592-3.883-1.592H24.5h-0.002
h-8.63c-1.275,0-2.981,0.701-3.882,1.592l-4.429,4.271c-0.023-0.855-0.228-2.065-1.992-2.065c-1.691,0-3.669,0.506-3.669,1.932
c0,1.224,1.534,2.417,2.958,2.74l-1.717,1.657c-0.039,0.037-0.066,0.074-0.1,0.112C1.2,20.272,0,23.184,0,25.297v6.279
c0,1.524,0.601,2.907,1.572,3.938v2.435c0,1.424,1.192,2.585,2.658,2.585h3.214c1.466,0,2.657-1.159,2.657-2.585v-0.623h14.397
H24.5h14.396v0.623c0,1.426,1.19,2.585,2.658,2.585h3.213c1.467,0,2.657-1.161,2.657-2.585v-2.435
c0.972-1.031,1.572-2.414,1.572-3.938v-6.279C48.998,23.184,47.798,20.272,45.961,18.702z M13.613,11.953
c0.623-0.519,1.712-0.913,2.255-0.913h8.63H24.5h8.63c0.543,0,1.632,0.394,2.255,0.913l5.809,5.63H24.5h-0.002H7.805L13.613,11.953
z M1.993,24.347c0-1.546,1.21-2.801,2.704-2.801c1.493,0,6.372,2.864,6.372,4.41s-4.879,1.188-6.372,1.188
C3.203,27.144,1.993,25.894,1.993,24.347z M10.102,34.573H9.587H9.072l-3.055,0.005c-0.848-0.264-1.446-0.572-1.869-0.903
c-0.214-0.167-0.378-0.341-0.506-0.514c-0.129-0.175-0.223-0.347-0.284-0.519c-0.38-1.074,0.405-2.061,0.405-2.061h5.214
l3.476,3.99L10.102,34.573L10.102,34.573z M31.996,34.575H24.5h-0.002h-7.496c-1.563,0-2.832-1.269-2.832-2.831h10.328H24.5h10.328
C34.828,33.308,33.559,34.575,31.996,34.575z M32.654,29.812H24.5h-0.002h-8.154c-1.7,0-3.08-2.096-3.08-4.681h11.234H24.5h11.234
C35.734,27.717,34.354,29.812,32.654,29.812z M45.641,32.644c-0.062,0.172-0.156,0.344-0.285,0.518
c-0.127,0.173-0.291,0.347-0.506,0.514c-0.422,0.331-1.021,0.641-1.869,0.903l-3.055-0.005h-0.515h-0.515h-2.353l3.478-3.99h5.213
C45.234,30.583,46.02,31.568,45.641,32.644z M44.301,27.144c-1.492,0-6.371,0.356-6.371-1.188s4.879-4.41,6.371-4.41
c1.494,0,2.704,1.255,2.704,2.801C47.005,25.892,45.795,27.144,44.301,27.144z"/></svg>

						<span><?php echo esc_attr($vehicle_condition); ?></span>
					</li>

				<?php } ?>

				<?php if(!empty($terms_vehicle_transmission)) { ?>

					<li class="autoroyal-vehicle-transmission">

						<svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"/><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"/><circle cx="70" cy="70" r="4"/></svg>

						<span><?php echo esc_attr($terms_vehicle_transmission); ?></span>

					</li>

				<?php } ?>

			</ul>

			<ul class="autoroyal-vehicle-block-specs hidden">

				<?php if( !empty($vehicle_consumption_urban) AND !empty($vehicle_consumption_highway) ) { ?>

					<li class="autoroyal-vehicle-fuel-type">

						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="200" width="200" fill="#000000" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve"><g><path d="M89.417,36.305c0.18-1.034-0.144-2.146-0.953-2.877l-11.045-9.943c-1.193-1.071-3.198-1.139-4.459-0.146l-1.392,1.098   l0.55-7.6c0.116-1.6-1.102-2.907-2.705-2.907h-4.241V7.292C65.172,3.281,61.892,0,57.88,0H17.819c-4.011,0-7.292,3.281-7.292,7.292   V92.71c0,4.009,3.281,7.29,7.292,7.29H57.88c4.012,0,7.292-3.281,7.292-7.29V70.482h0.241c1.604,0,2.915-1.312,2.915-2.916v-1.449   c1.66,0.897,3.29,2.75,3.75,6.534c0.553,4.566-0.074,8.193-0.579,11.107c-0.301,1.734-0.56,3.231-0.56,4.679   c0,6.78,4.317,10.439,8.38,10.439c2.228,0,4.346-1.059,5.812-2.9c1.49-1.877,2.278-4.481,2.278-7.539   c0-5.536-0.67-10.292-1.318-14.894c-0.787-5.587-1.537-10.905-1.138-17.48c1.454-0.025,2.705-1.127,2.854-2.608l1.653-16.373   C89.488,36.812,89.464,36.554,89.417,36.305z M27.008,35.317c-1.512,0-2.738-1.227-2.738-2.737c0-1.515,1.227-2.738,2.738-2.738   c1.513,0,2.738,1.224,2.738,2.738C29.746,34.091,28.521,35.317,27.008,35.317z M37.851,35.317c-1.511,0-2.737-1.227-2.737-2.737   c0-1.515,1.227-2.738,2.737-2.738c1.514,0,2.739,1.224,2.739,2.738C40.59,34.091,39.364,35.317,37.851,35.317z M48.694,35.317   c-1.512,0-2.737-1.227-2.737-2.737c0-1.515,1.226-2.738,2.737-2.738c1.513,0,2.739,1.224,2.739,2.738   C51.434,34.091,50.207,35.317,48.694,35.317z M59.258,19.937c0,1.604-1.313,2.916-2.917,2.916H19.359   c-1.604,0-2.916-1.312-2.916-2.916v-9.825c0-1.604,1.312-2.916,2.916-2.916h36.981c1.604,0,2.917,1.312,2.917,2.916V19.937z    M81.167,92.824c-1.734,2.182-5.164,0.629-5.164-4.387c0-1.012,0.226-2.311,0.485-3.813c0.531-3.07,1.259-7.277,0.616-12.583   c-0.829-6.815-4.753-10.178-8.776-11.322v-1.161c0-1.604-1.312-2.916-2.915-2.916h-0.241v-13.07h2.096   c1.604,0,3.011-1.308,3.127-2.907l0.331-4.587l7.198,3.511l-0.065,12.875c-0.008,1.316,0.871,2.512,2.067,2.993   c-0.468,7.242,0.35,13.108,1.15,18.797c0.653,4.629,1.27,9.003,1.27,14.185C82.346,90.31,81.927,91.868,81.167,92.824z"/></g></svg>

						<span><?php echo esc_attr($vehicle_consumption_urban); ?>/<?php echo esc_attr($vehicle_consumption_highway); ?></span>

					</li>

				<?php } ?>

				<?php if(!empty($terms_vehicle_transmission)) { ?>

					<li class="autoroyal-vehicle-transmission">

						<svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M50,82A32,32,0,1,0,18,50,32,32,0,0,0,50,82ZM32.88,37a2,2,0,0,1,4,0V48H48V37a2,2,0,0,1,4,0V48H63.13V37a2,2,0,1,1,4,0V63a2,2,0,0,1-4,0V52H52V63a2,2,0,0,1-4,0V52H36.88V63a2,2,0,0,1-4,0Z"/></svg>

						<span><?php echo esc_attr($terms_vehicle_transmission); ?></span>

					</li>

				<?php } ?>

				<?php if(!empty($terms_vehicle_drive)) { ?>

					<li class="autoroyal-vehicle-transmission">

						<svg xmlns:svg="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" version="1.1" x="0px" y="0px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve"><g><path d="M325.763,602.711c-8.066,0-16.135-0.751-23.981-2.23c-10.853-2.046-21.313,5.094-23.359,15.948   c-2.047,10.854,5.093,21.312,15.948,23.359c10.284,1.939,20.846,2.923,31.393,2.923c45.001,0,87.309-17.524,119.129-49.346   c31.82-31.819,49.345-74.127,49.345-119.127c0-92.897-75.577-168.475-168.474-168.475s-168.474,75.577-168.474,168.475   c0,23.322,4.683,45.915,13.919,67.148c4.406,10.129,16.188,14.768,26.318,10.362c10.129-4.406,14.768-16.188,10.361-26.317   c-7.033-16.17-10.599-33.394-10.599-51.193c0-70.842,57.633-128.475,128.474-128.475c70.84,0,128.474,57.633,128.474,128.475   c0,34.315-13.363,66.578-37.629,90.844C392.342,589.347,360.079,602.711,325.763,602.711z"/><path d="M239.7,569.627c-8.199-7.402-20.846-6.756-28.248,1.441c-7.402,8.199-6.756,20.846,1.442,28.248   c5.047,4.557,10.422,8.85,15.976,12.76c3.5,2.464,7.518,3.647,11.496,3.647c6.287,0,12.477-2.956,16.371-8.487   c6.359-9.032,4.191-21.509-4.84-27.867C247.658,576.384,243.554,573.106,239.7,569.627z"/><path d="M617.458,424.134l-50.18-26.548c-4.355-13.725-9.896-27.088-16.545-39.899l16.719-54.28   c2.181-7.083,0.268-14.79-4.973-20.029l-45.856-45.856c-5.239-5.24-12.948-7.154-20.028-4.973l-54.28,16.72   c-12.813-6.649-26.176-12.191-39.9-16.547l-26.549-50.181c-3.465-6.55-10.268-10.646-17.678-10.646h-64.85   c-7.41,0-14.213,4.097-17.679,10.647l-26.547,50.181c-16.496,5.234-32.469,12.183-47.591,20.707   c-9.622,5.425-13.024,17.622-7.6,27.244s17.622,13.024,27.244,7.601c14.868-8.383,30.71-14.952,47.083-19.525   c5.285-1.476,9.731-5.059,12.298-9.909l24.837-46.945h40.758l24.838,46.945c2.566,4.851,7.013,8.434,12.298,9.91   c16.372,4.572,32.214,11.141,47.083,19.524c4.782,2.695,10.463,3.307,15.709,1.691l50.787-15.643l28.822,28.821l-15.643,50.788   c-1.615,5.246-1.004,10.926,1.691,15.707c8.382,14.868,14.95,30.71,19.523,47.085c1.477,5.285,5.06,9.731,9.91,12.298   l46.944,24.836v40.758l-46.944,24.836c-4.851,2.566-8.434,7.014-9.91,12.299c-4.574,16.377-11.143,32.219-19.523,47.084   c-5.424,9.622-2.021,21.82,7.602,27.244c3.104,1.75,6.477,2.581,9.803,2.581c6.984,0,13.767-3.664,17.441-10.182   c8.523-15.12,15.47-31.092,20.705-47.59l50.181-26.548c6.55-3.466,10.646-10.269,10.646-17.678v-64.85   C628.105,434.402,624.009,427.599,617.458,424.134z"/><path d="M534.195,636.813l-37.339,37.34l-50.786-15.644c-5.248-1.616-10.929-1.004-15.711,1.692   c-14.862,8.381-30.703,14.949-47.082,19.523c-5.285,1.477-9.732,5.06-12.299,9.91l-24.835,46.945h-40.76l-24.836-46.945   c-2.566-4.851-7.014-8.434-12.299-9.91c-16.38-4.574-32.221-11.143-47.08-19.523c-4.783-2.696-10.464-3.309-15.711-1.692   l-50.787,15.644l-28.822-28.822l15.643-50.787c1.615-5.247,1.004-10.928-1.692-15.71c-8.382-14.866-14.951-30.707-19.524-47.083   c-1.477-5.285-5.059-9.731-9.909-12.298L63.42,494.617v-40.76l46.945-24.836c4.851-2.566,8.433-7.013,9.909-12.298   c4.573-16.374,11.142-32.215,19.524-47.084c2.696-4.782,3.308-10.462,1.692-15.708l-15.643-50.788l37.339-37.339   c7.81-7.811,7.81-20.474-0.001-28.284s-20.474-7.811-28.284,0l-45.855,45.856c-5.239,5.239-7.152,12.946-4.972,20.029   l16.718,54.279c-6.648,12.813-12.19,26.176-16.546,39.9l-50.18,26.548c-6.55,3.465-10.647,10.268-10.647,17.679v64.852   c0,7.41,4.098,14.214,10.649,17.679l50.178,26.545c4.355,13.727,9.897,27.089,16.546,39.899l-16.718,54.281   c-2.181,7.082-0.268,14.789,4.972,20.028l45.856,45.857c5.24,5.239,12.948,7.153,20.03,4.972l54.278-16.719   c12.808,6.646,26.172,12.189,39.9,16.545l26.547,50.181c3.466,6.55,10.269,10.647,17.679,10.647h64.851   c7.41,0,14.213-4.098,17.679-10.647l26.547-50.181c13.729-4.355,27.092-9.896,39.901-16.545l54.278,16.719   c7.081,2.181,14.79,0.268,20.03-4.972l45.856-45.857c7.81-7.811,7.81-20.474-0.001-28.284S542.006,629.002,534.195,636.813z"/><path d="M642.711,325.764c0-92.898-75.577-168.476-168.475-168.476c-19.059,0-37.769,3.163-55.61,9.401   c-10.427,3.646-15.924,15.054-12.279,25.48c3.646,10.426,15.054,15.923,25.48,12.277c13.588-4.75,27.856-7.159,42.409-7.159   c70.841,0,128.475,57.634,128.475,128.476c0,13.914-2.206,27.588-6.557,40.643c-3.493,10.479,2.171,21.805,12.649,25.298   c2.1,0.699,4.23,1.031,6.327,1.031c8.374,0,16.178-5.301,18.972-13.682C639.814,361.914,642.711,343.984,642.711,325.764z"/><path d="M765.933,275.659l-50.18-26.547c-4.355-13.724-9.896-27.087-16.545-39.9l16.719-54.281   c2.181-7.081,0.268-14.789-4.973-20.028l-45.857-45.857c-5.24-5.24-12.947-7.153-20.029-4.972l-54.278,16.72   c-12.813-6.65-26.177-12.191-39.9-16.546l-26.548-50.179c-3.465-6.551-10.269-10.648-17.679-10.648h-64.85   c-7.41,0-14.213,4.098-17.679,10.647l-26.547,50.18c-13.725,4.354-27.088,9.896-39.9,16.546l-54.282-16.719   c-7.081-2.181-14.788-0.267-20.028,4.973l-45.855,45.855c-7.811,7.811-7.811,20.474-0.001,28.284   c7.811,7.811,20.475,7.811,28.284,0l37.34-37.338l50.787,15.641c5.246,1.617,10.928,1.006,15.71-1.69   c14.869-8.384,30.71-14.952,47.082-19.523c5.286-1.477,9.732-5.06,12.299-9.911l24.837-46.944h40.758l24.837,46.944   c2.566,4.852,7.014,8.435,12.3,9.911c16.371,4.571,32.212,11.14,47.082,19.523c4.783,2.695,10.463,3.308,15.709,1.69l50.786-15.643   l28.823,28.822l-15.643,50.788c-1.615,5.246-1.004,10.925,1.691,15.706c8.383,14.872,14.951,30.714,19.523,47.086   c1.477,5.286,5.059,9.732,9.91,12.299l46.944,24.835v40.759l-46.944,24.838c-4.852,2.566-8.434,7.013-9.91,12.298   c-4.572,16.369-11.141,32.211-19.523,47.084c-2.695,4.781-3.307,10.46-1.691,15.705l15.643,50.79l-37.34,37.336   c-7.811,7.811-7.811,20.474-0.001,28.284c3.905,3.906,9.023,5.859,14.143,5.859c5.118,0,10.237-1.953,14.142-5.857l45.857-45.854   c5.24-5.24,7.154-12.949,4.973-20.031l-16.719-54.282c6.648-12.813,12.189-26.176,16.545-39.896l50.182-26.55   c6.549-3.466,10.646-10.269,10.646-17.678v-64.851C776.58,285.927,772.482,279.124,765.933,275.659z"/></g></svg>

						<span><?php echo esc_attr($terms_vehicle_drive); ?></span>

					</li>

				<?php } ?>

			</ul>

			<h4 class="autoroyal-vehicle-block-meta-price"><?php echo autoroyal_price($price); ?></h4>

			<?php 

  				$listing_id = $car_ID; 

  				if ( ! empty( $cars_in_compare ) and in_array( $listing_id, $cars_in_compare ) ) {
					$car_compare_status       = esc_html__( 'Remove from compare', 'autoroyal' );
					$car_compare_status_class = "added";
				} else {
					$car_compare_status       = esc_html__( 'Add to compare', 'autoroyal' );
					$car_compare_status_class = "";
				}

				?>

  			<a href="#" class="fav-button btn btn-danger pull-right add-to-compare <?php echo esc_attr($car_compare_status_class); ?>" data-id="<?php echo esc_attr($listing_id); ?>" data-title="<?php echo esc_attr($vehicle_name); ?>" data-toggle="tooltip" data-placement="top"  data-original-title="<?php echo esc_attr($car_compare_status); ?>">
  				<svg class="add-to-compare-plus" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve"><path d="M129.2,72.3l-23.1,23.1c-11.2-3.4-23,2.8-26.4,14s2.8,23,14,26.4c11.2,3.4,23-2.8,26.4-14c1.7-5.4,1.1-11.2-1.6-16.2l22-22
L129.2,72.3z M100,120.7c-2.8,0-5.1-2.3-5.1-5.1s2.3-5.1,5.1-5.1c2.8,0,5.1,2.3,5.1,5.1l0,0C105.1,118.4,102.8,120.7,100,120.7z"/><g><path d="M40.8,30.2c0-5.1,2.2-8,8-8c5.8,0,8,2.9,8,8V54h23.5c4.2,0,8,2.2,8,8c0,5.8-3.8,8-8,8H56.8v23.5c0,5.1-2.2,8-8,8
c-5.8,0-8-2.9-8-8V70H17.3c-4.2,0-8-2.2-8-8c0-5.8,3.8-8,8-8h23.5V30.2z"/></g><g><path d="M162.6,48c-15.4-15-34.7-23.5-54.6-25.4v15.3c14.2,1.5,27.7,7,38.9,16l-12.2,12.2L146,77.4l12.2-12.2
c9,11.1,14.5,24.6,16,38.9H157v16h17.2c-1.5,14.2-7,27.7-16,38.9L146,146.8l-11.3,11.3l17.8,17.8c0.1,0.1,0.2,0.3,0.3,0.4
c3.1,3.1,8.2,3.1,11.3,0c0,0,0,0,0,0C199.1,140.4,198.4,83,162.6,48z"/><path d="M41.8,159c-8.9-11-14.4-24.4-16-38.5H9.7c1.9,20.3,10.6,40.2,26.2,55.8c3.1,3.1,8.2,3.1,11.3,0c0,0,0,0,0,0
c0.1-0.1,0.2-0.3,0.3-0.4l17.8-17.8L54,146.8L41.8,159z"/></g></svg>
				<svg class="add-to-compare-minus" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve"><path d="M129.2,72.3l-23.1,23.1c-11.2-3.4-23,2.8-26.4,14s2.8,23,14,26.4c11.2,3.4,23-2.8,26.4-14c1.7-5.4,1.1-11.2-1.6-16.2l22-22
L129.2,72.3z M100,120.7c-2.8,0-5.1-2.3-5.1-5.1s2.3-5.1,5.1-5.1c2.8,0,5.1,2.3,5.1,5.1l0,0C105.1,118.4,102.8,120.7,100,120.7z"/><g><path d="M162.6,48c-15.4-15-34.7-23.5-54.6-25.4v15.3c14.2,1.5,27.7,7,38.9,16l-12.2,12.2L146,77.4l12.2-12.2
c9,11.1,14.5,24.6,16,38.9H157v16h17.2c-1.5,14.2-7,27.7-16,38.9L146,146.8l-11.3,11.3l17.8,17.8c0.1,0.1,0.2,0.3,0.3,0.4
c3.1,3.1,8.2,3.1,11.3,0l0,0C199.1,140.4,198.4,83,162.6,48z"/><path d="M41.8,159c-8.9-11-14.4-24.4-16-38.5H9.7c1.9,20.3,10.6,40.2,26.2,55.8c3.1,3.1,8.2,3.1,11.3,0l0,0
c0.1-0.1,0.2-0.3,0.3-0.4l17.8-17.8L54,146.8L41.8,159z"/></g><path d="M17.3,70.2h23.5v0h16v0h23.5c4.2,0,8-2.2,8-8s-3.8-8-8-8H56.8h-16H17.3c-4.2,0-8,2.2-8,8S13.1,70.2,17.3,70.2z"/></svg>

  			</a>

			<?php 

				if( is_user_logged_in() ){

					$user_id = get_current_user_id();
    				$listing_id = $car_ID;
    				$user_type = "id";

    			} else {

    				$user_id = autoroyalGetIP();
    				$listing_id = $car_ID;
    				$user_type = "ip";

    			}

			?>

			<a href="#" type="button" class="fav-button btn btn-danger pull-right favorited add-to-favorite" data-id="<?php echo esc_attr($listing_id); ?>" data-user-id="<?php echo esc_attr($user_id); ?>" data-user-type="<?php echo esc_attr($user_type); ?>"> 
				<?php if( is_added_to_favorite( $user_type, $user_id, $listing_id ) ){ ?><i class="fa fa-heart"></i><?php } else { ?><i class="far fa-heart"></i><?php } ?>
			</a>

		</div>

	</div>

</div>